/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.blackbird.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.module.blackbird.deser.OptimizedSettableBeanProperty;
import java.io.IOException;
import java.util.function.BiConsumer;

final class SettableStringProperty
extends OptimizedSettableBeanProperty<SettableStringProperty> {
    private static final long serialVersionUID = 1L;
    private final BiConsumer<Object, String> _optimizedSetter;

    public SettableStringProperty(SettableBeanProperty src, BiConsumer<Object, String> optimizedSetter) {
        super(src);
        this._optimizedSetter = optimizedSetter;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableStringProperty(del, this._optimizedSetter);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        String text;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return;
            }
            text = (String)this._nullProvider.getNullValue(ctxt);
        } else {
            text = p.getValueAsString();
            if (text == null) {
                text = this._deserializeString(p, ctxt);
            }
        }
        this.set(bean, text);
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        String text;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return instance;
            }
            text = (String)this._nullProvider.getNullValue(ctxt);
        } else {
            text = p.getValueAsString();
            if (text == null) {
                text = this._deserializeString(p, ctxt);
            }
        }
        return this.setAndReturn(instance, text);
    }

    @Override
    public void set(Object bean, Object value) throws IOException {
        try {
            this._optimizedSetter.accept(bean, (String)value);
        }
        catch (Throwable e) {
            this._reportProblem(bean, value, e);
        }
    }
}

