/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.blackbird.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.module.blackbird.deser.OptimizedSettableBeanProperty;
import java.io.IOException;
import java.util.function.ObjLongConsumer;

final class SettableLongProperty
extends OptimizedSettableBeanProperty<SettableLongProperty> {
    private static final long serialVersionUID = 1L;
    private ObjLongConsumer<Object> _optimizedSetter;

    public SettableLongProperty(SettableBeanProperty src, ObjLongConsumer<Object> optimizedSetter) {
        super(src);
        this._optimizedSetter = optimizedSetter;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableLongProperty(del, this._optimizedSetter);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        long v = p.hasToken(JsonToken.VALUE_NUMBER_INT) ? p.getLongValue() : this._deserializeLong(p, ctxt);
        try {
            this._optimizedSetter.accept(bean, v);
        }
        catch (Throwable e) {
            this._reportProblem(bean, v, e);
        }
    }

    @Override
    public void set(Object bean, Object value) throws IOException {
        long v = ((Number)value).longValue();
        try {
            this._optimizedSetter.accept(bean, v);
        }
        catch (Throwable e) {
            this._reportProblem(bean, v, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        long l = p.hasToken(JsonToken.VALUE_NUMBER_INT) ? p.getLongValue() : this._deserializeLong(p, ctxt);
        return this.setAndReturn(instance, l);
    }
}

