/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.blackbird.deser;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.module.blackbird.deser.OptimizedSettableBeanProperty;
import java.io.IOException;
import java.util.function.ObjIntConsumer;

final class SettableIntProperty
extends OptimizedSettableBeanProperty<SettableIntProperty> {
    private static final long serialVersionUID = 1L;
    private ObjIntConsumer<Object> _optimizedSetter;

    public SettableIntProperty(SettableBeanProperty src, ObjIntConsumer<Object> optimizedSetter) {
        super(src);
        this._optimizedSetter = optimizedSetter;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableIntProperty(del, this._optimizedSetter);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws IOException {
        int v = p.hasToken(JsonToken.VALUE_NUMBER_INT) ? p.getIntValue() : this._deserializeInt(p, ctxt);
        try {
            this._optimizedSetter.accept(bean, v);
        }
        catch (Throwable e) {
            this._reportProblem(bean, v, e);
        }
    }

    @Override
    public void set(Object bean, Object value) throws IOException {
        int v = ((Number)value).intValue();
        try {
            this._optimizedSetter.accept(bean, v);
        }
        catch (Throwable e) {
            this._reportProblem(bean, v, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        int v = p.hasToken(JsonToken.VALUE_NUMBER_INT) ? p.getIntValue() : this._deserializeInt(p, ctxt);
        return this.setAndReturn(instance, v);
    }
}

