/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.SerializableString;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;

public class StringMethodPropertyWriter
extends OptimizedBeanPropertyWriter<StringMethodPropertyWriter> {
    public StringMethodPropertyWriter(BeanPropertyWriter src, BeanPropertyAccessor acc, int index, JsonSerializer<Object> ser) {
        super(src, acc, index, ser);
    }

    @Override
    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        return new StringMethodPropertyWriter(this, this._propertyAccessor, this._propertyIndex, ser);
    }

    @Override
    public StringMethodPropertyWriter withAccessor(BeanPropertyAccessor acc) {
        if (acc == null) {
            throw new IllegalArgumentException();
        }
        return new StringMethodPropertyWriter(this, acc, this._propertyIndex, (JsonSerializer<Object>)this._serializer);
    }

    @Override
    public void unsafeSerializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        String value = this._propertyAccessor.stringGetter(bean, this._propertyIndex);
        if (value == null) {
            if (!this._suppressNulls) {
                jgen.writeFieldName((SerializableString)this._name);
                prov.defaultSerializeNull(jgen);
            }
            return;
        }
        jgen.writeFieldName((SerializableString)this._name);
        jgen.writeString(value);
    }
}

