/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class OptimizedBeanPropertyWriter<T extends OptimizedBeanPropertyWriter<T>>
extends BeanPropertyWriter {
    protected final BeanPropertyAccessor _propertyAccessor;
    protected final int _propertyIndex;
    private final BeanPropertyWriter fallbackWriter;
    private boolean broken = false;

    protected OptimizedBeanPropertyWriter(BeanPropertyWriter beanPropertyWriter, BeanPropertyAccessor beanPropertyAccessor, int n, JsonSerializer<Object> jsonSerializer) {
        super(beanPropertyWriter);
        this.fallbackWriter = this.unwrapFallbackWriter(beanPropertyWriter);
        this._serializer = jsonSerializer;
        this._propertyAccessor = beanPropertyAccessor;
        this._propertyIndex = n;
    }

    private BeanPropertyWriter unwrapFallbackWriter(BeanPropertyWriter beanPropertyWriter) {
        while (beanPropertyWriter instanceof OptimizedBeanPropertyWriter) {
            beanPropertyWriter = ((OptimizedBeanPropertyWriter)beanPropertyWriter).fallbackWriter;
        }
        return beanPropertyWriter;
    }

    public abstract T withAccessor(BeanPropertyAccessor var1);

    public abstract BeanPropertyWriter withSerializer(JsonSerializer<Object> var1);

    public final void serializeAsField(Object object, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws Exception {
        if (this.broken) {
            this.fallbackWriter.serializeAsField(object, jsonGenerator, serializerProvider);
            return;
        }
        try {
            this.unsafeSerializeAsField(object, jsonGenerator, serializerProvider);
        }
        catch (IllegalAccessError illegalAccessError) {
            this._reportProblem(object, illegalAccessError);
            this.fallbackWriter.serializeAsField(object, jsonGenerator, serializerProvider);
        }
        catch (SecurityException securityException) {
            this._reportProblem(object, securityException);
            this.fallbackWriter.serializeAsField(object, jsonGenerator, serializerProvider);
        }
    }

    public abstract void unsafeSerializeAsField(Object var1, JsonGenerator var2, SerializerProvider var3) throws Exception;

    protected void _reportProblem(Object object, Throwable throwable) {
        this.broken = true;
        String string = String.format("Disabling Afterburner serialization for type %s, field #%d, due to access error (type %s, message=%s)%n", object.getClass(), this._propertyIndex, throwable.getClass().getName(), throwable.getMessage());
        Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, string, throwable);
    }
}

