/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.afterburner.ser;

import com.fasterxml.jackson.module.afterburner.asm.ClassWriter;
import com.fasterxml.jackson.module.afterburner.asm.Label;
import com.fasterxml.jackson.module.afterburner.asm.MethodVisitor;
import com.fasterxml.jackson.module.afterburner.asm.Type;
import com.fasterxml.jackson.module.afterburner.ser.BeanPropertyAccessor;
import com.fasterxml.jackson.module.afterburner.ser.IntFieldPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.IntMethodPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.LongFieldPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.LongMethodPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.ObjectFieldPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.ObjectMethodPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.OptimizedBeanPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.StringFieldPropertyWriter;
import com.fasterxml.jackson.module.afterburner.ser.StringMethodPropertyWriter;
import com.fasterxml.jackson.module.afterburner.util.DynamicPropertyAccessorBase;
import com.fasterxml.jackson.module.afterburner.util.MyClassLoader;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyAccessorCollector
extends DynamicPropertyAccessorBase {
    private final ArrayList<IntMethodPropertyWriter> _intGetters = new ArrayList();
    private final ArrayList<LongMethodPropertyWriter> _longGetters = new ArrayList();
    private final ArrayList<StringMethodPropertyWriter> _stringGetters = new ArrayList();
    private final ArrayList<ObjectMethodPropertyWriter> _objectGetters = new ArrayList();
    private final ArrayList<IntFieldPropertyWriter> _intFields = new ArrayList();
    private final ArrayList<LongFieldPropertyWriter> _longFields = new ArrayList();
    private final ArrayList<StringFieldPropertyWriter> _stringFields = new ArrayList();
    private final ArrayList<ObjectFieldPropertyWriter> _objectFields = new ArrayList();

    public IntMethodPropertyWriter addIntGetter(BeanPropertyWriter bpw) {
        return this._add(this._intGetters, new IntMethodPropertyWriter(bpw, null, this._intGetters.size(), null));
    }

    public LongMethodPropertyWriter addLongGetter(BeanPropertyWriter bpw) {
        return this._add(this._longGetters, new LongMethodPropertyWriter(bpw, null, this._longGetters.size(), null));
    }

    public StringMethodPropertyWriter addStringGetter(BeanPropertyWriter bpw) {
        return this._add(this._stringGetters, new StringMethodPropertyWriter(bpw, null, this._stringGetters.size(), null));
    }

    public ObjectMethodPropertyWriter addObjectGetter(BeanPropertyWriter bpw) {
        return this._add(this._objectGetters, new ObjectMethodPropertyWriter(bpw, null, this._objectGetters.size(), null));
    }

    public IntFieldPropertyWriter addIntField(BeanPropertyWriter bpw) {
        return this._add(this._intFields, new IntFieldPropertyWriter(bpw, null, this._intFields.size(), null));
    }

    public LongFieldPropertyWriter addLongField(BeanPropertyWriter bpw) {
        return this._add(this._longFields, new LongFieldPropertyWriter(bpw, null, this._longFields.size(), null));
    }

    public StringFieldPropertyWriter addStringField(BeanPropertyWriter bpw) {
        return this._add(this._stringFields, new StringFieldPropertyWriter(bpw, null, this._stringFields.size(), null));
    }

    public ObjectFieldPropertyWriter addObjectField(BeanPropertyWriter bpw) {
        return this._add(this._objectFields, new ObjectFieldPropertyWriter(bpw, null, this._objectFields.size(), null));
    }

    public boolean isEmpty() {
        return this._intGetters.isEmpty() && this._longGetters.isEmpty() && this._stringGetters.isEmpty() && this._objectGetters.isEmpty() && this._intFields.isEmpty() && this._longFields.isEmpty() && this._stringFields.isEmpty() && this._objectFields.isEmpty();
    }

    public BeanPropertyAccessor findAccessor(Class<?> beanType, MyClassLoader classLoader) {
        if (classLoader == null) {
            classLoader = new MyClassLoader(beanType.getClassLoader(), true);
        }
        String srcName = beanType.getName() + "$Access4JacksonSerializer";
        String generatedClass = PropertyAccessorCollector.internalClassName(srcName);
        Class<?> accessorClass = null;
        try {
            accessorClass = classLoader.loadClass(srcName);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (accessorClass == null) {
            accessorClass = this.generateAccessorClass(beanType, classLoader, srcName, generatedClass);
        }
        try {
            return (BeanPropertyAccessor)accessorClass.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to generate accessor class '" + srcName + "': " + e.getMessage(), e);
        }
    }

    public Class<?> generateAccessorClass(Class<?> beanType, MyClassLoader classLoader, String srcName, String generatedClass) {
        ClassWriter cw = new ClassWriter(1);
        String superClass = PropertyAccessorCollector.internalClassName(BeanPropertyAccessor.class.getName());
        cw.visit(49, 33, generatedClass, null, superClass, null);
        cw.visitSource(srcName + ".java", null);
        MethodVisitor mv = cw.visitMethod(1, "<init>", "()V", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 0);
        mv.visitMethodInsn(183, superClass, "<init>", "()V");
        mv.visitInsn(177);
        mv.visitMaxs(0, 0);
        mv.visitEnd();
        String beanClass = PropertyAccessorCollector.internalClassName(beanType.getName());
        if (!this._intFields.isEmpty()) {
            PropertyAccessorCollector._addIntFields(cw, this._intFields, beanClass);
        }
        if (!this._longFields.isEmpty()) {
            PropertyAccessorCollector._addLongFields(cw, this._longFields, beanClass);
        }
        if (!this._stringFields.isEmpty()) {
            PropertyAccessorCollector._addStringFields(cw, this._stringFields, beanClass);
        }
        if (!this._objectFields.isEmpty()) {
            PropertyAccessorCollector._addObjectFields(cw, this._objectFields, beanClass);
        }
        if (!this._intGetters.isEmpty()) {
            PropertyAccessorCollector._addIntGetters(cw, this._intGetters, beanClass);
        }
        if (!this._longGetters.isEmpty()) {
            PropertyAccessorCollector._addLongGetters(cw, this._longGetters, beanClass);
        }
        if (!this._stringGetters.isEmpty()) {
            PropertyAccessorCollector._addStringGetters(cw, this._stringGetters, beanClass);
        }
        if (!this._objectGetters.isEmpty()) {
            PropertyAccessorCollector._addObjectGetters(cw, this._objectGetters, beanClass);
        }
        cw.visitEnd();
        byte[] byteCode = cw.toByteArray();
        return classLoader.loadAndResolve(srcName, byteCode);
    }

    private static void _addIntGetters(ClassWriter cw, List<IntMethodPropertyWriter> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "intGetter", "(Ljava/lang/Object;I)I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 3);
        if (props.size() <= 4) {
            PropertyAccessorCollector._addGettersUsingIf(mv, props, beanClass, 172, ALL_INT_CONSTS);
        } else {
            PropertyAccessorCollector._addGettersUsingSwitch(mv, props, beanClass, 172);
        }
        PropertyAccessorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void _addLongGetters(ClassWriter cw, List<LongMethodPropertyWriter> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "longGetter", "(Ljava/lang/Object;I)J", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 3);
        if (props.size() < 4) {
            PropertyAccessorCollector._addGettersUsingIf(mv, props, beanClass, 173, ALL_INT_CONSTS);
        } else {
            PropertyAccessorCollector._addGettersUsingSwitch(mv, props, beanClass, 173);
        }
        PropertyAccessorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void _addStringGetters(ClassWriter cw, List<StringMethodPropertyWriter> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "stringGetter", "(Ljava/lang/Object;I)Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 3);
        if (props.size() < 4) {
            PropertyAccessorCollector._addGettersUsingIf(mv, props, beanClass, 176, ALL_INT_CONSTS);
        } else {
            PropertyAccessorCollector._addGettersUsingSwitch(mv, props, beanClass, 176);
        }
        PropertyAccessorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void _addObjectGetters(ClassWriter cw, List<ObjectMethodPropertyWriter> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "objectGetter", "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 3);
        if (props.size() < 4) {
            PropertyAccessorCollector._addGettersUsingIf(mv, props, beanClass, 176, ALL_INT_CONSTS);
        } else {
            PropertyAccessorCollector._addGettersUsingSwitch(mv, props, beanClass, 176);
        }
        PropertyAccessorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void _addIntFields(ClassWriter cw, List<IntFieldPropertyWriter> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "intField", "(Ljava/lang/Object;I)I", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 3);
        if (props.size() < 4) {
            PropertyAccessorCollector._addFieldsUsingIf(mv, props, beanClass, 172, ALL_INT_CONSTS);
        } else {
            PropertyAccessorCollector._addFieldsUsingSwitch(mv, props, beanClass, 172, "I");
        }
        PropertyAccessorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void _addLongFields(ClassWriter cw, List<LongFieldPropertyWriter> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "longField", "(Ljava/lang/Object;I)J", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 3);
        if (props.size() < 4) {
            PropertyAccessorCollector._addFieldsUsingIf(mv, props, beanClass, 173, ALL_INT_CONSTS);
        } else {
            PropertyAccessorCollector._addFieldsUsingSwitch(mv, props, beanClass, 173, "J");
        }
        PropertyAccessorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void _addStringFields(ClassWriter cw, List<StringFieldPropertyWriter> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "stringField", "(Ljava/lang/Object;I)Ljava/lang/String;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 3);
        if (props.size() < 4) {
            PropertyAccessorCollector._addFieldsUsingIf(mv, props, beanClass, 176, ALL_INT_CONSTS);
        } else {
            PropertyAccessorCollector._addFieldsUsingSwitch(mv, props, beanClass, 176, "Ljava/lang/String;");
        }
        PropertyAccessorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static void _addObjectFields(ClassWriter cw, List<ObjectFieldPropertyWriter> props, String beanClass) {
        MethodVisitor mv = cw.visitMethod(1, "objectField", "(Ljava/lang/Object;I)Ljava/lang/Object;", null, null);
        mv.visitCode();
        mv.visitVarInsn(25, 1);
        mv.visitTypeInsn(192, beanClass);
        mv.visitVarInsn(58, 3);
        if (props.size() < 4) {
            PropertyAccessorCollector._addFieldsUsingIf(mv, props, beanClass, 176, ALL_INT_CONSTS);
        } else {
            PropertyAccessorCollector._addFieldsUsingSwitch(mv, props, beanClass, 176, "Ljava/lang/Object;");
        }
        PropertyAccessorCollector.generateException(mv, beanClass, props.size());
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private static <T extends OptimizedBeanPropertyWriter<T>> void _addGettersUsingIf(MethodVisitor mv, List<T> props, String beanClass, int returnOpcode, int[] constantOpcodes) {
        mv.visitVarInsn(21, 2);
        Label next = new Label();
        mv.visitJumpInsn(154, next);
        mv.visitVarInsn(25, 3);
        Method method = (Method)((OptimizedBeanPropertyWriter)((Object)props.get(0))).getMember().getMember();
        mv.visitMethodInsn(182, beanClass, method.getName(), "()" + Type.getDescriptor(method.getReturnType()));
        mv.visitInsn(returnOpcode);
        int len = props.size();
        for (int i = 1; i < len; ++i) {
            mv.visitLabel(next);
            next = new Label();
            mv.visitVarInsn(21, 2);
            mv.visitInsn(constantOpcodes[i]);
            mv.visitJumpInsn(160, next);
            mv.visitVarInsn(25, 3);
            method = (Method)((OptimizedBeanPropertyWriter)((Object)props.get(i))).getMember().getMember();
            mv.visitMethodInsn(182, beanClass, method.getName(), "()" + Type.getDescriptor(method.getReturnType()));
            mv.visitInsn(returnOpcode);
        }
        mv.visitLabel(next);
    }

    private static <T extends OptimizedBeanPropertyWriter<T>> void _addGettersUsingSwitch(MethodVisitor mv, List<T> props, String beanClass, int returnOpcode) {
        mv.visitVarInsn(21, 2);
        Label[] labels = new Label[props.size()];
        int len = labels.length;
        for (int i = 0; i < len; ++i) {
            labels[i] = new Label();
        }
        Label defaultLabel = new Label();
        mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
        int len2 = labels.length;
        for (int i = 0; i < len2; ++i) {
            mv.visitLabel(labels[i]);
            mv.visitVarInsn(25, 3);
            Method method = (Method)((OptimizedBeanPropertyWriter)((Object)props.get(i))).getMember().getMember();
            mv.visitMethodInsn(182, beanClass, method.getName(), "()" + Type.getDescriptor(method.getReturnType()));
            mv.visitInsn(returnOpcode);
        }
        mv.visitLabel(defaultLabel);
    }

    private static <T extends OptimizedBeanPropertyWriter<T>> void _addFieldsUsingIf(MethodVisitor mv, List<T> props, String beanClass, int returnOpcode, int[] constantOpcodes) {
        mv.visitVarInsn(21, 2);
        Label next = new Label();
        mv.visitJumpInsn(154, next);
        mv.visitVarInsn(25, 3);
        AnnotatedField field = (AnnotatedField)((OptimizedBeanPropertyWriter)((Object)props.get(0))).getMember();
        mv.visitFieldInsn(180, beanClass, field.getName(), Type.getDescriptor(field.getRawType()));
        mv.visitInsn(returnOpcode);
        int len = props.size();
        for (int i = 1; i < len; ++i) {
            mv.visitLabel(next);
            next = new Label();
            mv.visitVarInsn(21, 2);
            mv.visitInsn(constantOpcodes[i]);
            mv.visitJumpInsn(160, next);
            mv.visitVarInsn(25, 3);
            field = (AnnotatedField)((OptimizedBeanPropertyWriter)((Object)props.get(i))).getMember();
            mv.visitFieldInsn(180, beanClass, field.getName(), Type.getDescriptor(field.getRawType()));
            mv.visitInsn(returnOpcode);
        }
        mv.visitLabel(next);
    }

    private static <T extends OptimizedBeanPropertyWriter<T>> void _addFieldsUsingSwitch(MethodVisitor mv, List<T> props, String beanClass, int returnOpcode, String fieldSignature) {
        mv.visitVarInsn(21, 2);
        Label[] labels = new Label[props.size()];
        int len = labels.length;
        for (int i = 0; i < len; ++i) {
            labels[i] = new Label();
        }
        Label defaultLabel = new Label();
        mv.visitTableSwitchInsn(0, labels.length - 1, defaultLabel, labels);
        int len2 = labels.length;
        for (int i = 0; i < len2; ++i) {
            mv.visitLabel(labels[i]);
            mv.visitVarInsn(25, 3);
            AnnotatedField field = (AnnotatedField)((OptimizedBeanPropertyWriter)((Object)props.get(i))).getMember();
            mv.visitFieldInsn(180, beanClass, field.getName(), Type.getDescriptor(field.getRawType()));
            mv.visitInsn(returnOpcode);
        }
        mv.visitLabel(defaultLabel);
    }
}

