/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.comp;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.jr.ob.comp.ArrayComposer;
import com.fasterxml.jackson.jr.ob.comp.ComposerBase;
import com.fasterxml.jackson.jr.ob.comp.ObjectComposer;
import java.io.IOException;

public abstract class SequenceComposer<THIS extends SequenceComposer<THIS>>
extends ComposerBase {
    protected final JsonGenerator _generator;

    public SequenceComposer(JsonGenerator jsonGenerator) {
        this._generator = jsonGenerator;
    }

    @Override
    public void flush() throws IOException {
        if (this._generator != null) {
            this._generator.close();
        }
    }

    public ArrayComposer<THIS> startArray() throws IOException, JsonProcessingException {
        this._closeChild();
        return this._startArray(this._this(), this._generator);
    }

    public ObjectComposer<THIS> startObject() throws IOException, JsonProcessingException {
        this._closeChild();
        return this._startObject(this._this(), this._generator);
    }

    public THIS add(int n) throws IOException, JsonProcessingException {
        this._generator.writeNumber(n);
        return this._this();
    }

    public THIS add(long l) throws IOException, JsonProcessingException {
        this._generator.writeNumber(l);
        return this._this();
    }

    public THIS add(double d) throws IOException, JsonProcessingException {
        this._generator.writeNumber(d);
        return this._this();
    }

    public THIS add(String string) throws IOException, JsonProcessingException {
        this._generator.writeString(string);
        return this._this();
    }

    public THIS add(CharSequence charSequence) throws IOException, JsonProcessingException {
        String string = charSequence == null ? null : ((Object)charSequence).toString();
        this._generator.writeString(string);
        return this._this();
    }

    public THIS addNull() throws IOException, JsonProcessingException {
        this._generator.writeNull();
        return this._this();
    }

    public THIS add(boolean bl) throws IOException, JsonProcessingException {
        this._generator.writeBoolean(bl);
        return this._this();
    }

    public THIS addObject(Object object) throws IOException, JsonProcessingException {
        this._generator.writeObject(object);
        return this._this();
    }

    protected void _closeChild() throws IOException, JsonProcessingException {
        if (this._child != null) {
            this._child._finish();
            this._child = null;
        }
    }

    protected THIS _this() {
        return (THIS)this;
    }
}

