/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.impl.JSONReader;
import com.fasterxml.jackson.jr.ob.impl.ValueReader;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

public class SimpleValueReader
extends ValueReader {
    protected final int _typeId;
    protected final Class<?> _rawType;

    public SimpleValueReader(int n, Class<?> clazz) {
        this._typeId = n;
        this._rawType = clazz;
    }

    @Override
    public Object read(JSONReader jSONReader, JsonParser jsonParser) throws IOException {
        switch (this._typeId) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            case 5: {
                return this._readIntArray(jsonParser);
            }
            case 8: {
                return jSONReader._treeCodec().readTree(jsonParser);
            }
            case 9: 
            case 10: {
                return jsonParser.getValueAsString();
            }
            case 11: {
                return jsonParser.getValueAsString().toCharArray();
            }
            case 12: {
                return this._readBinary(jsonParser);
            }
            case 17: {
                return Float.valueOf((float)jsonParser.getValueAsDouble());
            }
            case 18: {
                return jsonParser.getValueAsDouble();
            }
            case 13: {
                return (byte)jsonParser.getValueAsInt();
            }
            case 14: {
                return (short)jsonParser.getValueAsInt();
            }
            case 15: {
                return jsonParser.getValueAsInt();
            }
            case 16: {
                return jsonParser.getValueAsLong();
            }
            case 20: {
                return jsonParser.getDecimalValue();
            }
            case 19: {
                return jsonParser.getBigIntegerValue();
            }
            case 21: {
                return jsonParser.getValueAsBoolean();
            }
            case 22: {
                String string = jsonParser.getValueAsString();
                return Character.valueOf(string == null || string.isEmpty() ? (char)' ' : string.charAt(0));
            }
            case 25: {
                long l = this._fetchLong(jsonParser);
                Calendar calendar = Calendar.getInstance();
                calendar.setTimeInMillis(l);
                return calendar;
            }
            case 24: {
                return new Date(this._fetchLong(jsonParser));
            }
            case 26: {
                String string = jsonParser.getValueAsString();
                try {
                    return Class.forName(string);
                }
                catch (Exception exception) {
                    throw new JSONObjectException("Failed to bind java.lang.Class from value '" + string + "'");
                }
            }
            case 27: {
                return new File(jsonParser.getValueAsString());
            }
            case 28: {
                return UUID.fromString(jsonParser.getValueAsString());
            }
            case 29: {
                return new URL(jsonParser.getValueAsString());
            }
            case 30: {
                return URI.create(jsonParser.getValueAsString());
            }
        }
        throw JSONObjectException.from(jsonParser, "Can not create a " + this._rawType.getName() + " instance out of " + this._tokenDesc(jsonParser));
    }

    protected byte[] _readBinary(JsonParser jsonParser) throws IOException {
        return jsonParser.getBinaryValue();
    }

    protected int[] _readIntArray(JsonParser jsonParser) throws IOException {
        throw new JSONObjectException("Reading of int[] not yet implemented");
    }

    protected long _fetchLong(JsonParser jsonParser) throws IOException {
        JsonToken jsonToken = jsonParser.getCurrentToken();
        if (jsonToken == JsonToken.VALUE_NUMBER_INT) {
            return jsonParser.getLongValue();
        }
        throw JSONObjectException.from(jsonParser, "Can not get long numeric value from JSON (to construct " + this._rawType.getName() + ") from " + SimpleValueReader._tokenDesc(jsonParser, jsonToken));
    }
}

