/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob.impl;

import com.fasterxml.jackson.jr.ob.JSON;
import com.fasterxml.jackson.jr.ob.api.ReaderWriterModifier;
import com.fasterxml.jackson.jr.ob.api.ReaderWriterProvider;
import com.fasterxml.jackson.jr.ob.api.ValueWriter;
import com.fasterxml.jackson.jr.ob.impl.BeanPropertyIntrospector;
import com.fasterxml.jackson.jr.ob.impl.BeanPropertyWriter;
import com.fasterxml.jackson.jr.ob.impl.BeanWriter;
import com.fasterxml.jackson.jr.ob.impl.ClassKey;
import com.fasterxml.jackson.jr.ob.impl.JSONWriter;
import com.fasterxml.jackson.jr.ob.impl.POJODefinition;
import com.fasterxml.jackson.jr.ob.impl.ValueLocatorBase;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public class ValueWriterLocator
extends ValueLocatorBase {
    protected final BeanPropertyWriter[] NO_PROPS_FOR_WRITE = new BeanPropertyWriter[0];
    protected final ConcurrentHashMap<ClassKey, Integer> _knownSerTypes;
    protected final CopyOnWriteArrayList<ValueWriter> _knownWriters;
    protected final ReaderWriterProvider _writerProvider;
    protected final ReaderWriterModifier _writerModifier;
    protected final int _features;
    protected final JSONWriter _writeContext;
    private ClassKey _key;
    private Class<?> _prevClass;
    private int _prevType;

    protected ValueWriterLocator(int n, ReaderWriterProvider readerWriterProvider, ReaderWriterModifier readerWriterModifier) {
        this._features = n;
        this._knownSerTypes = new ConcurrentHashMap(20, 0.75f, 2);
        this._knownWriters = new CopyOnWriteArrayList();
        this._writeContext = null;
        this._writerProvider = readerWriterProvider;
        this._writerModifier = readerWriterModifier;
    }

    protected ValueWriterLocator(ValueWriterLocator valueWriterLocator, int n, JSONWriter jSONWriter) {
        this._features = n;
        this._writeContext = jSONWriter;
        this._knownSerTypes = valueWriterLocator._knownSerTypes;
        this._knownWriters = valueWriterLocator._knownWriters;
        this._writerProvider = valueWriterLocator._writerProvider;
        this._writerModifier = valueWriterLocator._writerModifier;
    }

    public static final ValueWriterLocator blueprint(ReaderWriterProvider readerWriterProvider, ReaderWriterModifier readerWriterModifier) {
        return new ValueWriterLocator(0, readerWriterProvider, readerWriterModifier);
    }

    public ValueWriterLocator with(ReaderWriterProvider readerWriterProvider) {
        if (readerWriterProvider == this._writerProvider) {
            return this;
        }
        return new ValueWriterLocator(this._features, readerWriterProvider, this._writerModifier);
    }

    public ValueWriterLocator with(ReaderWriterModifier readerWriterModifier) {
        if (readerWriterModifier == this._writerModifier) {
            return this;
        }
        return new ValueWriterLocator(this._features, this._writerProvider, readerWriterModifier);
    }

    public ValueWriterLocator perOperationInstance(JSONWriter jSONWriter, int n) {
        return new ValueWriterLocator(this, n & CACHE_FLAGS, jSONWriter);
    }

    public ValueWriter getValueWriter(int n) {
        if (n < 0) {
            n = -(n + 1);
        }
        return this._knownWriters.get(n);
    }

    public final int findSerializationType(Class<?> clazz) {
        int n;
        if (clazz == this._prevClass) {
            return this._prevType;
        }
        if (clazz == String.class && this._writerModifier == null) {
            return 9;
        }
        ClassKey classKey = this._key == null ? new ClassKey(clazz, this._features) : this._key.with(clazz, this._features);
        Integer n2 = this._knownSerTypes.get(classKey);
        if (n2 == null) {
            n = this._findPOJOSerializationType(clazz);
            this._knownSerTypes.put(new ClassKey(clazz, this._features), n);
        } else {
            n = n2;
        }
        this._prevType = n;
        this._prevClass = clazz;
        return n;
    }

    protected POJODefinition _resolveBeanDef(Class<?> clazz) {
        try {
            POJODefinition pOJODefinition;
            if (this._writerModifier != null && (pOJODefinition = this._writerModifier.pojoDefinitionForSerialization(this._writeContext, clazz)) != null) {
                return pOJODefinition;
            }
            return BeanPropertyIntrospector.instance().pojoDefinitionForSerialization(this._writeContext, clazz);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException(String.format("Failed to introspect ClassDefinition for type '%s': %s", clazz.getName(), exception.getMessage()), exception);
        }
    }

    protected int _findPOJOSerializationType(Class<?> clazz) {
        ValueWriter valueWriter;
        ValueWriter valueWriter2;
        if (this._writerProvider != null && (valueWriter2 = this._writerProvider.findValueWriter(this._writeContext, clazz)) != null) {
            return this._modifyAndRegisterWriter(clazz, valueWriter2);
        }
        int n = this._findSimpleType(clazz, true);
        if (n == 0) {
            if (JSON.Feature.HANDLE_JAVA_BEANS.isEnabled(this._features)) {
                BeanPropertyWriter[] beanPropertyWriterArray = this._resolveBeanForSer(clazz, this._resolveBeanDef(clazz));
                return this._modifyAndRegisterWriter(clazz, new BeanWriter(clazz, beanPropertyWriterArray));
            }
        } else if (this._writerModifier != null && (valueWriter = this._writerModifier.overrideStandardValueWriter(this._writeContext, clazz, n)) != null) {
            return this._registerWriter(clazz, valueWriter);
        }
        return n;
    }

    private int _modifyAndRegisterWriter(Class<?> clazz, ValueWriter valueWriter) {
        if (this._writerModifier != null && (valueWriter = this._writerModifier.modifyValueWriter(this._writeContext, clazz, valueWriter)) == null) {
            throw new IllegalArgumentException("ReaderWriterModifier.modifyValueWriter() returned null");
        }
        return this._registerWriter(clazz, valueWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int _registerWriter(Class<?> clazz, ValueWriter valueWriter) {
        CopyOnWriteArrayList<ValueWriter> copyOnWriteArrayList = this._knownWriters;
        synchronized (copyOnWriteArrayList) {
            ClassKey classKey = new ClassKey(clazz, this._features);
            Integer n = this._knownSerTypes.get(classKey);
            if (n != null) {
                return n;
            }
            this._knownWriters.add(valueWriter);
            int n2 = -this._knownWriters.size();
            this._knownSerTypes.put(classKey, n2);
            return n2;
        }
    }

    protected BeanPropertyWriter[] _resolveBeanForSer(Class<?> clazz, POJODefinition pOJODefinition) {
        BeanPropertyWriter[] beanPropertyWriterArray;
        int n;
        List<POJODefinition.Prop> list = pOJODefinition.getProperties();
        int n2 = list.size();
        ArrayList<BeanPropertyWriter> arrayList = new ArrayList<BeanPropertyWriter>(n2);
        boolean bl = JSON.Feature.WRITE_READONLY_BEAN_PROPERTIES.isEnabled(this._features);
        boolean bl2 = JSON.Feature.FORCE_REFLECTION_ACCESS.isEnabled(this._features);
        boolean bl3 = JSON.Feature.USE_FIELDS.isEnabled(this._features);
        for (n = 0; n < n2; ++n) {
            Class<?> clazz2;
            Field field;
            beanPropertyWriterArray = list.get(n);
            Method method = beanPropertyWriterArray.getter;
            if (method == null && JSON.Feature.USE_IS_GETTERS.isEnabled(this._features)) {
                method = beanPropertyWriterArray.isGetter;
            }
            Field field2 = field = bl3 ? beanPropertyWriterArray.field : null;
            if (method == null && field == null || !bl && !beanPropertyWriterArray.hasSetter()) continue;
            if (method != null) {
                clazz2 = method.getReturnType();
                if (bl2) {
                    method.setAccessible(true);
                }
            } else {
                clazz2 = field.getType();
                if (bl2) {
                    field.setAccessible(true);
                }
            }
            int n3 = this._findSimpleType(clazz2, true);
            arrayList.add(new BeanPropertyWriter(n3, beanPropertyWriterArray.name, beanPropertyWriterArray.field, method));
        }
        n = arrayList.size();
        beanPropertyWriterArray = n == 0 ? this.NO_PROPS_FOR_WRITE : arrayList.toArray(this.NO_PROPS_FOR_WRITE);
        return beanPropertyWriterArray;
    }
}

