/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.jr.ob;

import com.fasterxml.jackson.core.JsonLocation;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.TreeCodec;
import com.fasterxml.jackson.jr.ob.JSONObjectException;
import com.fasterxml.jackson.jr.ob.impl.JSONReader;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;

public class ValueIterator<T>
implements Iterator<T>,
Closeable {
    protected static final int MODE_BEAN = 1;
    protected static final int MODE_ANY = 2;
    protected static final int MODE_TREE = 3;
    protected static final ValueIterator<?> EMPTY_ITERATOR = new ValueIterator(1, null, null, null, null, false);
    protected static final int STATE_CLOSED = 0;
    protected static final int STATE_NEED_RESYNC = 1;
    protected static final int STATE_MAY_HAVE_VALUE = 2;
    protected static final int STATE_HAS_VALUE = 3;
    protected final int _mode;
    protected final Class<?> _type;
    protected final JSONReader _reader;
    protected final TreeCodec _treeCodec;
    protected final JsonParser _parser;
    protected final JsonStreamContext _seqContext;
    protected final boolean _closeParser;
    protected int _state;

    protected ValueIterator(int n, Class<?> clazz, JsonParser jsonParser, JSONReader jSONReader, TreeCodec treeCodec, boolean bl) {
        this._mode = n;
        this._type = clazz;
        this._parser = jsonParser;
        this._reader = jSONReader;
        this._treeCodec = treeCodec;
        this._closeParser = bl;
        if (jsonParser == null) {
            this._seqContext = null;
            this._state = 0;
        } else {
            JsonStreamContext jsonStreamContext = jsonParser.getParsingContext();
            if (bl && jsonParser.isExpectedStartArrayToken()) {
                jsonParser.clearCurrentToken();
            } else {
                JsonToken jsonToken = jsonParser.getCurrentToken();
                if (jsonToken == JsonToken.START_OBJECT || jsonToken == JsonToken.START_ARRAY) {
                    jsonStreamContext = jsonStreamContext.getParent();
                }
            }
            this._seqContext = jsonStreamContext;
            this._state = 2;
        }
    }

    protected static <T> ValueIterator<T> emptyIterator() {
        return EMPTY_ITERATOR;
    }

    @Override
    public boolean hasNext() {
        try {
            return this.hasNextValue();
        }
        catch (JSONObjectException jSONObjectException) {
            return (Boolean)this._handleMappingException(jSONObjectException);
        }
        catch (IOException iOException) {
            return (Boolean)this._handleIOException(iOException);
        }
    }

    @Override
    public T next() {
        try {
            return this.nextValue();
        }
        catch (JSONObjectException jSONObjectException) {
            return (T)this._handleMappingException(jSONObjectException);
        }
        catch (IOException iOException) {
            return (T)this._handleIOException(iOException);
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void close() throws IOException {
        if (this._state != 0) {
            this._state = 0;
            if (this._parser != null) {
                this._parser.close();
            }
        }
    }

    public boolean hasNextValue() throws IOException {
        switch (this._state) {
            case 0: {
                return false;
            }
            case 1: {
                this._resync();
            }
            case 2: {
                JsonToken jsonToken = this._parser.getCurrentToken();
                if (jsonToken == null && ((jsonToken = this._parser.nextToken()) == null || jsonToken == JsonToken.END_ARRAY)) {
                    this._state = 0;
                    if (this._closeParser && this._parser != null) {
                        this._parser.close();
                    }
                    return false;
                }
                this._state = 3;
                return true;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T nextValue() throws IOException {
        switch (this._state) {
            case 0: {
                return (T)this._throwNoSuchElement();
            }
            case 1: 
            case 2: {
                if (this.hasNextValue()) break;
                return (T)this._throwNoSuchElement();
            }
        }
        int n = 1;
        try {
            Object object;
            Object object2;
            switch (this._mode) {
                case 1: {
                    object2 = this._reader.readBean(this._type);
                    break;
                }
                case 2: {
                    object2 = this._reader.readValue();
                    break;
                }
                case 3: {
                    object2 = this._treeCodec.readTree(this._parser);
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid mode: " + this._mode);
                }
            }
            n = 2;
            Object object3 = object = object2;
            return (T)object3;
        }
        finally {
            this._state = n;
            this._parser.clearCurrentToken();
        }
    }

    public List<T> readAll() throws IOException {
        return this.readAll((Collection)new ArrayList());
    }

    public <L extends List<? super T>> L readAll(L l) throws IOException {
        while (this.hasNextValue()) {
            l.add(this.nextValue());
        }
        return l;
    }

    public <C extends Collection<? super T>> C readAll(C c) throws IOException {
        while (this.hasNextValue()) {
            c.add(this.nextValue());
        }
        return c;
    }

    public JsonParser getParser() {
        return this._parser;
    }

    public JsonLocation getCurrentLocation() {
        return this._parser.getCurrentLocation();
    }

    protected void _resync() throws IOException {
        JsonParser jsonParser = this._parser;
        if (jsonParser.getParsingContext() == this._seqContext) {
            return;
        }
        while (true) {
            JsonToken jsonToken;
            if ((jsonToken = jsonParser.nextToken()) == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT) {
                if (jsonParser.getParsingContext() != this._seqContext) continue;
                jsonParser.clearCurrentToken();
                return;
            }
            if (jsonToken == JsonToken.START_ARRAY || jsonToken == JsonToken.START_OBJECT) {
                jsonParser.skipChildren();
                continue;
            }
            if (jsonToken == null) break;
        }
    }

    protected <R> R _throwNoSuchElement() {
        throw new NoSuchElementException();
    }

    protected <R> R _handleMappingException(JSONObjectException jSONObjectException) {
        throw new RuntimeException(jSONObjectException.getMessage(), (Throwable)((Object)jSONObjectException));
    }

    protected <R> R _handleIOException(IOException iOException) {
        throw new RuntimeException(iOException.getMessage(), iOException);
    }
}

