/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.xml.jaxb;

import com.fasterxml.jackson.xml.XmlAnnotationIntrospector;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.namespace.QName;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedClass;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

public class XmlJaxbAnnotationIntrospector
extends JaxbAnnotationIntrospector
implements XmlAnnotationIntrospector {
    @Override
    public String findNamespace(Annotated ann) {
        String ns = null;
        if (ann instanceof AnnotatedClass) {
            XmlRootElement elem = this.findRootElementAnnotation((AnnotatedClass)ann);
            if (elem != null) {
                ns = elem.namespace();
            }
        } else {
            XmlAttribute attr;
            XmlElement elem = (XmlElement)this.findAnnotation(XmlElement.class, ann, false, false, false);
            if (elem != null) {
                ns = elem.namespace();
            }
            if ((ns == null || "##default".equals(ns)) && (attr = (XmlAttribute)this.findAnnotation(XmlAttribute.class, ann, false, false, false)) != null) {
                ns = attr.namespace();
            }
        }
        if ("##default".equals(ns)) {
            ns = null;
        }
        return ns;
    }

    @Override
    public Boolean isOutputAsAttribute(Annotated ann) {
        XmlAttribute attr = (XmlAttribute)this.findAnnotation(XmlAttribute.class, ann, false, false, false);
        if (attr != null) {
            return Boolean.TRUE;
        }
        XmlElement elem = (XmlElement)this.findAnnotation(XmlElement.class, ann, false, false, false);
        if (elem != null) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public QName findWrapperElement(Annotated ann) {
        XmlElementWrapper w = (XmlElementWrapper)this.findAnnotation(XmlElementWrapper.class, ann, false, false, false);
        if (w != null) {
            return new QName(this.handleJaxbDefault(w.namespace()), this.handleJaxbDefault(w.name()));
        }
        return null;
    }

    @Override
    public QName findRootElement(Annotated ann) {
        XmlRootElement root = (XmlRootElement)this.findAnnotation(XmlRootElement.class, ann, false, false, false);
        if (root != null) {
            return new QName(this.handleJaxbDefault(root.namespace()), this.handleJaxbDefault(root.name()));
        }
        return null;
    }

    private XmlRootElement findRootElementAnnotation(AnnotatedClass ac) {
        return (XmlRootElement)this.findAnnotation(XmlRootElement.class, (Annotated)ac, true, false, true);
    }

    private String handleJaxbDefault(String value) {
        return "##default".equals(value) ? "" : value;
    }
}

