/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.xml.ser;

import com.fasterxml.jackson.xml.XmlAnnotationIntrospector;
import com.fasterxml.jackson.xml.ser.XmlBeanPropertyWriter;
import com.fasterxml.jackson.xml.ser.XmlBeanSerializer;
import com.fasterxml.jackson.xml.util.XmlInfo;
import java.util.List;
import javax.xml.namespace.QName;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedMember;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.codehaus.jackson.map.ser.BeanSerializer;
import org.codehaus.jackson.map.ser.BeanSerializerModifier;
import org.codehaus.jackson.type.JavaType;

public class XmlBeanSerializerModifier
extends BeanSerializerModifier {
    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BasicBeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        AnnotationIntrospector intr = config.getAnnotationIntrospector();
        int len = beanProperties.size();
        for (int i = 0; i < len; ++i) {
            BeanPropertyWriter bpw = beanProperties.get(i);
            AnnotatedMember member = bpw.getMember();
            String ns = XmlBeanSerializerModifier.findNamespaceAnnotation(intr, member);
            Boolean isAttribute = XmlBeanSerializerModifier.findIsAttributeAnnotation(intr, member);
            bpw.setInternalSetting((Object)XmlBeanSerializer.KEY_XML_INFO, (Object)new XmlInfo(isAttribute, ns));
            if (!XmlBeanSerializerModifier._isContainerType(bpw.getType())) continue;
            String localName = null;
            String wrapperNs = null;
            QName wrappedName = new QName(ns, bpw.getName());
            QName wrapperName = XmlBeanSerializerModifier.findWrapperName(intr, member);
            if (wrapperName != null) {
                localName = wrapperName.getLocalPart();
                wrapperNs = wrapperName.getNamespaceURI();
            }
            wrapperName = localName == null || localName.length() == 0 ? wrappedName : new QName(wrapperNs == null ? "" : wrapperNs, localName);
            beanProperties.set(i, new XmlBeanPropertyWriter(bpw, wrapperName, wrappedName));
        }
        return beanProperties;
    }

    public JsonSerializer<?> modifySerializer(SerializationConfig config, BasicBeanDescription beanDesc, JsonSerializer<?> serializer) {
        if (!(serializer instanceof BeanSerializer)) {
            return serializer;
        }
        return new XmlBeanSerializer((BeanSerializer)serializer);
    }

    private static boolean _isContainerType(JavaType type) {
        if (type.isContainerType()) {
            return type.getRawClass() != byte[].class;
        }
        return false;
    }

    private static String findNamespaceAnnotation(AnnotationIntrospector ai, AnnotatedMember prop) {
        for (AnnotationIntrospector intr : ai.allIntrospectors()) {
            String ns;
            if (!(intr instanceof XmlAnnotationIntrospector) || (ns = ((XmlAnnotationIntrospector)intr).findNamespace((Annotated)prop)) == null) continue;
            return ns;
        }
        return null;
    }

    private static Boolean findIsAttributeAnnotation(AnnotationIntrospector ai, AnnotatedMember prop) {
        for (AnnotationIntrospector intr : ai.allIntrospectors()) {
            Boolean b;
            if (!(intr instanceof XmlAnnotationIntrospector) || (b = ((XmlAnnotationIntrospector)intr).isOutputAsAttribute((Annotated)prop)) == null) continue;
            return b;
        }
        return null;
    }

    private static QName findWrapperName(AnnotationIntrospector ai, AnnotatedMember prop) {
        for (AnnotationIntrospector intr : ai.allIntrospectors()) {
            QName n;
            if (!(intr instanceof XmlAnnotationIntrospector) || (n = ((XmlAnnotationIntrospector)intr).findWrapperElement((Annotated)prop)) == null) continue;
            return n;
        }
        return null;
    }
}

