/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.xml.ser;

import com.fasterxml.jackson.xml.ser.ToXmlGenerator;
import javax.xml.namespace.QName;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializerProvider;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.codehaus.jackson.map.ser.impl.PropertySerializerMap;

public class XmlBeanPropertyWriter
extends BeanPropertyWriter {
    protected final QName _wrapperName;
    protected final QName _wrappedName;

    public XmlBeanPropertyWriter(BeanPropertyWriter wrapped, QName wrapperName, QName wrappedName) {
        super(wrapped);
        this._wrapperName = wrapperName;
        this._wrappedName = wrappedName;
    }

    public XmlBeanPropertyWriter(BeanPropertyWriter wrapped, QName wrapperName, QName wrappedName, JsonSerializer<Object> serializer) {
        super(wrapped, serializer);
        this._wrapperName = wrapperName;
        this._wrappedName = wrappedName;
    }

    public BeanPropertyWriter withSerializer(JsonSerializer<Object> ser) {
        if (((Object)((Object)this)).getClass() != XmlBeanPropertyWriter.class) {
            throw new IllegalStateException("Sub-class does not override 'withSerializer()'; needs to!");
        }
        return new XmlBeanPropertyWriter(this, this._wrapperName, this._wrappedName, ser);
    }

    public void serializeAsField(Object bean, JsonGenerator jgen, SerializerProvider prov) throws Exception {
        Class<?> cls;
        PropertySerializerMap map;
        Object value = this.get(bean);
        if (value == null) {
            if (!this._suppressNulls) {
                jgen.writeFieldName(this._name);
                prov.defaultSerializeNull(jgen);
            }
            return;
        }
        if (value == bean) {
            this._reportSelfReference(bean);
        }
        if (this._suppressableValue != null && this._suppressableValue.equals(value)) {
            return;
        }
        ToXmlGenerator xmlGen = (ToXmlGenerator)jgen;
        xmlGen.startWrappedValue(this._wrapperName, this._wrappedName);
        JsonSerializer ser = this._serializer;
        if (ser == null && (ser = (map = this._dynamicSerializers).serializerFor(cls = value.getClass())) == null) {
            ser = this._findAndAddDynamic(map, cls, prov);
        }
        jgen.writeFieldName(this._name);
        if (this._typeSerializer == null) {
            ser.serialize(value, jgen, prov);
        } else {
            ser.serializeWithType(value, jgen, prov, this._typeSerializer);
        }
        xmlGen.finishWrappedValue(this._wrapperName, this._wrappedName);
    }
}

