/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.xml;

import java.util.Collection;
import org.codehaus.jackson.annotate.JsonTypeInfo;
import org.codehaus.jackson.map.jsontype.NamedType;
import org.codehaus.jackson.map.jsontype.TypeIdResolver;
import org.codehaus.jackson.map.jsontype.impl.ClassNameIdResolver;
import org.codehaus.jackson.map.jsontype.impl.MinimalClassNameIdResolver;
import org.codehaus.jackson.map.jsontype.impl.StdTypeResolverBuilder;
import org.codehaus.jackson.type.JavaType;

public class XmlTypeResolverBuilder
extends StdTypeResolverBuilder {
    public StdTypeResolverBuilder init(JsonTypeInfo.Id idType, TypeIdResolver idRes) {
        super.init(idType, idRes);
        if (this._typeProperty != null) {
            this._typeProperty = XmlTypeResolverBuilder.sanitizeXmlTypeName(this._typeProperty);
        }
        return this;
    }

    public StdTypeResolverBuilder typeProperty(String typeIdPropName) {
        if (typeIdPropName == null || typeIdPropName.length() == 0) {
            typeIdPropName = this._idType.getDefaultPropertyName();
        }
        this._typeProperty = XmlTypeResolverBuilder.sanitizeXmlTypeName(typeIdPropName);
        return this;
    }

    protected TypeIdResolver idResolver(JavaType baseType, Collection<NamedType> subtypes, boolean forSer, boolean forDeser) {
        if (this._customIdResolver != null) {
            return this._customIdResolver;
        }
        switch (this._idType) {
            case CLASS: {
                return new XmlClassNameIdResolver(baseType);
            }
            case MINIMAL_CLASS: {
                return new XmlMinimalClassNameIdResolver(baseType);
            }
        }
        return super.idResolver(baseType, subtypes, forSer, forDeser);
    }

    protected static String sanitizeXmlTypeName(String name) {
        StringBuilder sb = new StringBuilder(name);
        int changes = 0;
        int len = name.length();
        for (int i = 0; i < len; ++i) {
            char c = name.charAt(i);
            if (c > '\u007f' || c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '.' || c == '-') continue;
            ++changes;
            sb.setCharAt(i, '_');
        }
        if (changes == 0) {
            return name;
        }
        return sb.toString();
    }

    protected static String encodeXmlClassName(String className) {
        int ix = className.lastIndexOf(36);
        if (ix >= 0) {
            StringBuilder sb = new StringBuilder(className);
            do {
                sb.replace(ix, ix + 1, "..");
            } while ((ix = className.lastIndexOf(36, ix - 1)) >= 0);
            className = sb.toString();
        }
        return className;
    }

    protected static String decodeXmlClassName(String className) {
        int ix = className.lastIndexOf("..");
        if (ix >= 0) {
            StringBuilder sb = new StringBuilder(className);
            do {
                sb.replace(ix, ix + 2, "$");
            } while ((ix = className.lastIndexOf("..", ix - 1)) >= 0);
            className = sb.toString();
        }
        return className;
    }

    protected static class XmlMinimalClassNameIdResolver
    extends MinimalClassNameIdResolver {
        public XmlMinimalClassNameIdResolver(JavaType baseType) {
            super(baseType);
        }

        public String idFromValue(Object value) {
            return XmlTypeResolverBuilder.encodeXmlClassName(super.idFromValue(value));
        }

        public JavaType typeFromId(String id) {
            return super.typeFromId(XmlTypeResolverBuilder.decodeXmlClassName(id));
        }
    }

    protected static class XmlClassNameIdResolver
    extends ClassNameIdResolver {
        public XmlClassNameIdResolver(JavaType baseType) {
            super(baseType);
        }

        public String idFromValue(Object value) {
            return XmlTypeResolverBuilder.encodeXmlClassName(super.idFromValue(value));
        }

        public JavaType typeFromId(String id) {
            return super.typeFromId(XmlTypeResolverBuilder.decodeXmlClassName(id));
        }
    }
}

