/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.xml;

import com.fasterxml.jackson.xml.XmlAnnotationIntrospector;
import com.fasterxml.jackson.xml.XmlTypeResolverBuilder;
import com.fasterxml.jackson.xml.annotate.JacksonXmlElementWrapper;
import com.fasterxml.jackson.xml.annotate.JacksonXmlProperty;
import javax.xml.namespace.QName;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.AnnotatedParameter;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.map.jsontype.impl.StdTypeResolverBuilder;

public class JacksonXmlAnnotationIntrospector
extends JacksonAnnotationIntrospector
implements XmlAnnotationIntrospector {
    @Override
    public Boolean isOutputAsAttribute(Annotated ann) {
        JacksonXmlProperty prop = (JacksonXmlProperty)ann.getAnnotation(JacksonXmlProperty.class);
        if (prop != null) {
            return prop.isAttribute() ? Boolean.TRUE : Boolean.FALSE;
        }
        return null;
    }

    @Override
    public String findNamespace(Annotated ann) {
        JacksonXmlProperty prop = (JacksonXmlProperty)ann.getAnnotation(JacksonXmlProperty.class);
        if (prop != null) {
            return prop.namespace();
        }
        return null;
    }

    @Override
    public QName findWrapperElement(Annotated ann) {
        JacksonXmlElementWrapper w = (JacksonXmlElementWrapper)ann.getAnnotation(JacksonXmlElementWrapper.class);
        if (w != null) {
            return new QName(w.namespace(), w.localName());
        }
        return null;
    }

    public String findSerializablePropertyName(AnnotatedField af) {
        JacksonXmlProperty pann = (JacksonXmlProperty)af.getAnnotation(JacksonXmlProperty.class);
        if (pann != null) {
            return pann.localName();
        }
        return super.findSerializablePropertyName(af);
    }

    public String findSettablePropertyName(AnnotatedMethod am) {
        JacksonXmlProperty pann = (JacksonXmlProperty)am.getAnnotation(JacksonXmlProperty.class);
        if (pann != null) {
            return pann.localName();
        }
        return super.findSettablePropertyName(am);
    }

    public String findDeserializablePropertyName(AnnotatedField af) {
        JacksonXmlProperty pann = (JacksonXmlProperty)af.getAnnotation(JacksonXmlProperty.class);
        if (pann != null) {
            return pann.localName();
        }
        return super.findDeserializablePropertyName(af);
    }

    public String findPropertyNameForParam(AnnotatedParameter ap) {
        String name;
        JacksonXmlProperty pann = (JacksonXmlProperty)ap.getAnnotation(JacksonXmlProperty.class);
        if (pann != null && (name = pann.localName()).length() > 0) {
            return name;
        }
        return super.findPropertyNameForParam(ap);
    }

    protected StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new XmlTypeResolverBuilder();
    }
}

