/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.in;

import com.fasterxml.aalto.impl.ErrorConsts;
import com.fasterxml.aalto.in.ElementScope;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.PNameC;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.StreamScanner;
import com.fasterxml.aalto.util.DataUtil;
import com.fasterxml.aalto.util.XmlCharTypes;
import com.fasterxml.aalto.util.XmlChars;
import java.io.InputStream;
import javax.xml.stream.XMLStreamException;

public final class Utf8Scanner
extends StreamScanner {
    public Utf8Scanner(ReaderConfig cfg, InputStream in, byte[] buffer, int ptr, int last) {
        super(cfg, in, buffer, ptr, last);
    }

    @Override
    protected final void finishToken() throws XMLStreamException {
        this._tokenIncomplete = false;
        switch (this._currToken) {
            case 3: {
                this.finishPI();
                break;
            }
            case 4: {
                this.finishCharacters();
                break;
            }
            case 5: {
                this.finishComment();
                break;
            }
            case 6: {
                this.finishSpace();
                break;
            }
            case 11: {
                this.finishDTD(true);
                break;
            }
            case 12: {
                this.finishCData();
                break;
            }
            default: {
                ErrorConsts.throwInternalError();
            }
        }
    }

    @Override
    protected int handleStartElement(byte b) throws XMLStreamException {
        boolean allBound;
        this._currToken = 1;
        this._currNsCount = 0;
        PName elemName = this.parsePName(b);
        String prefix = elemName.getPrefix();
        if (prefix == null) {
            allBound = true;
        } else {
            elemName = this.bindName(elemName, prefix);
            allBound = elemName.isBound();
        }
        this._tokenName = elemName;
        this._currElem = new ElementScope(elemName, this._currElem);
        int attrPtr = 0;
        while (true) {
            boolean isNsDecl;
            PName attrName;
            int c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((c = (b = this._inputBuffer[this._inputPtr++]) & 0xFF) <= 32) {
                do {
                    if (c == 10) {
                        this.markLF();
                    } else if (c == 13) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                    } else if (c != 32 && c != 9) {
                        this.throwInvalidSpace(c);
                    }
                    if (this._inputPtr < this._inputEnd) continue;
                    this.loadMoreGuaranteed();
                } while ((c = (b = this._inputBuffer[this._inputPtr++]) & 0xFF) <= 32);
            } else if (c != 47 && c != 62) {
                c = this.decodeCharForError(b);
                this.throwUnexpectedChar(c, " expected space, or '>' or \"/>\"");
            }
            if (c == 47) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((b = this._inputBuffer[this._inputPtr++]) != 62) {
                    c = this.decodeCharForError(b);
                    this.throwUnexpectedChar(c, " expected '>'");
                }
                this._isEmptyTag = true;
                break;
            }
            if (c == 62) {
                this._isEmptyTag = false;
                break;
            }
            if (c == 60) {
                this.reportInputProblem("Unexpected '<' character in element (missing closing '>'?)");
            }
            if ((prefix = (attrName = this.parsePName(b)).getPrefix()) == null) {
                isNsDecl = attrName.getLocalName() == "xmlns";
            } else if (prefix == "xmlns") {
                isNsDecl = true;
            } else {
                attrName = this.bindName(attrName, prefix);
                if (allBound) {
                    allBound = attrName.isBound();
                }
                isNsDecl = false;
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = (b = this._inputBuffer[this._inputPtr++]) & 0xFF) > 32) break;
                if (c == 10) {
                    this.markLF();
                    continue;
                }
                if (c == 13) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (c == 32 || c == 9) continue;
                this.throwInvalidSpace(c);
            }
            if (c != 61) {
                c = this.decodeCharForError(b);
                this.throwUnexpectedChar(c, " expected '='");
            }
            while (true) {
                if (this._inputPtr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                }
                if ((c = (b = this._inputBuffer[this._inputPtr++]) & 0xFF) > 32) break;
                if (c == 10) {
                    this.markLF();
                    continue;
                }
                if (c == 13) {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    continue;
                }
                if (c == 32 || c == 9) continue;
                this.throwInvalidSpace(c);
            }
            if (c != 34 && c != 39) {
                c = this.decodeCharForError(b);
                this.throwUnexpectedChar(c, " Expected a quote");
            }
            if (isNsDecl) {
                this.handleNsDeclaration(attrName, b);
                ++this._currNsCount;
                continue;
            }
            attrPtr = this.collectValue(attrPtr, b, attrName);
        }
        int act = this._attrCollector.finishLastValue(attrPtr);
        if (act < 0) {
            act = this._attrCollector.getCount();
            this.reportInputProblem(this._attrCollector.getErrorMsg());
        }
        this._attrCount = act;
        ++this._depth;
        if (!allBound) {
            if (!elemName.isBound()) {
                this.reportUnboundPrefix(this._tokenName, false);
            }
            int len = this._attrCount;
            for (int i = 0; i < len; ++i) {
                PName attrName = this._attrCollector.getName(i);
                if (attrName.isBound()) continue;
                this.reportUnboundPrefix(attrName, true);
            }
        }
        return 1;
    }

    /*
     * Unable to fully structure code
     */
    private final int collectValue(int attrPtr, byte quoteByte, PName attrName) throws XMLStreamException {
        attrBuffer = this._attrCollector.startNewValue(attrName, attrPtr);
        TYPES = this._charTypes.ATTR_CHARS;
        quoteChar = quoteByte;
        block13: while (true) {
            block25: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (attrPtr >= attrBuffer.length) {
                    attrBuffer = this._attrCollector.valueBufferFull();
                }
                if ((max2 = ptr + (attrBuffer.length - attrPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = this._inputBuffer[ptr++] & 255] == 0) {
                        attrBuffer[attrPtr++] = (char)c;
                        continue;
                    }
                    break block25;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                }
                case 3: {
                    this.markLF();
                }
                case 8: {
                    c = 32;
                    ** GOTO lbl63
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl63
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl63
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    attrBuffer[attrPtr++] = (char)(55296 | c >> 10);
                    c = 56320 | c & 1023;
                    if (attrPtr >= attrBuffer.length) {
                        attrBuffer = this._attrCollector.valueBufferFull();
                    }
                    ** GOTO lbl63
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    this.throwUnexpectedChar(c, "'<' not allowed in attribute value");
                }
                case 10: {
                    c = this.handleEntityInText(false);
                    if (c == 0) {
                        this.reportUnexpandedEntityInAttr(attrName, false);
                    }
                    if (c >> 16 != 0) {
                        attrBuffer[attrPtr++] = (char)(55296 | (c -= 65536) >> 10);
                        c = 56320 | c & 1023;
                        if (attrPtr >= attrBuffer.length) {
                            attrBuffer = this._attrCollector.valueBufferFull();
                        }
                    }
                    ** GOTO lbl63
                }
                case 14: {
                    if (c == quoteChar) break block13;
                }
lbl63:
                // 7 sources

                default: {
                    attrBuffer[attrPtr++] = (char)c;
                    continue block13;
                }
            }
            break;
        }
        return attrPtr;
    }

    private void handleNsDeclaration(PName name, byte quoteByte) throws XMLStreamException {
        int attrPtr = 0;
        char[] attrBuffer = this._nameBuffer;
        while (true) {
            int c;
            int b;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b = this._inputBuffer[this._inputPtr++]) == quoteByte) break;
            if (b == 38) {
                c = this.handleEntityInText(false);
                if (c == 0) {
                    this.reportUnexpandedEntityInAttr(name, true);
                }
                if (c >> 16 != 0) {
                    if (attrPtr >= attrBuffer.length) {
                        this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
                    }
                    attrBuffer[attrPtr++] = (char)(0xD800 | (c -= 65536) >> 10);
                    c = 0xDC00 | c & 0x3FF;
                }
            } else if (b == 60) {
                c = b;
                this.throwUnexpectedChar(c, "'<' not allowed in attribute value");
            } else {
                c = b & 0xFF;
                if (c < 32) {
                    if (c == 10) {
                        this.markLF();
                    } else if (c == 13) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                    } else if (c < 0) {
                        if ((c = this.decodeMultiByteChar(c, this._inputPtr)) < 0) {
                            c = -c;
                            if (attrPtr >= attrBuffer.length) {
                                this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
                            }
                            attrBuffer[attrPtr++] = (char)(0xD800 | (c -= 65536) >> 10);
                            c = 0xDC00 | c & 0x3FF;
                        }
                    } else if (c != 9) {
                        this.throwInvalidSpace(c);
                    }
                }
            }
            if (attrPtr >= attrBuffer.length) {
                this._nameBuffer = attrBuffer = DataUtil.growArrayBy(attrBuffer, attrBuffer.length);
            }
            attrBuffer[attrPtr++] = (char)c;
        }
        if (attrPtr == 0) {
            this.bindNs(name, "");
        } else {
            String uri = this._config.canonicalizeURI(attrBuffer, attrPtr);
            this.bindNs(name, uri);
        }
    }

    @Override
    protected final int handleEntityInText(boolean inAttr) throws XMLStreamException {
        int cix;
        String start;
        byte b;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((b = this._inputBuffer[this._inputPtr++]) == 35) {
            return this.handleCharEntity();
        }
        if (b == 97) {
            byte by = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (b == 109) {
                byte by2 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b == 112) {
                    byte by3 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                    if (b == 59) {
                        return 38;
                    }
                    start = "amp";
                } else {
                    start = "am";
                }
            } else if (b == 112) {
                byte by4 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b == 111) {
                    byte by5 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                    if (b == 115) {
                        byte by6 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                        if (b == 59) {
                            return 39;
                        }
                        start = "apos";
                    } else {
                        start = "apo";
                    }
                } else {
                    start = "ap";
                }
            } else {
                start = "a";
            }
        } else if (b == 108) {
            byte by = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (b == 116) {
                byte by7 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b == 59) {
                    return 60;
                }
                start = "lt";
            } else {
                start = "l";
            }
        } else if (b == 103) {
            byte by = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (b == 116) {
                byte by8 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b == 59) {
                    return 62;
                }
                start = "gt";
            } else {
                start = "g";
            }
        } else if (b == 113) {
            byte by = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
            if (b == 117) {
                byte by9 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                if (b == 111) {
                    byte by10 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                    if (b == 116) {
                        byte by11 = b = this._inputPtr < this._inputEnd ? this._inputBuffer[this._inputPtr++] : this.loadOne();
                        if (b == 59) {
                            return 34;
                        }
                        start = "quot";
                    } else {
                        start = "quo";
                    }
                } else {
                    start = "qu";
                }
            } else {
                start = "q";
            }
        } else {
            start = "";
        }
        int[] TYPES = this._charTypes.NAME_CHARS;
        char[] cbuf = this._nameBuffer;
        int len = start.length();
        for (cix = 0; cix < len; ++cix) {
            cbuf[cix] = start.charAt(cix);
        }
        while (b != 59) {
            boolean ok;
            int c = b & 0xFF;
            switch (TYPES[c]) {
                case 0: 
                case 1: 
                case 2: {
                    ok = cix > 0;
                    break;
                }
                case 3: {
                    ok = true;
                    break;
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ok = XmlChars.is10NameStartChar(c);
                    break;
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ok = XmlChars.is10NameStartChar(c);
                    break;
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    ok = XmlChars.is10NameStartChar(c);
                    if (!ok) break;
                    if (cix >= cbuf.length) {
                        this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
                    }
                    cbuf[cix++] = (char)(0xD800 | (c -= 65536) >> 10);
                    c = 0xDC00 | c & 0x3FF;
                    break;
                }
                default: {
                    ok = false;
                }
            }
            if (!ok) {
                this.reportInvalidNameChar(c, cix);
            }
            if (cix >= cbuf.length) {
                this._nameBuffer = cbuf = DataUtil.growArrayBy(cbuf, cbuf.length);
            }
            cbuf[cix++] = (char)c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            b = this._inputBuffer[this._inputPtr++];
        }
        String pname = new String(cbuf, 0, cix);
        this._tokenName = new PNameC(pname, null, pname, 0);
        if (this._config.willExpandEntities()) {
            this.reportInputProblem("General entity reference (&" + pname + ";) encountered in entity expanding mode: operation not (yet) implemented");
        }
        if (inAttr) {
            this.reportInputProblem("General entity reference (&" + pname + ";) encountered in attribute value, in non-entity-expanding mode: no way to handle it");
        }
        return 0;
    }

    @Override
    protected String parsePublicId(byte quoteChar) throws XMLStreamException {
        char[] outputBuffer = this._nameBuffer;
        int outPtr = 0;
        int[] TYPES = XmlCharTypes.PUBID_CHARS;
        boolean addSpace = false;
        while (true) {
            byte b;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if ((b = this._inputBuffer[this._inputPtr++]) == quoteChar) break;
            int c = b & 0xFF;
            if (TYPES[c] != 1) {
                this.throwUnexpectedChar(c, " in public identifier");
            }
            if (c <= 32) {
                addSpace = true;
                continue;
            }
            if (addSpace) {
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                outputBuffer[outPtr++] = 32;
                addSpace = false;
            }
            if (outPtr >= outputBuffer.length) {
                this._nameBuffer = outputBuffer = DataUtil.growArrayBy(outputBuffer, outputBuffer.length);
                outPtr = 0;
            }
            outputBuffer[outPtr++] = (char)c;
        }
        return new String(outputBuffer, 0, outPtr);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected String parseSystemId(byte quoteChar) throws XMLStreamException {
        char[] outputBuffer = this._nameBuffer;
        int outPtr = 0;
        int[] TYPES = this._charTypes.ATTR_CHARS;
        while (true) {
            int c;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (TYPES[c = this._inputBuffer[this._inputPtr++] & 0xFF] != 0) {
                switch (TYPES[c]) {
                    case 1: {
                        c = this.handleInvalidXmlChar(c);
                    }
                    case 2: {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr] == 10) {
                            ++this._inputPtr;
                        }
                        this.markLF();
                        c = 10;
                        break;
                    }
                    case 3: {
                        this.markLF();
                        break;
                    }
                    case 5: {
                        c = this.decodeUtf8_2(c);
                        break;
                    }
                    case 6: {
                        c = this.decodeUtf8_3(c);
                        break;
                    }
                    case 7: {
                        c = this.decodeUtf8_4(c);
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        outputBuffer[outPtr++] = (char)(0xD800 | c >> 10);
                        c = 0xDC00 | c & 0x3FF;
                        break;
                    }
                    case 4: {
                        this.reportInvalidInitial(c);
                    }
                    case 14: {
                        if (c != quoteChar) break;
                        return new String(outputBuffer, 0, outPtr);
                    }
                }
            }
            if (outPtr >= outputBuffer.length) {
                this._nameBuffer = outputBuffer = DataUtil.growArrayBy(outputBuffer, outputBuffer.length);
                outPtr = 0;
            }
            outputBuffer[outPtr++] = (char)c;
        }
    }

    @Override
    protected final boolean skipCharacters() throws XMLStreamException {
        int[] TYPES = this._charTypes.TEXT_CHARS;
        byte[] inputBuffer = this._inputBuffer;
        block12: while (true) {
            int c;
            int ptr;
            block19: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 0xFF] == 0) continue;
                    break block19;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2(c);
                    break;
                }
                case 6: {
                    this.skipUtf8_3(c);
                    break;
                }
                case 7: {
                    this.skipUtf8_4(c);
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    --this._inputPtr;
                    return false;
                }
                case 10: {
                    c = this.handleEntityInText(false);
                    if (c != 0) break;
                    return true;
                }
                case 11: {
                    byte b;
                    int count = 1;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((b = inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++count;
                    }
                    if (b != 62 || count <= true) continue block12;
                    this.reportIllegalCDataEnd();
                }
            }
        }
    }

    @Override
    protected final void skipComment() throws XMLStreamException {
        int[] TYPES = this._charTypes.OTHER_CHARS;
        byte[] inputBuffer = this._inputBuffer;
        while (true) {
            int c;
            int ptr;
            block18: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 0xFF] == 0) continue;
                    break block18;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2(c);
                    break;
                }
                case 6: {
                    this.skipUtf8_3(c);
                    break;
                }
                case 7: {
                    this.skipUtf8_4(c);
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 13: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] != 45) break;
                    ++this._inputPtr;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr++] != 62) {
                        this.reportDoubleHyphenInComments();
                    }
                    return;
                }
            }
        }
    }

    @Override
    protected final void skipCData() throws XMLStreamException {
        int[] TYPES = this._charTypes.OTHER_CHARS;
        byte[] inputBuffer = this._inputBuffer;
        while (true) {
            int c;
            int ptr;
            block18: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 0xFF] == 0) continue;
                    break block18;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2(c);
                    break;
                }
                case 6: {
                    this.skipUtf8_3(c);
                    break;
                }
                case 7: {
                    this.skipUtf8_4(c);
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 11: {
                    byte b;
                    int count = 0;
                    do {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        ++count;
                    } while ((b = this._inputBuffer[this._inputPtr++]) == 93);
                    if (b == 62) {
                        if (count <= 1) break;
                        return;
                    }
                    --this._inputPtr;
                }
            }
        }
    }

    @Override
    protected final void skipPI() throws XMLStreamException {
        int[] TYPES = this._charTypes.OTHER_CHARS;
        byte[] inputBuffer = this._inputBuffer;
        while (true) {
            int c;
            int ptr;
            block16: {
                int max;
                if ((ptr = this._inputPtr) >= (max = this._inputEnd)) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                    max = this._inputEnd;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 0xFF] == 0) continue;
                    break block16;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    break;
                }
                case 3: {
                    this.markLF();
                    break;
                }
                case 5: {
                    this.skipUtf8_2(c);
                    break;
                }
                case 6: {
                    this.skipUtf8_3(c);
                    break;
                }
                case 7: {
                    this.skipUtf8_4(c);
                    break;
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 12: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] != 62) break;
                    ++this._inputPtr;
                    return;
                }
            }
        }
    }

    @Override
    protected final void skipSpace() throws XMLStreamException {
        int ptr = this._inputPtr;
        while (true) {
            int c;
            if (ptr >= this._inputEnd) {
                if (!this.loadMore()) break;
                ptr = this._inputPtr;
            }
            if ((c = this._inputBuffer[ptr] & 0xFF) > 32) break;
            ++ptr;
            if (c == 10) {
                this.markLF(ptr);
                continue;
            }
            if (c == 13) {
                if (ptr >= this._inputEnd) {
                    if (!this.loadMore()) break;
                    ptr = this._inputPtr;
                }
                if (this._inputBuffer[ptr] == 10) {
                    ++ptr;
                }
                this.markLF(ptr);
                continue;
            }
            if (c == 32 || c == 9) continue;
            this._inputPtr = ptr;
            this.throwInvalidSpace(c);
        }
        this._inputPtr = ptr;
    }

    private final void skipUtf8_2(int c) throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((c = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(c & 0xFF, this._inputPtr);
        }
    }

    private final void skipUtf8_3(int c) throws XMLStreamException {
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if ((c &= 0xF) >= 13) {
            byte d;
            c <<= 6;
            if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(d & 0xFF, this._inputPtr);
            }
            c |= d & 0x3F;
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(d & 0xFF, this._inputPtr);
            }
            if ((c = c << 6 | d & 0x3F) >= 55296 && (c < 57344 || c >= 65534 && c <= 65535)) {
                c = this.handleInvalidXmlChar(c);
            }
        } else {
            if (((c = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(c & 0xFF, this._inputPtr);
            }
            if (this._inputPtr >= this._inputEnd) {
                this.loadMoreGuaranteed();
            }
            if (((c = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
                this.reportInvalidOther(c & 0xFF, this._inputPtr);
            }
        }
    }

    private final void skipUtf8_4(int c) throws XMLStreamException {
        byte d;
        if (this._inputPtr + 4 > this._inputEnd) {
            this.skipUtf8_4Slow(c);
            return;
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
    }

    private final void skipUtf8_4Slow(int c) throws XMLStreamException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishCData() throws XMLStreamException {
        TYPES = this._charTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.resetWithEmpty();
        outPtr = 0;
        block10: while (true) {
            block26: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block26;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl75
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl75
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl75
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl75
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl75
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 11: {
                    count = 0;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((b = this._inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++count;
                    }
                    v0 = ok = b == 62 && count >= 1;
                    if (ok) {
                        --count;
                    }
                    while (count > 0) {
                        outputBuffer[outPtr++] = 93;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        --count;
                    }
                    if (ok) {
                        ++this._inputPtr;
                        break block10;
                    }
                }
lbl75:
                // 8 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishCharacters() throws XMLStreamException {
        c = this._tmpChar;
        if (c < 0) {
            c = -c;
            outputBuffer = this._textBuilder.resetWithEmpty();
            outPtr = 0;
            if (c >> 16 != 0) {
                outputBuffer[outPtr++] = (char)(55296 | (c -= 65536) >> 10);
                c = 56320 | c & 1023;
            }
            outputBuffer[outPtr++] = (char)c;
        } else if (c == 13 || c == 10) {
            ++this._inputPtr;
            outPtr = this.checkInTreeIndentation(c);
            if (outPtr < 0) {
                return;
            }
            outputBuffer = this._textBuilder.getBufferWithoutReset();
        } else {
            outputBuffer = this._textBuilder.resetWithEmpty();
            outPtr = 0;
        }
        TYPES = this._charTypes.TEXT_CHARS;
        inputBuffer = this._inputBuffer;
        block12: while (true) {
            block35: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block35;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl103
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl103
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl103
                }
                case 6: {
                    c = this._inputEnd - this._inputPtr >= 2 ? this.decodeUtf8_3fast(c) : this.decodeUtf8_3(c);
                    ** GOTO lbl103
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl103
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    --this._inputPtr;
                    break block12;
                }
                case 10: {
                    c = this.handleEntityInText(false);
                    if (c == 0) {
                        this._entityPending = true;
                        break block12;
                    }
                    if (c >> 16 == 0) ** GOTO lbl103
                    outputBuffer[outPtr++] = (char)(55296 | (c -= 65536) >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl103
                }
                case 11: {
                    count = 1;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((b = inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++count;
                    }
                    if (b == 62 && count > 1) {
                        this.reportIllegalCDataEnd();
                    }
                    while (count > 1) {
                        outputBuffer[outPtr++] = 93;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        --count;
                    }
                }
lbl103:
                // 9 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block12;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
        if (this._cfgCoalescing && !this._entityPending) {
            this.finishCoalescedText();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishComment() throws XMLStreamException {
        TYPES = this._charTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.resetWithEmpty();
        outPtr = 0;
        block10: while (true) {
            block22: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block22;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl63
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl63
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl63
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl63
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl63
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 13: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 45) {
                        ++this._inputPtr;
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if (this._inputBuffer[this._inputPtr++] == 62) break block10;
                        this.reportDoubleHyphenInComments();
                        break block10;
                    }
                }
lbl63:
                // 8 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishDTD(boolean copyContents) throws XMLStreamException {
        outputBuffer = copyContents != false ? this._textBuilder.resetWithEmpty() : null;
        outPtr = 0;
        TYPES = this._charTypes.DTD_CHARS;
        inDecl = false;
        quoteChar = 0;
        block13: while (true) {
            block31: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                max = this._inputEnd;
                if (outputBuffer != null) {
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    if ((max2 = ptr + (outputBuffer.length - outPtr)) < max) {
                        max = max2;
                    }
                }
                while (ptr < max) {
                    if (TYPES[c = this._inputBuffer[ptr++] & 255] == 0) {
                        if (outputBuffer == null) continue;
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block31;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl75
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl75
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl75
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl75
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    if (outputBuffer != null) {
                        outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                        c = 56320 | c & 1023;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                    }
                    ** GOTO lbl75
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 8: {
                    if (quoteChar == 0) {
                        quoteChar = c;
                    } else if (quoteChar == c) {
                        quoteChar = 0;
                    }
                    ** GOTO lbl75
                }
                case 9: {
                    if (!inDecl) {
                        inDecl = true;
                    }
                    ** GOTO lbl75
                }
                case 10: {
                    if (quoteChar == 0) {
                        inDecl = false;
                    }
                    ** GOTO lbl75
                }
                case 11: {
                    if (!inDecl && quoteChar == 0) break block13;
                }
lbl75:
                // 11 sources

                default: {
                    if (outputBuffer == null) continue block13;
                    outputBuffer[outPtr++] = (char)c;
                    continue block13;
                }
            }
            break;
        }
        if (outputBuffer != null) {
            this._textBuilder.setCurrentLength(outPtr);
        }
        if ((b = this.skipInternalWs(false, null)) != 62) {
            this.throwUnexpectedChar(this.decodeCharForError(b), " expected '>' after the internal subset");
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected final void finishPI() throws XMLStreamException {
        TYPES = this._charTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.resetWithEmpty();
        outPtr = 0;
        block10: while (true) {
            block21: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block21;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl59
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl59
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl59
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl59
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl59
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 12: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (this._inputBuffer[this._inputPtr] == 62) {
                        ++this._inputPtr;
                        break block10;
                    }
                }
lbl59:
                // 8 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    @Override
    protected final void finishSpace() throws XMLStreamException {
        char[] outputBuffer;
        int outPtr;
        int tmp = this._tmpChar;
        if (tmp == 13 || tmp == 10) {
            outPtr = this.checkPrologIndentation(tmp);
            if (outPtr < 0) {
                return;
            }
            outputBuffer = this._textBuilder.getBufferWithoutReset();
        } else {
            outputBuffer = this._textBuilder.resetWithEmpty();
            outputBuffer[0] = (char)tmp;
            outPtr = 1;
        }
        int ptr = this._inputPtr;
        while (true) {
            int c;
            if (ptr >= this._inputEnd) {
                if (!this.loadMore()) break;
                ptr = this._inputPtr;
            }
            if ((c = this._inputBuffer[ptr] & 0xFF) > 32) break;
            ++ptr;
            if (c == 10) {
                this.markLF(ptr);
            } else if (c == 13) {
                if (ptr >= this._inputEnd) {
                    if (!this.loadMore()) {
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        outputBuffer[outPtr++] = 10;
                        break;
                    }
                    ptr = this._inputPtr;
                }
                if (this._inputBuffer[ptr] == 10) {
                    ++ptr;
                }
                this.markLF(ptr);
                c = 10;
            } else if (c != 32 && c != 9) {
                this._inputPtr = ptr;
                this.throwInvalidSpace(c);
            }
            if (outPtr >= outputBuffer.length) {
                outputBuffer = this._textBuilder.finishCurrentSegment();
                outPtr = 0;
            }
            outputBuffer[outPtr++] = (char)c;
        }
        this._inputPtr = ptr;
        this._textBuilder.setCurrentLength(outPtr);
    }

    protected final void finishCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return;
            }
            if (this._inputBuffer[this._inputPtr] == 60) {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain(3)) {
                    return;
                }
                if (this._inputBuffer[this._inputPtr + 1] != 33 || this._inputBuffer[this._inputPtr + 2] != 91) {
                    return;
                }
                this._inputPtr += 3;
                for (int i = 0; i < 6; ++i) {
                    byte b;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((b = this._inputBuffer[this._inputPtr++]) == (byte)"CDATA[".charAt(i)) continue;
                    int ch = this.decodeCharForError(b);
                    this.reportTreeUnexpChar(ch, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
                }
                this.finishCoalescedCData();
                continue;
            }
            this.finishCoalescedCharacters();
            if (this._entityPending) break;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected final void finishCoalescedCharacters() throws XMLStreamException {
        TYPES = this._charTypes.TEXT_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.getBufferWithoutReset();
        outPtr = this._textBuilder.getCurrentLength();
        block12: while (true) {
            block28: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block28;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl86
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl86
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl86
                }
                case 6: {
                    c = this._inputEnd - this._inputPtr >= 2 ? this.decodeUtf8_3fast(c) : this.decodeUtf8_3(c);
                    ** GOTO lbl86
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl86
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 9: {
                    --this._inputPtr;
                    break block12;
                }
                case 10: {
                    c = this.handleEntityInText(false);
                    if (c == 0) {
                        this._entityPending = true;
                        break block12;
                    }
                    if (c >> 16 == 0) ** GOTO lbl86
                    outputBuffer[outPtr++] = (char)(55296 | (c -= 65536) >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl86
                }
                case 11: {
                    count = 1;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((b = inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++count;
                    }
                    if (b == 62 && count > 1) {
                        this.reportIllegalCDataEnd();
                    }
                    while (count > 1) {
                        outputBuffer[outPtr++] = 93;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        --count;
                    }
                }
lbl86:
                // 9 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block12;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    /*
     * Unable to fully structure code
     */
    protected final void finishCoalescedCData() throws XMLStreamException {
        TYPES = this._charTypes.OTHER_CHARS;
        inputBuffer = this._inputBuffer;
        outputBuffer = this._textBuilder.getBufferWithoutReset();
        outPtr = this._textBuilder.getCurrentLength();
        block10: while (true) {
            block25: {
                if ((ptr = this._inputPtr) >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (outPtr >= outputBuffer.length) {
                    outputBuffer = this._textBuilder.finishCurrentSegment();
                    outPtr = 0;
                }
                if ((max2 = ptr + (outputBuffer.length - outPtr)) < (max = this._inputEnd)) {
                    max = max2;
                }
                while (ptr < max) {
                    if (TYPES[c = inputBuffer[ptr++] & 255] == 0) {
                        outputBuffer[outPtr++] = (char)c;
                        continue;
                    }
                    break block25;
                }
                this._inputPtr = ptr;
                continue;
            }
            this._inputPtr = ptr;
            switch (TYPES[c]) {
                case 1: {
                    c = this.handleInvalidXmlChar(c);
                }
                case 2: {
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if (inputBuffer[this._inputPtr] == 10) {
                        ++this._inputPtr;
                    }
                    this.markLF();
                    c = 10;
                    ** GOTO lbl75
                }
                case 3: {
                    this.markLF();
                    ** GOTO lbl75
                }
                case 5: {
                    c = this.decodeUtf8_2(c);
                    ** GOTO lbl75
                }
                case 6: {
                    c = this.decodeUtf8_3(c);
                    ** GOTO lbl75
                }
                case 7: {
                    c = this.decodeUtf8_4(c);
                    outputBuffer[outPtr++] = (char)(55296 | c >> 10);
                    if (outPtr >= outputBuffer.length) {
                        outputBuffer = this._textBuilder.finishCurrentSegment();
                        outPtr = 0;
                    }
                    c = 56320 | c & 1023;
                    ** GOTO lbl75
                }
                case 4: {
                    this.reportInvalidInitial(c);
                }
                case 11: {
                    count = 0;
                    while (true) {
                        if (this._inputPtr >= this._inputEnd) {
                            this.loadMoreGuaranteed();
                        }
                        if ((b = this._inputBuffer[this._inputPtr]) != 93) break;
                        ++this._inputPtr;
                        ++count;
                    }
                    v0 = ok = b == 62 && count >= 1;
                    if (ok) {
                        --count;
                    }
                    while (count > 0) {
                        outputBuffer[outPtr++] = 93;
                        if (outPtr >= outputBuffer.length) {
                            outputBuffer = this._textBuilder.finishCurrentSegment();
                            outPtr = 0;
                        }
                        --count;
                    }
                    if (ok) {
                        ++this._inputPtr;
                        break block10;
                    }
                }
lbl75:
                // 8 sources

                default: {
                    outputBuffer[outPtr++] = (char)c;
                    continue block10;
                }
            }
            break;
        }
        this._textBuilder.setCurrentLength(outPtr);
    }

    @Override
    protected final boolean skipCoalescedText() throws XMLStreamException {
        while (true) {
            if (this._inputPtr >= this._inputEnd && !this.loadMore()) {
                return false;
            }
            if (this._inputBuffer[this._inputPtr] == 60) {
                if (this._inputPtr + 3 >= this._inputEnd && !this.loadAndRetain(3)) {
                    return false;
                }
                if (this._inputBuffer[this._inputPtr + 1] != 33 || this._inputBuffer[this._inputPtr + 2] != 91) {
                    return false;
                }
                this._inputPtr += 3;
                for (int i = 0; i < 6; ++i) {
                    byte b;
                    if (this._inputPtr >= this._inputEnd) {
                        this.loadMoreGuaranteed();
                    }
                    if ((b = this._inputBuffer[this._inputPtr++]) == (byte)"CDATA[".charAt(i)) continue;
                    int ch = this.decodeCharForError(b);
                    this.reportTreeUnexpChar(ch, " (expected '" + "CDATA[".charAt(i) + "' for CDATA section)");
                }
                this.skipCData();
                continue;
            }
            if (this.skipCharacters()) break;
        }
        return true;
    }

    private final int decodeMultiByteChar(int c, int ptr) throws XMLStreamException {
        byte d;
        int needed;
        if ((c & 0xE0) == 192) {
            c &= 0x1F;
            needed = 1;
        } else if ((c & 0xF0) == 224) {
            c &= 0xF;
            needed = 2;
        } else if ((c & 0xF8) == 240) {
            c &= 7;
            needed = 3;
        } else {
            this.reportInvalidInitial(c & 0xFF);
            needed = 1;
        }
        if (ptr >= this._inputEnd) {
            this.loadMoreGuaranteed();
            ptr = this._inputPtr;
        }
        if (((d = this._inputBuffer[ptr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, ptr);
        }
        c = c << 6 | d & 0x3F;
        if (needed > 1) {
            if (ptr >= this._inputEnd) {
                this.loadMoreGuaranteed();
                ptr = this._inputPtr;
            }
            if (((d = this._inputBuffer[ptr++]) & 0xC0) != 128) {
                this.reportInvalidOther(d & 0xFF, ptr);
            }
            c = c << 6 | d & 0x3F;
            if (needed > 2) {
                if (ptr >= this._inputEnd) {
                    this.loadMoreGuaranteed();
                    ptr = this._inputPtr;
                }
                if (((d = this._inputBuffer[ptr++]) & 0xC0) != 128) {
                    this.reportInvalidOther(d & 0xFF, ptr);
                }
                c = c << 6 | d & 0x3F;
                c = -c;
            }
        }
        this._inputPtr = ptr;
        return c;
    }

    private final int decodeUtf8_2(int c) throws XMLStreamException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c & 0x1F) << 6 | d & 0x3F;
    }

    private final int decodeUtf8_3(int c1) throws XMLStreamException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        if (c1 >= 13 && c >= 55296 && (c < 57344 || c >= 65534 && c <= 65535)) {
            c = this.handleInvalidXmlChar(c);
        }
        return c;
    }

    private final int decodeUtf8_3fast(int c1) throws XMLStreamException {
        byte d;
        c1 &= 0xF;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        int c = c1 << 6 | d & 0x3F;
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        if (c1 >= 13 && c >= 55296 && (c < 57344 || c >= 65534 && c <= 65535)) {
            c = this.handleInvalidXmlChar(c);
        }
        return c;
    }

    private final int decodeUtf8_4(int c) throws XMLStreamException {
        byte d;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = (c & 7) << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        c = c << 6 | d & 0x3F;
        if (this._inputPtr >= this._inputEnd) {
            this.loadMoreGuaranteed();
        }
        if (((d = this._inputBuffer[this._inputPtr++]) & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF, this._inputPtr);
        }
        return (c << 6 | d & 0x3F) - 65536;
    }

    @Override
    public int decodeCharForError(byte b) throws XMLStreamException {
        int needed;
        int c = b;
        if (c >= 0) {
            return c;
        }
        if ((c & 0xE0) == 192) {
            c &= 0x1F;
            needed = 1;
        } else if ((c & 0xF0) == 224) {
            c &= 0xF;
            needed = 2;
        } else if ((c & 0xF8) == 240) {
            c &= 7;
            needed = 3;
        } else {
            this.reportInvalidInitial(c & 0xFF);
            needed = 1;
        }
        byte d = this.nextByte();
        if ((d & 0xC0) != 128) {
            this.reportInvalidOther(d & 0xFF);
        }
        c = c << 6 | d & 0x3F;
        if (needed > 1) {
            d = this.nextByte();
            if ((d & 0xC0) != 128) {
                this.reportInvalidOther(d & 0xFF);
            }
            c = c << 6 | d & 0x3F;
            if (needed > 2) {
                d = this.nextByte();
                if ((d & 0xC0) != 128) {
                    this.reportInvalidOther(d & 0xFF);
                }
                c = c << 6 | d & 0x3F;
            }
        }
        return c;
    }

    protected void reportInvalidOther(int mask, int ptr) throws XMLStreamException {
        this._inputPtr = ptr;
        this.reportInvalidOther(mask);
    }
}

