/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.sax;

import com.fasterxml.aalto.in.AttributeCollector;
import com.fasterxml.aalto.in.ByteSourceBootstrapper;
import com.fasterxml.aalto.in.CharSourceBootstrapper;
import com.fasterxml.aalto.in.PName;
import com.fasterxml.aalto.in.ReaderConfig;
import com.fasterxml.aalto.in.XmlScanner;
import com.fasterxml.aalto.sax.SAXFeature;
import com.fasterxml.aalto.sax.SAXProperty;
import com.fasterxml.aalto.sax.SAXUtil;
import com.fasterxml.aalto.stax.InputFactoryImpl;
import com.fasterxml.aalto.util.URLUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.stream.XMLStreamException;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.DocumentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.HandlerBase;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2;
import org.xml.sax.ext.DeclHandler;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.ext.Locator2;
import org.xml.sax.helpers.DefaultHandler;

class SAXParserImpl
extends SAXParser
implements Parser,
XMLReader,
Attributes2,
Locator2 {
    final InputFactoryImpl _staxFactory;
    XmlScanner _scanner;
    AttributeCollector _attrCollector;
    protected ContentHandler _contentHandler;
    protected DTDHandler _dtdHandler;
    private EntityResolver _entityResolver;
    private ErrorHandler _errorHandler;
    private LexicalHandler _lexicalHandler;
    private DeclHandler _declHandler;
    private int _attrCount;

    SAXParserImpl(InputFactoryImpl sf) {
        this._staxFactory = sf;
    }

    @Override
    public final Parser getParser() {
        return this;
    }

    @Override
    public final XMLReader getXMLReader() {
        return this;
    }

    @Override
    public boolean isNamespaceAware() {
        return true;
    }

    @Override
    public boolean isValidating() {
        return false;
    }

    @Override
    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAXProperty stdProp = SAXUtil.findStdProperty(name);
        if (stdProp != null) {
            switch (stdProp) {
                case DECLARATION_HANDLER: {
                    return this._declHandler;
                }
                case DOM_NODE: {
                    return null;
                }
                case LEXICAL_HANDLER: {
                    return this._lexicalHandler;
                }
                case XML_STRING: {
                    return null;
                }
            }
        }
        SAXUtil.reportUnknownProperty(name);
        return null;
    }

    @Override
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        SAXProperty stdProp = SAXUtil.findStdProperty(name);
        if (stdProp != null) {
            switch (stdProp) {
                case DECLARATION_HANDLER: {
                    this._declHandler = (DeclHandler)value;
                    return;
                }
                case DOM_NODE: {
                    return;
                }
                case LEXICAL_HANDLER: {
                    this._lexicalHandler = (LexicalHandler)value;
                    return;
                }
                case XML_STRING: {
                    return;
                }
            }
        }
        SAXUtil.reportUnknownFeature(name);
    }

    @Override
    public void parse(InputSource is, HandlerBase hb) throws SAXException, IOException {
        if (hb != null) {
            if (this._contentHandler == null) {
                this.setDocumentHandler(hb);
            }
            if (this._entityResolver == null) {
                this.setEntityResolver(hb);
            }
            if (this._errorHandler == null) {
                this.setErrorHandler(hb);
            }
            if (this._dtdHandler == null) {
                this.setDTDHandler(hb);
            }
        }
        this.parse(is);
    }

    @Override
    public void parse(InputSource is, DefaultHandler dh) throws SAXException, IOException {
        if (dh != null) {
            if (this._contentHandler == null) {
                this.setContentHandler(dh);
            }
            if (this._entityResolver == null) {
                this.setEntityResolver(dh);
            }
            if (this._errorHandler == null) {
                this.setErrorHandler(dh);
            }
            if (this._dtdHandler == null) {
                this.setDTDHandler(dh);
            }
        }
        this.parse(is);
    }

    @Override
    public ContentHandler getContentHandler() {
        return this._contentHandler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this._dtdHandler;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this._entityResolver;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this._errorHandler;
    }

    @Override
    public boolean getFeature(String name) throws SAXNotRecognizedException {
        SAXFeature stdFeat = SAXUtil.findStdFeature(name);
        if (stdFeat != null) {
            Boolean b = SAXUtil.getFixedStdFeatureValue(stdFeat);
            if (b != null) {
                return b;
            }
            switch (stdFeat) {
                case IS_STANDALONE: {
                    return true;
                }
            }
        }
        SAXUtil.reportUnknownFeature(name);
        return false;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this._contentHandler = handler;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this._dtdHandler = handler;
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this._entityResolver = resolver;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this._errorHandler = handler;
    }

    @Override
    public void setFeature(String name, boolean value) throws SAXNotRecognizedException {
        SAXFeature stdFeat = SAXUtil.findStdFeature(name);
        if (stdFeat == null) {
            SAXUtil.reportUnknownFeature(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void parse(InputSource input) throws SAXException {
        String enc = input.getEncoding();
        String systemId = input.getSystemId();
        ReaderConfig cfg = this._staxFactory.getNonSharedConfig(systemId, input.getPublicId(), enc, false, false);
        cfg.doParseLazily(false);
        InputStream is = null;
        Reader r = input.getCharacterStream();
        if (r == null && (is = input.getByteStream()) == null) {
            if (systemId == null) {
                throw new SAXException("Invalid InputSource passed: neither character or byte stream passed, nor system id specified");
            }
            try {
                URL url = URLUtil.urlFromSystemId(systemId);
                is = URLUtil.inputStreamFromURL(url);
            }
            catch (IOException ioe) {
                SAXException saxe = new SAXException(ioe);
                if (saxe.getCause() == null) {
                    saxe.initCause(ioe);
                }
                throw saxe;
            }
        }
        if (this._contentHandler != null) {
            this._contentHandler.setDocumentLocator(this);
            this._contentHandler.startDocument();
        }
        try {
            this._scanner = r != null ? CharSourceBootstrapper.construct(cfg, r).bootstrap() : ByteSourceBootstrapper.construct(cfg, is).bootstrap();
            this._attrCollector = this._scanner.getAttrCollector();
            this.fireEvents();
        }
        catch (XMLStreamException strex) {
            this.throwSaxException(strex);
        }
        finally {
            if (this._contentHandler != null) {
                this._contentHandler.endDocument();
            }
            if (this._scanner != null) {
                try {
                    this._scanner.close(false);
                }
                catch (XMLStreamException strex) {}
                this._scanner = null;
            }
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ioe) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    @Override
    public void parse(String systemId) throws SAXException {
        InputSource src = new InputSource(systemId);
        this.parse(src);
    }

    private final void fireEvents() throws SAXException, XMLStreamException {
        int type;
        while ((type = this._scanner.nextFromProlog(true)) != 1) {
            this.fireAuxEvent(type, false);
        }
        this.fireStartTag();
        int depth = 1;
        while (true) {
            if ((type = this._scanner.nextFromTree()) == 1) {
                this.fireStartTag();
                ++depth;
                continue;
            }
            if (type == 2) {
                this.fireEndTag();
                if (--depth >= 1) continue;
                break;
            }
            if (type == 4) {
                this._scanner.fireSaxCharacterEvents(this._contentHandler);
                continue;
            }
            this.fireAuxEvent(type, true);
        }
        while ((type = this._scanner.nextFromProlog(false)) != -1) {
            if (type == 6) continue;
            this.fireAuxEvent(type, false);
        }
    }

    private final void fireAuxEvent(int type, boolean inTree) throws SAXException, XMLStreamException {
        switch (type) {
            case 5: {
                this._scanner.fireSaxCommentEvent(this._lexicalHandler);
                break;
            }
            case 12: {
                if (this._lexicalHandler != null) {
                    this._lexicalHandler.startCDATA();
                    this._scanner.fireSaxCharacterEvents(this._contentHandler);
                    this._lexicalHandler.endCDATA();
                    break;
                }
                this._scanner.fireSaxCharacterEvents(this._contentHandler);
                break;
            }
            case 11: {
                if (this._lexicalHandler == null) break;
                PName n = this._scanner.getName();
                this._lexicalHandler.startDTD(n.getPrefixedName(), this._scanner.getDTDPublicId(), this._scanner.getDTDSystemId());
                this._lexicalHandler.endDTD();
                break;
            }
            case 3: {
                this._scanner.fireSaxPIEvent(this._contentHandler);
                break;
            }
            case 6: {
                if (!inTree) break;
                this._scanner.fireSaxSpaceEvents(this._contentHandler);
                break;
            }
            default: {
                if (type == -1) {
                    this.throwSaxException("Unexpected end-of-input in " + (inTree ? "tree" : "prolog"));
                }
                throw new RuntimeException("Internal error: unexpected type, " + type);
            }
        }
    }

    private final void fireStartTag() throws SAXException {
        this._attrCount = this._scanner.getAttrCount();
        this._scanner.fireSaxStartElement(this._contentHandler, this);
    }

    private final void fireEndTag() throws SAXException {
        this._scanner.fireSaxEndElement(this._contentHandler);
    }

    @Override
    public void setDocumentHandler(DocumentHandler handler) {
        this.setContentHandler(new DocHandlerWrapper(handler));
    }

    @Override
    public void setLocale(Locale locale) {
    }

    @Override
    public int getIndex(String qName) {
        return this._attrCollector == null ? -1 : this._attrCollector.findIndex(null, qName);
    }

    @Override
    public int getIndex(String uri, String localName) {
        return this._attrCollector == null ? -1 : this._attrCollector.findIndex(uri, localName);
    }

    @Override
    public int getLength() {
        return this._attrCount;
    }

    @Override
    public String getLocalName(int index) {
        return index < 0 || index >= this._attrCount ? null : this._attrCollector.getName(index).getLocalName();
    }

    @Override
    public String getQName(int index) {
        return index < 0 || index >= this._attrCount ? null : this._attrCollector.getName(index).getPrefixedName();
    }

    @Override
    public String getType(int index) {
        return index < 0 || index >= this._attrCount ? null : this._scanner.getAttrType(index);
    }

    @Override
    public String getType(String qName) {
        int ix = this.getIndex(qName);
        return ix < 0 ? null : this._scanner.getAttrType(ix);
    }

    @Override
    public String getType(String uri, String localName) {
        int ix = this.getIndex(uri, localName);
        return ix < 0 ? null : this._scanner.getAttrType(ix);
    }

    @Override
    public String getURI(int index) {
        if (index < 0 || index >= this._attrCount) {
            return null;
        }
        String uri = this._attrCollector.getName(index).getNsUri();
        return uri == null ? "" : uri;
    }

    @Override
    public String getValue(int index) {
        return index < 0 || index >= this._attrCount ? null : this._attrCollector.getValue(index);
    }

    @Override
    public String getValue(String qName) {
        int ix = this.getIndex(qName);
        return ix < 0 ? null : this._attrCollector.getValue(ix);
    }

    @Override
    public String getValue(String uri, String localName) {
        int ix = this.getIndex(uri, localName);
        return ix < 0 ? null : this._attrCollector.getValue(ix);
    }

    @Override
    public boolean isDeclared(int index) {
        return false;
    }

    @Override
    public boolean isDeclared(String qName) {
        return false;
    }

    @Override
    public boolean isDeclared(String uri, String localName) {
        return false;
    }

    @Override
    public boolean isSpecified(int index) {
        return true;
    }

    @Override
    public boolean isSpecified(String qName) {
        return true;
    }

    @Override
    public boolean isSpecified(String uri, String localName) {
        return true;
    }

    @Override
    public int getColumnNumber() {
        return this._scanner != null ? this._scanner.getCurrentColumnNr() : -1;
    }

    @Override
    public int getLineNumber() {
        return this._scanner != null ? this._scanner.getCurrentLineNr() : -1;
    }

    @Override
    public String getPublicId() {
        return this._scanner != null ? this._scanner.getInputPublicId() : null;
    }

    @Override
    public String getSystemId() {
        return this._scanner != null ? this._scanner.getInputSystemId() : null;
    }

    @Override
    public String getEncoding() {
        ReaderConfig cfg = this._scanner.getConfig();
        String enc = cfg.getActualEncoding();
        if (enc == null && (enc = cfg.getXmlDeclEncoding()) == null) {
            enc = cfg.getExternalEncoding();
        }
        return enc;
    }

    @Override
    public String getXMLVersion() {
        return this._scanner.getConfig().getXmlDeclVersion();
    }

    private void throwSaxException(Exception e) throws SAXException {
        SAXParseException se = new SAXParseException(e.getMessage(), this, e);
        if (se.getCause() == null) {
            se.initCause(e);
        }
        if (this._errorHandler != null) {
            this._errorHandler.fatalError(se);
        }
        throw se;
    }

    private void throwSaxException(String msg) throws SAXException {
        SAXParseException se = new SAXParseException(msg, this);
        if (this._errorHandler != null) {
            this._errorHandler.fatalError(se);
        }
        throw se;
    }

    static final class AttributesWrapper
    implements AttributeList {
        Attributes mAttrs;

        public void setAttributes(Attributes a) {
            this.mAttrs = a;
        }

        @Override
        public int getLength() {
            return this.mAttrs.getLength();
        }

        @Override
        public String getName(int i) {
            String n = this.mAttrs.getQName(i);
            return n == null ? this.mAttrs.getLocalName(i) : n;
        }

        @Override
        public String getType(int i) {
            return this.mAttrs.getType(i);
        }

        @Override
        public String getType(String name) {
            return this.mAttrs.getType(name);
        }

        @Override
        public String getValue(int i) {
            return this.mAttrs.getValue(i);
        }

        @Override
        public String getValue(String name) {
            return this.mAttrs.getValue(name);
        }
    }

    static final class DocHandlerWrapper
    implements ContentHandler {
        final DocumentHandler mDocHandler;
        final AttributesWrapper mAttrWrapper = new AttributesWrapper();

        DocHandlerWrapper(DocumentHandler h) {
            this.mDocHandler = h;
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.mDocHandler.characters(ch, start, length);
        }

        @Override
        public void endDocument() throws SAXException {
            this.mDocHandler.endDocument();
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName == null) {
                qName = localName;
            }
            this.mDocHandler.endElement(qName);
        }

        @Override
        public void endPrefixMapping(String prefix) {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.mDocHandler.ignorableWhitespace(ch, start, length);
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.mDocHandler.processingInstruction(target, data);
        }

        @Override
        public void setDocumentLocator(Locator locator) {
            this.mDocHandler.setDocumentLocator(locator);
        }

        @Override
        public void skippedEntity(String name) {
        }

        @Override
        public void startDocument() throws SAXException {
            this.mDocHandler.startDocument();
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attrs) throws SAXException {
            if (qName == null) {
                qName = localName;
            }
            this.mAttrWrapper.setAttributes(attrs);
            this.mDocHandler.startElement(qName, this.mAttrWrapper);
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) {
        }
    }
}

