/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.aalto.out;

import com.fasterxml.aalto.impl.IoStreamException;
import com.fasterxml.aalto.out.ByteWName;
import com.fasterxml.aalto.out.ByteXmlWriter;
import com.fasterxml.aalto.out.OutputCharTypes;
import com.fasterxml.aalto.out.WName;
import com.fasterxml.aalto.out.WriterConfig;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.stream.XMLStreamException;

public final class Utf8XmlWriter
extends ByteXmlWriter {
    public Utf8XmlWriter(WriterConfig cfg, OutputStream out) {
        super(cfg, out, OutputCharTypes.getUtf8CharTypes());
    }

    @Override
    public int getHighestEncodable() {
        return 0x10FFFF;
    }

    @Override
    public void writeRaw(char[] cbuf, int offset, int len) throws IOException, XMLStreamException {
        if (this._out == null || len == 0) {
            return;
        }
        if (this.mSurrogate != 0) {
            this.outputSurrogates(this.mSurrogate, cbuf[offset]);
            ++offset;
            --len;
        }
        len += offset;
        block0: while (offset < len) {
            char ch;
            while ((ch = cbuf[offset]) < '\u0080') {
                if (this._outputPtr >= this._outputBufferLen) {
                    this.flushBuffer();
                }
                this._outputBuffer[this._outputPtr++] = (byte)ch;
                if (++offset < len) continue;
                break block0;
            }
            if ((ch = cbuf[offset++]) < '\u0800') {
                this.output2ByteChar(ch);
            } else {
                offset = this.outputMultiByteChar(ch, cbuf, offset, len);
            }
            if (this._outputPtr >= this._outputBufferLen) {
                this.flushBuffer();
            }
            this._outputBuffer[this._outputPtr++] = (byte)ch;
        }
    }

    @Override
    protected WName doConstructName(String localName) throws XMLStreamException {
        try {
            byte[] b = localName.getBytes("UTF-8");
            return new ByteWName(localName, b);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    protected WName doConstructName(String prefix, String localName) throws XMLStreamException {
        try {
            byte[] b = (prefix + ":" + localName).getBytes("UTF-8");
            return new ByteWName(prefix, localName, b);
        }
        catch (IOException ioe) {
            throw new IoStreamException(ioe);
        }
    }

    @Override
    protected final void outputSurrogates(int surr1, int surr2) throws IOException, XMLStreamException {
        int c = this.calcSurrogate(surr1, surr2, " in content");
        if (this._outputPtr + 4 > this._outputBufferLen) {
            this.flushBuffer();
        }
        this._outputBuffer[this._outputPtr++] = (byte)(0xF0 | c >> 18);
        this._outputBuffer[this._outputPtr++] = (byte)(0x80 | c >> 12 & 0x3F);
        this._outputBuffer[this._outputPtr++] = (byte)(0x80 | c >> 6 & 0x3F);
        this._outputBuffer[this._outputPtr++] = (byte)(0x80 | c & 0x3F);
    }

    @Override
    protected final void output2ByteChar(int ch) throws IOException, XMLStreamException {
        if (this._outputPtr + 2 > this._outputBufferLen) {
            this.flushBuffer();
        }
        byte[] bbuf = this._outputBuffer;
        bbuf[this._outputPtr++] = (byte)(0xC0 | ch >> 6);
        bbuf[this._outputPtr++] = (byte)(0x80 | ch & 0x3F);
    }

    @Override
    protected final int outputMultiByteChar(int ch, char[] cbuf, int inputOffset, int inputLen) throws IOException, XMLStreamException {
        if (ch >= 55296) {
            if (ch <= 57343) {
                if (inputOffset >= inputLen) {
                    this.mSurrogate = ch;
                } else {
                    this.outputSurrogates(ch, cbuf[inputOffset]);
                    ++inputOffset;
                }
                return inputOffset;
            }
            if (ch >= 65534) {
                this.reportInvalidChar(ch);
            }
        }
        if (this._outputPtr + 3 > this._outputBufferLen) {
            this.flushBuffer();
        }
        byte[] bbuf = this._outputBuffer;
        bbuf[this._outputPtr++] = (byte)(0xE0 | ch >> 12);
        bbuf[this._outputPtr++] = (byte)(0x80 | ch >> 6 & 0x3F);
        bbuf[this._outputPtr++] = (byte)(0x80 | ch & 0x3F);
        return inputOffset;
    }

    @Override
    protected final int outputStrictMultiByteChar(int ch, char[] cbuf, int inputOffset, int inputLen) throws IOException, XMLStreamException {
        if (ch >= 55296) {
            if (ch <= 57343) {
                if (inputOffset >= inputLen) {
                    this.mSurrogate = ch;
                } else {
                    this.outputSurrogates(ch, cbuf[inputOffset]);
                    ++inputOffset;
                }
                return inputOffset;
            }
            if (ch >= 65534) {
                this.reportInvalidChar(ch);
            }
        }
        if (this._outputPtr + 3 > this._outputBufferLen) {
            this.flushBuffer();
        }
        byte[] bbuf = this._outputBuffer;
        bbuf[this._outputPtr++] = (byte)(0xE0 | ch >> 12);
        bbuf[this._outputPtr++] = (byte)(0x80 | ch >> 6 & 0x3F);
        bbuf[this._outputPtr++] = (byte)(0x80 | ch & 0x3F);
        return inputOffset;
    }
}

