/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.metadata.ThriftInjection;
import com.google.common.base.Preconditions;
import java.lang.reflect.Type;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftParameterInjection
implements ThriftInjection {
    private final short id;
    private final String name;
    private final int parameterIndex;
    private final Type javaType;

    public ThriftParameterInjection(short id, String name, int parameterIndex, Type javaType) {
        this.javaType = javaType;
        Preconditions.checkArgument((id >= 0 ? 1 : 0) != 0, (Object)"fieldId is negative");
        Preconditions.checkNotNull((Object)name, (Object)"name is null");
        Preconditions.checkArgument((parameterIndex >= 0 ? 1 : 0) != 0, (Object)"parameterIndex is negative");
        this.id = id;
        this.name = name;
        this.parameterIndex = parameterIndex;
    }

    @Override
    public short getId() {
        return this.id;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public int getParameterIndex() {
        return this.parameterIndex;
    }

    public Type getJavaType() {
        return this.javaType;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ThriftParameterInjection");
        sb.append("{fieldId=").append(this.id);
        sb.append(", name=").append(this.name);
        sb.append(", index=").append(this.parameterIndex);
        sb.append(", javaType=").append(this.javaType);
        sb.append('}');
        return sb.toString();
    }
}

