/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.metadata;

import com.facebook.swift.codec.metadata.ThriftParameterInjection;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.List;
import javax.annotation.concurrent.Immutable;

@Immutable
public class ThriftConstructorInjection {
    private final Constructor<?> constructor;
    private final List<ThriftParameterInjection> parameters;

    public ThriftConstructorInjection(Constructor<?> constructor, ThriftParameterInjection ... parameters) {
        this((Constructor)Preconditions.checkNotNull(constructor, (Object)"constructor is null"), (List<ThriftParameterInjection>)ImmutableList.copyOf((Object[])((Object[])Preconditions.checkNotNull((Object)parameters, (Object)"parameters is null"))));
    }

    public ThriftConstructorInjection(Constructor<?> constructor, List<ThriftParameterInjection> parameters) {
        this.constructor = (Constructor)Preconditions.checkNotNull(constructor, (Object)"constructor is null");
        this.parameters = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(parameters, (Object)"parameters is null")));
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public List<ThriftParameterInjection> getParameters() {
        return this.parameters;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.constructor.getName());
        sb.append('(');
        Joiner.on((String)", ").appendTo(sb, this.parameters);
        sb.append(')');
        return sb.toString();
    }
}

