/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.metadata.ThriftEnumMetadata;
import com.facebook.swift.codec.metadata.ThriftType;
import com.google.common.base.Preconditions;
import javax.annotation.concurrent.Immutable;
import org.apache.thrift.protocol.TProtocol;

@Immutable
public class EnumThriftCodec<T extends Enum<T>>
implements ThriftCodec<T> {
    private final ThriftType type;
    private final ThriftEnumMetadata<T> enumMetadata;

    public EnumThriftCodec(ThriftType type) {
        this.type = type;
        this.enumMetadata = type.getEnumMetadata();
    }

    @Override
    public ThriftType getType() {
        return this.type;
    }

    @Override
    public T read(TProtocol protocol) throws Exception {
        int enumValue = protocol.readI32();
        if (enumValue >= 0) {
            if (this.enumMetadata.hasExplicitThriftValue()) {
                Enum enumConstant = (Enum)this.enumMetadata.getByEnumValue().get(enumValue);
                if (enumConstant != null) {
                    return (T)enumConstant;
                }
            } else {
                Enum[] enumConstants = (Enum[])this.enumMetadata.getEnumClass().getEnumConstants();
                if (enumValue < enumConstants.length) {
                    return (T)enumConstants[enumValue];
                }
            }
        }
        throw new IllegalArgumentException(String.format("Enum %s does not have a value for %s", this.enumMetadata.getEnumClass(), enumValue));
    }

    @Override
    public void write(T enumConstant, TProtocol protocol) throws Exception {
        Preconditions.checkNotNull(enumConstant, (Object)"enumConstant is null");
        int enumValue = this.enumMetadata.hasExplicitThriftValue() ? this.enumMetadata.getByEnumConstant().get(enumConstant).intValue() : ((Enum)enumConstant).ordinal();
        protocol.writeI32(enumValue);
    }
}

