/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.reflection;

import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.codec.ThriftField;
import com.facebook.swift.codec.internal.TProtocolReader;
import com.facebook.swift.codec.internal.TProtocolWriter;
import com.facebook.swift.codec.internal.reflection.AbstractReflectionThriftCodec;
import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.ThriftConstructorInjection;
import com.facebook.swift.codec.metadata.ThriftFieldInjection;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftInjection;
import com.facebook.swift.codec.metadata.ThriftMethodInjection;
import com.facebook.swift.codec.metadata.ThriftParameterInjection;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.google.common.base.Throwables;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolException;

@Immutable
public class ReflectionThriftStructCodec<T>
extends AbstractReflectionThriftCodec<T> {
    public ReflectionThriftStructCodec(ThriftCodecManager manager, ThriftStructMetadata metadata) {
        super(manager, metadata);
    }

    @Override
    public T read(TProtocol protocol) throws Exception {
        TProtocolReader reader = new TProtocolReader(protocol);
        reader.readStructBegin();
        HashMap<Short, Object> data = new HashMap<Short, Object>(this.metadata.getFields().size());
        while (reader.nextField()) {
            short fieldId = reader.getFieldId();
            ThriftCodec codec = (ThriftCodec)this.fields.get(fieldId);
            if (codec == null) {
                reader.skipFieldData();
                continue;
            }
            ThriftFieldMetadata field = this.metadata.getField(fieldId);
            if (field.isReadOnly() || field.getType() != FieldKind.THRIFT_FIELD) {
                reader.skipFieldData();
                continue;
            }
            Object value = reader.readField(codec);
            if (value == null) {
                if (field.getRequiredness() != ThriftField.Requiredness.REQUIRED) continue;
                throw new TProtocolException("required field was not set");
            }
            data.put(fieldId, value);
        }
        reader.readStructEnd();
        return this.constructStruct(data);
    }

    @Override
    public void write(T instance, TProtocol protocol) throws Exception {
        TProtocolWriter writer = new TProtocolWriter(protocol);
        writer.writeStructBegin(this.metadata.getStructName());
        for (ThriftFieldMetadata fieldMetadata : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            Object fieldValue;
            if (fieldMetadata.isWriteOnly() || (fieldValue = this.getFieldValue(instance, fieldMetadata)) == null) continue;
            ThriftCodec codec = (ThriftCodec)this.fields.get(fieldMetadata.getId());
            writer.writeField(fieldMetadata.getName(), fieldMetadata.getId(), codec, fieldValue);
        }
        writer.writeStructEnd();
    }

    private T constructStruct(Map<Short, Object> data) throws Exception {
        Object instance;
        Object value;
        Iterator<ThriftMethodInjection> constructor = (ThriftConstructorInjection)this.metadata.getConstructorInjection().get();
        Object[] parametersValues = new Object[((ThriftConstructorInjection)((Object)constructor)).getParameters().size()];
        for (ThriftParameterInjection parameter : ((ThriftConstructorInjection)((Object)constructor)).getParameters()) {
            parametersValues[parameter.getParameterIndex()] = value = data.get(parameter.getId());
        }
        try {
            instance = ((ThriftConstructorInjection)((Object)constructor)).getConstructor().newInstance(parametersValues);
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() != null) {
                Throwables.propagateIfInstanceOf((Throwable)e.getTargetException(), Exception.class);
            }
            throw e;
        }
        for (ThriftFieldMetadata fieldMetadata : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            for (ThriftInjection injection : fieldMetadata.getInjections()) {
                Object fieldInjection;
                Object value2;
                if (!(injection instanceof ThriftFieldInjection) || (value2 = data.get(((ThriftFieldInjection)(fieldInjection = (ThriftFieldInjection)injection)).getId())) == null) continue;
                ((ThriftFieldInjection)fieldInjection).getField().set(instance, value2);
            }
        }
        for (ThriftMethodInjection methodInjection : this.metadata.getMethodInjections()) {
            boolean shouldInvoke = false;
            Object[] parametersValues2 = new Object[methodInjection.getParameters().size()];
            for (ThriftParameterInjection parameter : methodInjection.getParameters()) {
                Object value3 = data.get(parameter.getId());
                if (value3 == null) continue;
                parametersValues2[parameter.getParameterIndex()] = value3;
                shouldInvoke = true;
            }
            if (!shouldInvoke) continue;
            try {
                methodInjection.getMethod().invoke(instance, parametersValues2);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    Throwables.propagateIfInstanceOf((Throwable)e.getTargetException(), Exception.class);
                }
                throw e;
            }
        }
        if (this.metadata.getBuilderMethod().isPresent()) {
            ThriftMethodInjection builderMethod = (ThriftMethodInjection)this.metadata.getBuilderMethod().get();
            parametersValues = new Object[builderMethod.getParameters().size()];
            for (ThriftParameterInjection parameter : builderMethod.getParameters()) {
                parametersValues[parameter.getParameterIndex()] = value = data.get(parameter.getId());
            }
            try {
                instance = builderMethod.getMethod().invoke(instance, parametersValues);
                if (instance == null) {
                    throw new IllegalArgumentException("Builder method returned a null instance");
                }
                if (!this.metadata.getStructClass().isInstance(instance)) {
                    throw new IllegalArgumentException(String.format("Builder method returned instance of type %s, but an instance of %s is required", instance.getClass().getName(), this.metadata.getStructClass().getName()));
                }
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    Throwables.propagateIfInstanceOf((Throwable)e.getTargetException(), Exception.class);
                }
                throw e;
            }
        }
        return (T)instance;
    }
}

