/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.internal.compiler;

import com.facebook.swift.codec.$internal.asm.ClassReader;
import com.facebook.swift.codec.$internal.asm.ClassWriter;
import com.facebook.swift.codec.$internal.asm.util.CheckClassAdapter;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.facebook.swift.codec.ThriftProtocolType;
import com.facebook.swift.codec.internal.TProtocolReader;
import com.facebook.swift.codec.internal.TProtocolWriter;
import com.facebook.swift.codec.internal.compiler.DynamicClassLoader;
import com.facebook.swift.codec.internal.compiler.SwiftBytecodeHelper;
import com.facebook.swift.codec.internal.compiler.byteCode.Access;
import com.facebook.swift.codec.internal.compiler.byteCode.CaseStatement;
import com.facebook.swift.codec.internal.compiler.byteCode.ClassDefinition;
import com.facebook.swift.codec.internal.compiler.byteCode.FieldDefinition;
import com.facebook.swift.codec.internal.compiler.byteCode.LocalVariableDefinition;
import com.facebook.swift.codec.internal.compiler.byteCode.MethodDefinition;
import com.facebook.swift.codec.internal.compiler.byteCode.NamedParameterDefinition;
import com.facebook.swift.codec.internal.compiler.byteCode.ParameterizedType;
import com.facebook.swift.codec.metadata.DefaultThriftTypeReference;
import com.facebook.swift.codec.metadata.FieldKind;
import com.facebook.swift.codec.metadata.ReflectionHelper;
import com.facebook.swift.codec.metadata.ThriftConstructorInjection;
import com.facebook.swift.codec.metadata.ThriftExtraction;
import com.facebook.swift.codec.metadata.ThriftFieldExtractor;
import com.facebook.swift.codec.metadata.ThriftFieldInjection;
import com.facebook.swift.codec.metadata.ThriftFieldMetadata;
import com.facebook.swift.codec.metadata.ThriftInjection;
import com.facebook.swift.codec.metadata.ThriftMethodExtractor;
import com.facebook.swift.codec.metadata.ThriftMethodInjection;
import com.facebook.swift.codec.metadata.ThriftParameterInjection;
import com.facebook.swift.codec.metadata.ThriftStructMetadata;
import com.facebook.swift.codec.metadata.ThriftType;
import com.facebook.swift.codec.metadata.ThriftTypeReference;
import com.facebook.swift.codec.metadata.TypeCoercion;
import com.google.common.base.Function;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.PrintWriter;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.thrift.protocol.TProtocol;

@NotThreadSafe
public class ThriftCodecByteCodeGenerator<T> {
    private static final String PACKAGE = "$wift";
    private static final Map<ThriftProtocolType, Method> READ_METHODS;
    private static final Map<ThriftProtocolType, Method> WRITE_METHODS;
    private static final Map<Type, Method> ARRAY_READ_METHODS;
    private static final Map<Type, Method> ARRAY_WRITE_METHODS;
    private final ThriftCodecManager codecManager;
    private final ThriftStructMetadata metadata;
    private final ParameterizedType structType;
    private final ParameterizedType codecType;
    private final ClassDefinition classDefinition;
    private final ConstructorParameters parameters = new ConstructorParameters();
    private final FieldDefinition typeField;
    private final Map<Short, FieldDefinition> codecFields;
    private final ThriftCodec<T> thriftCodec;

    @SuppressFBWarnings(value={"DM_DEFAULT_ENCODING"})
    public ThriftCodecByteCodeGenerator(ThriftCodecManager codecManager, ThriftStructMetadata metadata, DynamicClassLoader classLoader, boolean debug) {
        this.codecManager = codecManager;
        this.metadata = metadata;
        this.structType = ParameterizedType.type(metadata.getStructClass());
        this.codecType = this.toCodecType(metadata);
        this.classDefinition = new ClassDefinition(Access.a(Access.PUBLIC, Access.SUPER), this.codecType.getClassName(), ParameterizedType.type(Object.class), ParameterizedType.type(ThriftCodec.class, this.structType));
        this.typeField = this.declareTypeField();
        this.codecFields = this.declareCodecFields();
        this.defineConstructor();
        this.defineGetTypeMethod();
        switch (metadata.getMetadataType()) {
            case STRUCT: {
                this.defineReadStructMethod();
                this.defineWriteStructMethod();
                break;
            }
            case UNION: {
                this.defineReadUnionMethod();
                this.defineWriteUnionMethod();
                break;
            }
            default: {
                throw new IllegalStateException(String.format("encountered type %s", new Object[]{metadata.getMetadataType()}));
            }
        }
        this.defineReadBridgeMethod();
        this.defineWriteBridgeMethod();
        ClassWriter cw = new ClassWriter(2);
        this.classDefinition.getClassNode().accept(cw);
        byte[] byteCode = cw.toByteArray();
        if (debug) {
            ClassReader reader = new ClassReader(byteCode);
            CheckClassAdapter.verify(reader, classLoader, true, new PrintWriter(System.out));
        }
        Class<?> codecClass = classLoader.defineClass(this.codecType.getClassName().replace('/', '.'), byteCode);
        try {
            Class<?>[] types = this.parameters.getTypes();
            Constructor<?> constructor = codecClass.getConstructor(types);
            this.thriftCodec = (ThriftCodec)constructor.newInstance(this.parameters.getValues());
        }
        catch (Exception e) {
            throw new IllegalStateException("Generated class is invalid", e);
        }
    }

    public ThriftCodec<T> getThriftCodec() {
        return this.thriftCodec;
    }

    private FieldDefinition declareTypeField() {
        FieldDefinition typeField = new FieldDefinition(Access.a(Access.PRIVATE, Access.FINAL), "type", ParameterizedType.type(ThriftType.class));
        this.classDefinition.addField(typeField);
        this.parameters.add(typeField, ThriftType.struct(this.metadata));
        return typeField;
    }

    private Map<Short, FieldDefinition> declareCodecFields() {
        TreeMap<Short, FieldDefinition> codecFields = new TreeMap<Short, FieldDefinition>();
        for (ThriftFieldMetadata fieldMetadata : this.metadata.getFields()) {
            if (!this.needsCodec(fieldMetadata)) continue;
            ThriftCodec<?> codec = this.codecManager.getCodec(fieldMetadata.getThriftType());
            String fieldName = fieldMetadata.getName() + "Codec";
            FieldDefinition codecField = new FieldDefinition(Access.a(Access.PRIVATE, Access.FINAL), fieldName, ParameterizedType.type(codec.getClass()));
            this.classDefinition.addField(codecField);
            codecFields.put(fieldMetadata.getId(), codecField);
            this.parameters.add(codecField, codec);
        }
        return codecFields;
    }

    private void defineConstructor() {
        MethodDefinition constructor = new MethodDefinition(Access.a(Access.PUBLIC), "<init>", ParameterizedType.type(Void.TYPE), this.parameters.getParameters());
        constructor.loadThis().invokeConstructor(ParameterizedType.type(Object.class), new ParameterizedType[0]);
        for (FieldDefinition fieldDefinition : this.parameters.getFields()) {
            constructor.loadThis().loadVariable(fieldDefinition.getName()).putField(this.codecType, fieldDefinition);
        }
        constructor.ret();
        this.classDefinition.addMethod(constructor);
    }

    private void defineGetTypeMethod() {
        this.classDefinition.addMethod(new MethodDefinition(Access.a(Access.PUBLIC), "getType", ParameterizedType.type(ThriftType.class), new NamedParameterDefinition[0]).loadThis().getField(this.codecType, this.typeField).retObject());
    }

    private void defineReadStructMethod() {
        MethodDefinition read = new MethodDefinition(Access.a(Access.PUBLIC), "read", this.structType, NamedParameterDefinition.arg("protocol", TProtocol.class)).addException(Exception.class);
        read.addLocalVariable(ParameterizedType.type(TProtocolReader.class), "reader");
        read.newObject(TProtocolReader.class);
        read.dup();
        read.loadVariable("protocol");
        read.invokeConstructor(ParameterizedType.type(TProtocolReader.class), ParameterizedType.type(TProtocol.class));
        read.storeVariable("reader");
        Map<Short, LocalVariableDefinition> structData = this.readFieldValues(read);
        LocalVariableDefinition result = this.buildStruct(read, structData);
        read.loadVariable(result).retObject();
        this.classDefinition.addMethod(read);
    }

    private Map<Short, LocalVariableDefinition> readFieldValues(MethodDefinition read) {
        LocalVariableDefinition protocol = read.getLocalVariable("reader");
        TreeMap<Short, LocalVariableDefinition> structData = new TreeMap<Short, LocalVariableDefinition>();
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            LocalVariableDefinition variable = read.addInitializedLocalVariable(ThriftCodecByteCodeGenerator.toParameterizedType(field.getThriftType()), "f_" + field.getName());
            structData.put(field.getId(), variable);
        }
        read.loadVariable(protocol).invokeVirtual(TProtocolReader.class, "readStructBegin", Void.TYPE, new Class[0]);
        read.visitLabel("while-begin");
        read.loadVariable(protocol).invokeVirtual(TProtocolReader.class, "nextField", Boolean.TYPE, new Class[0]);
        read.ifZeroGoto("while-end");
        read.loadVariable(protocol).invokeVirtual(TProtocolReader.class, "getFieldId", Short.TYPE, new Class[0]);
        ArrayList<CaseStatement> cases = new ArrayList<CaseStatement>();
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            cases.add(CaseStatement.caseStatement(field.getId(), field.getName() + "-field"));
        }
        read.switchStatement("default", cases);
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            Method readMethod;
            read.visitLabel(field.getName() + "-field");
            read.loadVariable(protocol);
            FieldDefinition codecField = this.codecFields.get(field.getId());
            if (codecField != null) {
                read.loadThis().getField(this.codecType, codecField);
            }
            if ((readMethod = this.getReadMethod(field.getThriftType())) == null) {
                throw new IllegalArgumentException("Unsupported field type " + (Object)((Object)field.getThriftType().getProtocolType()));
            }
            read.invokeVirtual(readMethod);
            if (ThriftCodecByteCodeGenerator.needsCastAfterRead(field, readMethod)) {
                read.checkCast(ThriftCodecByteCodeGenerator.toParameterizedType(field.getThriftType()));
            }
            if (field.getCoercion().isPresent()) {
                read.invokeStatic(((TypeCoercion)field.getCoercion().get()).getFromThrift());
            }
            read.storeVariable((LocalVariableDefinition)structData.get(field.getId()));
            read.gotoLabel("while-begin");
        }
        read.visitLabel("default").loadVariable(protocol).invokeVirtual(TProtocolReader.class, "skipFieldData", Void.TYPE, new Class[0]).gotoLabel("while-begin");
        read.visitLabel("while-end");
        read.loadVariable(protocol).invokeVirtual(TProtocolReader.class, "readStructEnd", Void.TYPE, new Class[0]);
        return structData;
    }

    private LocalVariableDefinition buildStruct(MethodDefinition read, Map<Short, LocalVariableDefinition> structData) {
        LocalVariableDefinition instance = this.constructStructInstance(read, structData);
        this.injectStructFields(read, instance, structData);
        this.injectStructMethods(read, instance, structData);
        this.invokeFactoryMethod(read, structData, instance);
        return instance;
    }

    private LocalVariableDefinition constructStructInstance(MethodDefinition read, Map<Short, LocalVariableDefinition> structData) {
        LocalVariableDefinition instance = read.addLocalVariable(this.structType, "instance");
        if (this.metadata.getBuilderClass() == null) {
            read.newObject(this.structType).dup();
        } else {
            read.newObject(this.metadata.getBuilderClass()).dup();
        }
        ThriftConstructorInjection constructor = (ThriftConstructorInjection)this.metadata.getConstructorInjection().get();
        for (ThriftParameterInjection parameter : constructor.getParameters()) {
            read.loadVariable(structData.get(parameter.getId()));
        }
        read.invokeConstructor(constructor.getConstructor()).storeVariable(instance);
        return instance;
    }

    private void injectStructFields(MethodDefinition read, LocalVariableDefinition instance, Map<Short, LocalVariableDefinition> structData) {
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            this.injectField(read, field, instance, structData.get(field.getId()));
        }
    }

    private void injectStructMethods(MethodDefinition read, LocalVariableDefinition instance, Map<Short, LocalVariableDefinition> structData) {
        for (ThriftMethodInjection methodInjection : this.metadata.getMethodInjections()) {
            this.injectMethod(read, methodInjection, instance, structData);
        }
    }

    private void defineReadUnionMethod() {
        MethodDefinition read = new MethodDefinition(Access.a(Access.PUBLIC), "read", this.structType, NamedParameterDefinition.arg("protocol", TProtocol.class)).addException(Exception.class);
        read.addLocalVariable(ParameterizedType.type(TProtocolReader.class), "reader");
        read.newObject(TProtocolReader.class);
        read.dup();
        read.loadVariable("protocol");
        read.invokeConstructor(ParameterizedType.type(TProtocolReader.class), ParameterizedType.type(TProtocol.class));
        read.storeVariable("reader");
        read.addInitializedLocalVariable(ParameterizedType.type(Short.TYPE), "fieldId");
        Map<Short, LocalVariableDefinition> unionData = this.readSingleFieldValue(read);
        LocalVariableDefinition result = this.buildUnion(read, unionData);
        read.loadVariable(result).retObject();
        this.classDefinition.addMethod(read);
    }

    private Map<Short, LocalVariableDefinition> readSingleFieldValue(MethodDefinition read) {
        LocalVariableDefinition protocol = read.getLocalVariable("reader");
        TreeMap<Short, LocalVariableDefinition> unionData = new TreeMap<Short, LocalVariableDefinition>();
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            LocalVariableDefinition variable = read.addInitializedLocalVariable(ThriftCodecByteCodeGenerator.toParameterizedType(field.getThriftType()), "f_" + field.getName());
            unionData.put(field.getId(), variable);
        }
        read.loadVariable(protocol).invokeVirtual(TProtocolReader.class, "readStructBegin", Void.TYPE, new Class[0]);
        read.visitLabel("while-begin");
        read.loadVariable(protocol).invokeVirtual(TProtocolReader.class, "nextField", Boolean.TYPE, new Class[0]);
        read.ifZeroGoto("while-end");
        read.loadVariable(protocol).invokeVirtual(TProtocolReader.class, "getFieldId", Short.TYPE, new Class[0]);
        read.storeVariable("fieldId");
        read.loadVariable("fieldId");
        ArrayList<CaseStatement> cases = new ArrayList<CaseStatement>();
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            cases.add(CaseStatement.caseStatement(field.getId(), field.getName() + "-field"));
        }
        read.switchStatement("default", cases);
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            Method readMethod;
            read.visitLabel(field.getName() + "-field");
            read.loadVariable(protocol);
            FieldDefinition codecField = this.codecFields.get(field.getId());
            if (codecField != null) {
                read.loadThis().getField(this.codecType, codecField);
            }
            if ((readMethod = this.getReadMethod(field.getThriftType())) == null) {
                throw new IllegalArgumentException("Unsupported field type " + (Object)((Object)field.getThriftType().getProtocolType()));
            }
            read.invokeVirtual(readMethod);
            if (ThriftCodecByteCodeGenerator.needsCastAfterRead(field, readMethod)) {
                read.checkCast(ThriftCodecByteCodeGenerator.toParameterizedType(field.getThriftType()));
            }
            if (field.getCoercion().isPresent()) {
                read.invokeStatic(((TypeCoercion)field.getCoercion().get()).getFromThrift());
            }
            read.storeVariable((LocalVariableDefinition)unionData.get(field.getId()));
            read.gotoLabel("while-begin");
        }
        read.visitLabel("default").loadVariable(protocol).invokeVirtual(TProtocolReader.class, "skipFieldData", Void.TYPE, new Class[0]).gotoLabel("while-begin");
        read.visitLabel("while-end");
        read.loadVariable(protocol).invokeVirtual(TProtocolReader.class, "readStructEnd", Void.TYPE, new Class[0]);
        return unionData;
    }

    private LocalVariableDefinition buildUnion(MethodDefinition read, Map<Short, LocalVariableDefinition> unionData) {
        LocalVariableDefinition instance = this.constructUnionInstance(read);
        read.loadVariable("fieldId");
        ArrayList<CaseStatement> cases = new ArrayList<CaseStatement>();
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            cases.add(CaseStatement.caseStatement(field.getId(), field.getName() + "-inject-field"));
        }
        read.switchStatement("inject-default", cases);
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            read.visitLabel(field.getName() + "-inject-field");
            this.injectField(read, field, instance, unionData.get(field.getId()));
            if (field.getMethodInjection().isPresent()) {
                this.injectMethod(read, (ThriftMethodInjection)field.getMethodInjection().get(), instance, unionData);
            }
            read.gotoLabel("inject-default");
        }
        read.visitLabel("inject-default");
        ThriftFieldMetadata idField = (ThriftFieldMetadata)Iterables.getOnlyElement(this.metadata.getFields(FieldKind.THRIFT_UNION_ID));
        this.injectIdField(read, idField, instance, unionData);
        this.invokeFactoryMethod(read, unionData, instance);
        return instance;
    }

    private LocalVariableDefinition constructUnionInstance(MethodDefinition read) {
        LocalVariableDefinition instance = read.addLocalVariable(this.structType, "instance");
        if (this.metadata.getBuilderClass() == null) {
            read.newObject(this.structType).dup();
        } else {
            read.newObject(this.metadata.getBuilderClass()).dup();
        }
        read.loadVariable("fieldId");
        ArrayList<CaseStatement> cases = new ArrayList<CaseStatement>();
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            if (!field.getConstructorInjection().isPresent()) continue;
            cases.add(CaseStatement.caseStatement(field.getId(), field.getName() + "-id-field"));
        }
        read.switchStatement("no-field-ctor", cases);
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            if (!field.getConstructorInjection().isPresent()) continue;
            read.visitLabel(field.getName() + "-id-field");
            read.loadVariable("f_" + field.getName());
            read.invokeConstructor(((ThriftConstructorInjection)field.getConstructorInjection().get()).getConstructor()).storeVariable(instance).gotoLabel("instance-ok");
        }
        read.visitLabel("no-field-ctor");
        if (this.metadata.getConstructorInjection().isPresent()) {
            ThriftConstructorInjection constructor = (ThriftConstructorInjection)this.metadata.getConstructorInjection().get();
            read.invokeConstructor(constructor.getConstructor()).storeVariable(instance);
        } else {
            read.pop().loadConstant(this.metadata.getStructClass()).loadVariable("fieldId").invokeStatic(SwiftBytecodeHelper.NO_CONSTRUCTOR_FOUND).throwException();
        }
        read.visitLabel("instance-ok");
        return instance;
    }

    private void injectField(MethodDefinition read, ThriftFieldMetadata field, LocalVariableDefinition instance, LocalVariableDefinition sourceVariable) {
        for (ThriftInjection injection : field.getInjections()) {
            if (!(injection instanceof ThriftFieldInjection)) continue;
            ThriftFieldInjection fieldInjection = (ThriftFieldInjection)injection;
            if (!this.isProtocolTypeJavaPrimitive(field)) {
                read.loadVariable(sourceVariable).ifNullGoto("field_is_null_" + field.getName());
            }
            read.loadVariable(instance).loadVariable(sourceVariable).putField(fieldInjection.getField());
            if (this.isProtocolTypeJavaPrimitive(field)) continue;
            read.visitLabel("field_is_null_" + field.getName());
        }
    }

    private void injectMethod(MethodDefinition read, ThriftMethodInjection methodInjection, LocalVariableDefinition instance, Map<Short, LocalVariableDefinition> structData) {
        String methodName = methodInjection.getMethod().toGenericString();
        for (ThriftParameterInjection parameter : methodInjection.getParameters()) {
            if (!this.isParameterTypeJavaPrimitive(parameter)) {
                read.loadVariable(structData.get(parameter.getId())).ifNotNullGoto("invoke_" + methodName);
                continue;
            }
            read.gotoLabel("invoke_" + methodName);
        }
        read.gotoLabel("skip_invoke_" + methodName);
        read.visitLabel("invoke_" + methodName).loadVariable(instance);
        for (ThriftParameterInjection parameter : methodInjection.getParameters()) {
            read.loadVariable(structData.get(parameter.getId()));
        }
        read.invokeVirtual(methodInjection.getMethod());
        if (methodInjection.getMethod().getReturnType() != Void.TYPE) {
            read.pop();
        }
        read.visitLabel("skip_invoke_" + methodName);
    }

    private void invokeFactoryMethod(MethodDefinition read, Map<Short, LocalVariableDefinition> structData, LocalVariableDefinition instance) {
        if (this.metadata.getBuilderMethod().isPresent()) {
            ThriftMethodInjection builderMethod = (ThriftMethodInjection)this.metadata.getBuilderMethod().get();
            read.loadVariable(instance);
            for (ThriftParameterInjection parameter : builderMethod.getParameters()) {
                read.loadVariable(structData.get(parameter.getId()));
            }
            read.invokeVirtual(builderMethod.getMethod()).storeVariable(instance);
        }
    }

    private void injectIdField(MethodDefinition read, ThriftFieldMetadata field, LocalVariableDefinition instance, Map<Short, LocalVariableDefinition> structData) {
        for (ThriftInjection injection : field.getInjections()) {
            if (!(injection instanceof ThriftFieldInjection)) continue;
            ThriftFieldInjection fieldInjection = (ThriftFieldInjection)injection;
            if (!this.isProtocolTypeJavaPrimitive(field)) {
                read.loadVariable("fieldId").ifNullGoto("field_is_null_fieldId");
            }
            read.loadVariable(instance).loadVariable("fieldId").putField(fieldInjection.getField());
            if (this.isProtocolTypeJavaPrimitive(field)) continue;
            read.visitLabel("field_is_null_fieldId");
        }
    }

    private void defineWriteStructMethod() {
        MethodDefinition write = new MethodDefinition(Access.a(Access.PUBLIC), "write", null, NamedParameterDefinition.arg("struct", this.structType), NamedParameterDefinition.arg("protocol", TProtocol.class));
        this.classDefinition.addMethod(write);
        write.addLocalVariable(ParameterizedType.type(TProtocolWriter.class), "writer");
        write.newObject(TProtocolWriter.class);
        write.dup();
        write.loadVariable("protocol");
        write.invokeConstructor(ParameterizedType.type(TProtocolWriter.class), ParameterizedType.type(TProtocol.class));
        write.storeVariable("writer");
        LocalVariableDefinition protocol = write.getLocalVariable("writer");
        write.loadVariable(protocol).loadConstant(this.metadata.getStructName()).invokeVirtual(TProtocolWriter.class, "writeStructBegin", Void.TYPE, String.class);
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            this.writeField(write, protocol, field);
        }
        write.loadVariable(protocol).invokeVirtual(TProtocolWriter.class, "writeStructEnd", Void.TYPE, new Class[0]);
        write.ret();
    }

    private void defineWriteUnionMethod() {
        MethodDefinition write = new MethodDefinition(Access.a(Access.PUBLIC), "write", null, NamedParameterDefinition.arg("struct", this.structType), NamedParameterDefinition.arg("protocol", TProtocol.class));
        this.classDefinition.addMethod(write);
        write.addLocalVariable(ParameterizedType.type(TProtocolWriter.class), "writer");
        write.newObject(TProtocolWriter.class);
        write.dup();
        write.loadVariable("protocol");
        write.invokeConstructor(ParameterizedType.type(TProtocolWriter.class), ParameterizedType.type(TProtocol.class));
        write.storeVariable("writer");
        LocalVariableDefinition protocol = write.getLocalVariable("writer");
        write.loadVariable(protocol).loadConstant(this.metadata.getStructName()).invokeVirtual(TProtocolWriter.class, "writeStructBegin", Void.TYPE, String.class);
        ThriftFieldMetadata idField = (ThriftFieldMetadata)Iterables.getOnlyElement(this.metadata.getFields(FieldKind.THRIFT_UNION_ID));
        this.loadFieldValue(write, idField);
        ArrayList<CaseStatement> cases = new ArrayList<CaseStatement>();
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            cases.add(CaseStatement.caseStatement(field.getId(), field.getName() + "-write-field"));
        }
        write.switchStatement("default-write", cases);
        for (ThriftFieldMetadata field : this.metadata.getFields(FieldKind.THRIFT_FIELD)) {
            write.visitLabel(field.getName() + "-write-field");
            this.writeField(write, protocol, field);
            write.gotoLabel("default-write");
        }
        write.visitLabel("default-write").loadVariable(protocol).invokeVirtual(TProtocolWriter.class, "writeStructEnd", Void.TYPE, new Class[0]);
        write.ret();
    }

    private void writeField(MethodDefinition write, LocalVariableDefinition protocol, ThriftFieldMetadata field) {
        Method writeMethod;
        write.loadVariable(protocol);
        write.loadConstant(field.getName());
        write.loadConstant(field.getId());
        FieldDefinition codecField = this.codecFields.get(field.getId());
        if (codecField != null) {
            write.loadThis().getField(this.codecType, codecField);
        }
        this.loadFieldValue(write, field);
        if (!this.isFieldTypeJavaPrimitive(field)) {
            write.dup();
            write.ifNullGoto("field_is_null_" + field.getName());
        }
        if (field.getCoercion().isPresent()) {
            write.invokeStatic(((TypeCoercion)field.getCoercion().get()).getToThrift());
            if (!this.isProtocolTypeJavaPrimitive(field)) {
                write.dup();
                write.ifNullGoto("field_is_null_" + field.getName());
            }
        }
        if ((writeMethod = this.getWriteMethod(field.getThriftType())) == null) {
            throw new IllegalArgumentException("Unsupported field type " + (Object)((Object)field.getThriftType().getProtocolType()));
        }
        write.invokeVirtual(writeMethod);
        if (!this.isProtocolTypeJavaPrimitive(field) || !this.isFieldTypeJavaPrimitive(field)) {
            write.gotoLabel("field_end_" + field.getName());
            write.visitLabel("field_is_null_" + field.getName());
            write.pop();
            if (codecField != null) {
                write.pop();
            }
            write.pop();
            write.pop();
            write.pop();
            write.visitLabel("field_end_" + field.getName());
        }
    }

    private void loadFieldValue(MethodDefinition write, ThriftFieldMetadata field) {
        write.loadVariable("struct");
        if (field.getExtraction().isPresent()) {
            ThriftExtraction extraction = (ThriftExtraction)field.getExtraction().get();
            if (extraction instanceof ThriftFieldExtractor) {
                ThriftFieldExtractor fieldExtractor = (ThriftFieldExtractor)extraction;
                write.getField(fieldExtractor.getField());
                if (fieldExtractor.isGeneric()) {
                    write.checkCast(ParameterizedType.type(fieldExtractor.getType()));
                }
            } else if (extraction instanceof ThriftMethodExtractor) {
                ThriftMethodExtractor methodExtractor = (ThriftMethodExtractor)extraction;
                write.invokeVirtual(methodExtractor.getMethod());
                if (methodExtractor.isGeneric()) {
                    write.checkCast(ParameterizedType.type(methodExtractor.getType()));
                }
            }
        }
    }

    private void defineReadBridgeMethod() {
        this.classDefinition.addMethod(new MethodDefinition(Access.a(Access.PUBLIC, Access.BRIDGE, Access.SYNTHETIC), "read", ParameterizedType.type(Object.class), NamedParameterDefinition.arg("protocol", TProtocol.class)).addException(Exception.class).loadThis().loadVariable("protocol").invokeVirtual(this.codecType, "read", this.structType, ParameterizedType.type(TProtocol.class)).retObject());
    }

    private void defineWriteBridgeMethod() {
        this.classDefinition.addMethod(new MethodDefinition(Access.a(Access.PUBLIC, Access.BRIDGE, Access.SYNTHETIC), "write", null, NamedParameterDefinition.arg("struct", Object.class), NamedParameterDefinition.arg("protocol", TProtocol.class)).addException(Exception.class).loadThis().loadVariable("struct", this.structType).loadVariable("protocol").invokeVirtual(this.codecType, "write", ParameterizedType.type(Void.TYPE), this.structType, ParameterizedType.type(TProtocol.class)).ret());
    }

    private boolean isParameterTypeJavaPrimitive(ThriftParameterInjection parameter) {
        return this.isJavaPrimitive(TypeToken.of((Type)parameter.getJavaType()));
    }

    private boolean isFieldTypeJavaPrimitive(ThriftFieldMetadata field) {
        return this.isJavaPrimitive(TypeToken.of((Type)field.getThriftType().getJavaType()));
    }

    private boolean isProtocolTypeJavaPrimitive(ThriftFieldMetadata field) {
        if (field.getThriftType().isCoerced()) {
            return this.isJavaPrimitive(TypeToken.of((Type)field.getThriftType().getUncoercedType().getJavaType()));
        }
        return this.isJavaPrimitive(TypeToken.of((Type)field.getThriftType().getJavaType()));
    }

    private boolean isJavaPrimitive(TypeToken<?> typeToken) {
        return typeToken.getRawType().isPrimitive();
    }

    private static boolean needsCastAfterRead(ThriftFieldMetadata field, Method readMethod) {
        Class<?> methodReturn = readMethod.getReturnType();
        Class<?> fieldType = field.getCoercion().isPresent() ? ((TypeCoercion)field.getCoercion().get()).getFromThrift().getParameterTypes()[0] : TypeToken.of((Type)field.getThriftType().getJavaType()).getRawType();
        boolean needsCast = !fieldType.isAssignableFrom(methodReturn);
        return needsCast;
    }

    private boolean needsCodec(ThriftFieldMetadata fieldMetadata) {
        if (ReflectionHelper.isArray(fieldMetadata.getThriftType().getJavaType())) {
            return false;
        }
        ThriftProtocolType protocolType = fieldMetadata.getThriftType().getProtocolType();
        return protocolType == ThriftProtocolType.ENUM || protocolType == ThriftProtocolType.STRUCT || protocolType == ThriftProtocolType.SET || protocolType == ThriftProtocolType.LIST || protocolType == ThriftProtocolType.MAP;
    }

    private ParameterizedType toCodecType(ThriftStructMetadata metadata) {
        return ParameterizedType.type("$wift/" + ParameterizedType.type(metadata.getStructClass()).getClassName() + "Codec");
    }

    public static ParameterizedType toParameterizedType(ThriftType type) {
        return ThriftCodecByteCodeGenerator.toParameterizedType(new DefaultThriftTypeReference(type));
    }

    public static ParameterizedType toParameterizedType(ThriftTypeReference typeRef) {
        if (ReflectionHelper.isArray(typeRef.getJavaType())) {
            return ParameterizedType.type((Class)typeRef.getJavaType());
        }
        switch (typeRef.getProtocolType()) {
            case BOOL: 
            case BYTE: 
            case DOUBLE: 
            case I16: 
            case I32: 
            case I64: 
            case STRING: 
            case BINARY: 
            case STRUCT: 
            case ENUM: {
                return ParameterizedType.type((Class)typeRef.getJavaType());
            }
            case MAP: {
                return ParameterizedType.type(Map.class, ThriftCodecByteCodeGenerator.toParameterizedType(typeRef.get().getKeyTypeReference()), ThriftCodecByteCodeGenerator.toParameterizedType(typeRef.get().getValueTypeReference()));
            }
            case SET: {
                return ParameterizedType.type(Set.class, ThriftCodecByteCodeGenerator.toParameterizedType(typeRef.get().getValueTypeReference()));
            }
            case LIST: {
                return ParameterizedType.type(List.class, ThriftCodecByteCodeGenerator.toParameterizedType(typeRef.get().getValueTypeReference()));
            }
        }
        throw new IllegalArgumentException("Unsupported thrift field type " + typeRef.getJavaType());
    }

    private Method getWriteMethod(ThriftType thriftType) {
        if (ReflectionHelper.isArray(thriftType.getJavaType())) {
            return ARRAY_WRITE_METHODS.get(thriftType.getJavaType());
        }
        return WRITE_METHODS.get((Object)thriftType.getProtocolType());
    }

    private Method getReadMethod(ThriftType thriftType) {
        if (ReflectionHelper.isArray(thriftType.getJavaType())) {
            return ARRAY_READ_METHODS.get(thriftType.getJavaType());
        }
        return READ_METHODS.get((Object)thriftType.getProtocolType());
    }

    static {
        ImmutableMap.Builder writeBuilder = ImmutableMap.builder();
        ImmutableMap.Builder readBuilder = ImmutableMap.builder();
        try {
            writeBuilder.put((Object)ThriftProtocolType.BOOL, (Object)TProtocolWriter.class.getMethod("writeBoolField", String.class, Short.TYPE, Boolean.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.BYTE, (Object)TProtocolWriter.class.getMethod("writeByteField", String.class, Short.TYPE, Byte.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.DOUBLE, (Object)TProtocolWriter.class.getMethod("writeDoubleField", String.class, Short.TYPE, Double.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.I16, (Object)TProtocolWriter.class.getMethod("writeI16Field", String.class, Short.TYPE, Short.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.I32, (Object)TProtocolWriter.class.getMethod("writeI32Field", String.class, Short.TYPE, Integer.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.I64, (Object)TProtocolWriter.class.getMethod("writeI64Field", String.class, Short.TYPE, Long.TYPE));
            writeBuilder.put((Object)ThriftProtocolType.STRING, (Object)TProtocolWriter.class.getMethod("writeStringField", String.class, Short.TYPE, String.class));
            writeBuilder.put((Object)ThriftProtocolType.BINARY, (Object)TProtocolWriter.class.getMethod("writeBinaryField", String.class, Short.TYPE, ByteBuffer.class));
            writeBuilder.put((Object)ThriftProtocolType.STRUCT, (Object)TProtocolWriter.class.getMethod("writeStructField", String.class, Short.TYPE, ThriftCodec.class, Object.class));
            writeBuilder.put((Object)ThriftProtocolType.MAP, (Object)TProtocolWriter.class.getMethod("writeMapField", String.class, Short.TYPE, ThriftCodec.class, Map.class));
            writeBuilder.put((Object)ThriftProtocolType.SET, (Object)TProtocolWriter.class.getMethod("writeSetField", String.class, Short.TYPE, ThriftCodec.class, Set.class));
            writeBuilder.put((Object)ThriftProtocolType.LIST, (Object)TProtocolWriter.class.getMethod("writeListField", String.class, Short.TYPE, ThriftCodec.class, List.class));
            writeBuilder.put((Object)ThriftProtocolType.ENUM, (Object)TProtocolWriter.class.getMethod("writeEnumField", String.class, Short.TYPE, ThriftCodec.class, Enum.class));
            readBuilder.put((Object)ThriftProtocolType.BOOL, (Object)TProtocolReader.class.getMethod("readBoolField", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.BYTE, (Object)TProtocolReader.class.getMethod("readByteField", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.DOUBLE, (Object)TProtocolReader.class.getMethod("readDoubleField", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.I16, (Object)TProtocolReader.class.getMethod("readI16Field", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.I32, (Object)TProtocolReader.class.getMethod("readI32Field", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.I64, (Object)TProtocolReader.class.getMethod("readI64Field", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.STRING, (Object)TProtocolReader.class.getMethod("readStringField", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.BINARY, (Object)TProtocolReader.class.getMethod("readBinaryField", new Class[0]));
            readBuilder.put((Object)ThriftProtocolType.STRUCT, (Object)TProtocolReader.class.getMethod("readStructField", ThriftCodec.class));
            readBuilder.put((Object)ThriftProtocolType.MAP, (Object)TProtocolReader.class.getMethod("readMapField", ThriftCodec.class));
            readBuilder.put((Object)ThriftProtocolType.SET, (Object)TProtocolReader.class.getMethod("readSetField", ThriftCodec.class));
            readBuilder.put((Object)ThriftProtocolType.LIST, (Object)TProtocolReader.class.getMethod("readListField", ThriftCodec.class));
            readBuilder.put((Object)ThriftProtocolType.ENUM, (Object)TProtocolReader.class.getMethod("readEnumField", ThriftCodec.class));
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
        WRITE_METHODS = writeBuilder.build();
        READ_METHODS = readBuilder.build();
        ImmutableMap.Builder arrayWriteBuilder = ImmutableMap.builder();
        ImmutableMap.Builder arrayReadBuilder = ImmutableMap.builder();
        try {
            arrayWriteBuilder.put(boolean[].class, (Object)TProtocolWriter.class.getMethod("writeBoolArrayField", String.class, Short.TYPE, boolean[].class));
            arrayWriteBuilder.put(short[].class, (Object)TProtocolWriter.class.getMethod("writeI16ArrayField", String.class, Short.TYPE, short[].class));
            arrayWriteBuilder.put(int[].class, (Object)TProtocolWriter.class.getMethod("writeI32ArrayField", String.class, Short.TYPE, int[].class));
            arrayWriteBuilder.put(long[].class, (Object)TProtocolWriter.class.getMethod("writeI64ArrayField", String.class, Short.TYPE, long[].class));
            arrayWriteBuilder.put(double[].class, (Object)TProtocolWriter.class.getMethod("writeDoubleArrayField", String.class, Short.TYPE, double[].class));
            arrayReadBuilder.put(boolean[].class, (Object)TProtocolReader.class.getMethod("readBoolArrayField", new Class[0]));
            arrayReadBuilder.put(short[].class, (Object)TProtocolReader.class.getMethod("readI16ArrayField", new Class[0]));
            arrayReadBuilder.put(int[].class, (Object)TProtocolReader.class.getMethod("readI32ArrayField", new Class[0]));
            arrayReadBuilder.put(long[].class, (Object)TProtocolReader.class.getMethod("readI64ArrayField", new Class[0]));
            arrayReadBuilder.put(double[].class, (Object)TProtocolReader.class.getMethod("readDoubleArrayField", new Class[0]));
            arrayWriteBuilder.put(byte[].class, (Object)TProtocolWriter.class.getMethod("writeBinaryField", String.class, Short.TYPE, ByteBuffer.class));
            arrayReadBuilder.put(byte[].class, (Object)TProtocolReader.class.getMethod("readBinaryField", new Class[0]));
        }
        catch (NoSuchMethodException e) {
            throw Throwables.propagate((Throwable)e);
        }
        ARRAY_WRITE_METHODS = arrayWriteBuilder.build();
        ARRAY_READ_METHODS = arrayReadBuilder.build();
    }

    private static class ConstructorParameters {
        private final List<FieldDefinition> fields = new ArrayList<FieldDefinition>();
        private final List<Object> values = new ArrayList<Object>();

        private ConstructorParameters() {
        }

        private void add(FieldDefinition field, Object value) {
            this.fields.add(field);
            this.values.add(value);
        }

        public List<FieldDefinition> getFields() {
            return this.fields;
        }

        public Object[] getValues() {
            return this.values.toArray(new Object[this.values.size()]);
        }

        public List<NamedParameterDefinition> getParameters() {
            return Lists.transform(this.fields, (Function)new Function<FieldDefinition, NamedParameterDefinition>(){

                public NamedParameterDefinition apply(FieldDefinition field) {
                    return NamedParameterDefinition.arg(field.getName(), field.getType());
                }
            });
        }

        public Class<?>[] getTypes() {
            List types = Lists.transform(this.values, (Function)new Function<Object, Class<?>>(){

                public Class<?> apply(Object value) {
                    return value.getClass();
                }
            });
            return types.toArray(new Class[types.size()]);
        }
    }
}

