/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.swift.codec.guice;

import com.facebook.swift.codec.InternalThriftCodec;
import com.facebook.swift.codec.ThriftCodec;
import com.facebook.swift.codec.ThriftCodecManager;
import com.google.common.base.Preconditions;
import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.google.inject.Provider;
import com.google.inject.Scopes;
import com.google.inject.TypeLiteral;
import com.google.inject.internal.MoreTypes;
import com.google.inject.multibindings.Multibinder;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class ThriftCodecBinder {
    private final Binder binder;

    public static ThriftCodecBinder thriftCodecBinder(Binder binder) {
        return new ThriftCodecBinder(binder);
    }

    private ThriftCodecBinder(Binder binder) {
        this.binder = binder;
    }

    public void bindCustomThriftCodec(ThriftCodec<?> thriftCodec) {
        Preconditions.checkNotNull(thriftCodec, (Object)"thriftCodec is null");
        Multibinder.newSetBinder((Binder)this.binder, (TypeLiteral)new TypeLiteral<ThriftCodec<?>>(){}, InternalThriftCodec.class).addBinding().toInstance(thriftCodec);
        Type type = thriftCodec.getType().getJavaType();
        this.binder.bind(this.getThriftCodecKey(type)).toProvider((Provider)new ThriftCodecProvider(type)).in(Scopes.SINGLETON);
    }

    public void bindCustomThriftCodec(Class<? extends ThriftCodec<?>> thriftCodecType) {
        Preconditions.checkNotNull(thriftCodecType, (Object)"thriftCodecType is null");
        this.bindCustomThriftCodec(Key.get(thriftCodecType));
    }

    public void bindCustomThriftCodec(TypeLiteral<? extends ThriftCodec<?>> thriftCodecType) {
        Preconditions.checkNotNull(thriftCodecType, (Object)"thriftCodecType is null");
        this.bindCustomThriftCodec(Key.get(thriftCodecType));
    }

    public void bindCustomThriftCodec(Key<? extends ThriftCodec<?>> thriftCodecKey) {
        Preconditions.checkNotNull(thriftCodecKey, (Object)"thriftCodecKey is null");
        Multibinder.newSetBinder((Binder)this.binder, (TypeLiteral)new TypeLiteral<ThriftCodec<?>>(){}, InternalThriftCodec.class).addBinding().to(thriftCodecKey);
        this.binder.bind(thriftCodecKey).in(Scopes.SINGLETON);
    }

    public void bindThriftCodec(Class<?> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        this.bindThriftCodec(TypeLiteral.get(type));
    }

    public void bindThriftCodec(TypeLiteral<?> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        this.bindThriftCodec(Key.get(type));
    }

    public void bindThriftCodec(Key<?> key) {
        Preconditions.checkNotNull(key, (Object)"key is null");
        Type type = key.getTypeLiteral().getType();
        this.binder.bind(this.getThriftCodecKey(type)).toProvider((Provider)new ThriftCodecProvider(type)).in(Scopes.SINGLETON);
    }

    public void bindListThriftCodec(Class<?> type) {
        Preconditions.checkNotNull(type, (Object)"type is null");
        MoreTypes.ParameterizedTypeImpl listType = new MoreTypes.ParameterizedTypeImpl(null, List.class, new Type[]{type});
        this.binder.bind(this.getThriftCodecKey((Type)listType)).toProvider((Provider)new ThriftCodecProvider((Type)listType)).in(Scopes.SINGLETON);
    }

    public void bindMapThriftCodec(Class<?> keyType, Class<?> valueType) {
        Preconditions.checkNotNull(keyType, (Object)"keyType is null");
        Preconditions.checkNotNull(valueType, (Object)"valueType is null");
        MoreTypes.ParameterizedTypeImpl mapType = new MoreTypes.ParameterizedTypeImpl(null, Map.class, new Type[]{keyType, valueType});
        this.binder.bind(this.getThriftCodecKey((Type)mapType)).toProvider((Provider)new ThriftCodecProvider((Type)mapType)).in(Scopes.SINGLETON);
    }

    private Key<ThriftCodec<?>> getThriftCodecKey(Type type) {
        return Key.get((Type)new MoreTypes.ParameterizedTypeImpl(null, ThriftCodec.class, new Type[]{type}));
    }

    static class ThriftCodecProvider
    implements Provider<ThriftCodec<?>> {
        private final Type type;
        private ThriftCodecManager thriftCodecManager;

        public ThriftCodecProvider(Type type) {
            this.type = type;
        }

        @Inject
        public void setThriftCodecManager(ThriftCodecManager thriftCodecManager) {
            this.thriftCodecManager = thriftCodecManager;
        }

        public ThriftCodec<?> get() {
            return this.thriftCodecManager.getCodec(this.type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ThriftCodecProvider that = (ThriftCodecProvider)o;
            return this.type.equals(that.type);
        }

        public int hashCode() {
            return this.type.hashCode();
        }
    }
}

