/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.Promise;
import com.facebook.react.bridge.WritableNativeMap;
import javax.annotation.Nullable;

public class PromiseImpl
implements Promise {
    private static final String DEFAULT_ERROR = "EUNSPECIFIED";
    @Nullable
    private Callback mResolve;
    @Nullable
    private Callback mReject;

    public PromiseImpl(@Nullable Callback resolve, @Nullable Callback reject) {
        this.mResolve = resolve;
        this.mReject = reject;
    }

    @Override
    public void resolve(Object value) {
        if (this.mResolve != null) {
            this.mResolve.invoke(value);
        }
    }

    @Override
    public void reject(String code, String message) {
        this.reject(code, message, null);
    }

    @Override
    @Deprecated
    public void reject(String message) {
        this.reject(DEFAULT_ERROR, message, null);
    }

    @Override
    public void reject(String code, Throwable e) {
        this.reject(code, e.getMessage(), e);
    }

    @Override
    public void reject(Throwable e) {
        this.reject(DEFAULT_ERROR, e.getMessage(), e);
    }

    @Override
    public void reject(String code, String message, @Nullable Throwable e) {
        if (this.mReject != null) {
            if (code == null) {
                code = DEFAULT_ERROR;
            }
            WritableNativeMap errorInfo = new WritableNativeMap();
            errorInfo.putString("code", code);
            errorInfo.putString("message", message);
            this.mReject.invoke(errorInfo);
        }
    }
}

