/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.animation;

import android.view.View;
import com.facebook.react.animation.AnimationPropertyUpdater;

public abstract class AbstractSingleFloatProperyUpdater
implements AnimationPropertyUpdater {
    private float mFromValue;
    private float mToValue;
    private boolean mFromSource;

    protected AbstractSingleFloatProperyUpdater(float toValue) {
        this.mToValue = toValue;
        this.mFromSource = true;
    }

    protected AbstractSingleFloatProperyUpdater(float fromValue, float toValue) {
        this(toValue);
        this.mFromValue = fromValue;
        this.mFromSource = false;
    }

    protected abstract float getProperty(View var1);

    protected abstract void setProperty(View var1, float var2);

    @Override
    public final void prepare(View view) {
        if (this.mFromSource) {
            this.mFromValue = this.getProperty(view);
        }
    }

    @Override
    public final void onUpdate(View view, float progress) {
        this.setProperty(view, this.mFromValue + (this.mToValue - this.mFromValue) * progress);
    }

    @Override
    public void onFinish(View view) {
        this.setProperty(view, this.mToValue);
    }
}

