/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.PixelUtil;
import java.util.Map;
import javax.annotation.Nullable;

public class ReactScrollViewCommandHelper {
    public static final int COMMAND_SCROLL_TO = 1;
    public static final int COMMAND_SCROLL_WITHOUT_ANIMATION_TO = 2;

    public static Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("scrollTo", 1, "scrollWithoutAnimationTo", 2);
    }

    public static <T> void receiveCommand(ScrollCommandHandler<T> viewManager, T scrollView, int commandType, @Nullable ReadableArray args) {
        Assertions.assertNotNull(viewManager);
        Assertions.assertNotNull(scrollView);
        Assertions.assertNotNull((Object)args);
        switch (commandType) {
            case 1: {
                int destX = Math.round(PixelUtil.toPixelFromDIP(args.getDouble(0)));
                int destY = Math.round(PixelUtil.toPixelFromDIP(args.getDouble(1)));
                viewManager.scrollTo(scrollView, new ScrollToCommandData(destX, destY));
                return;
            }
            case 2: {
                int destX = Math.round(PixelUtil.toPixelFromDIP(args.getDouble(0)));
                int destY = Math.round(PixelUtil.toPixelFromDIP(args.getDouble(1)));
                viewManager.scrollWithoutAnimationTo(scrollView, new ScrollToCommandData(destX, destY));
                return;
            }
        }
        throw new IllegalArgumentException(String.format("Unsupported command %d received by %s.", commandType, viewManager.getClass().getSimpleName()));
    }

    public static class ScrollToCommandData {
        public final int mDestX;
        public final int mDestY;

        ScrollToCommandData(int destX, int destY) {
            this.mDestX = destX;
            this.mDestY = destY;
        }
    }

    public static interface ScrollCommandHandler<T> {
        public void scrollTo(T var1, ScrollToCommandData var2);

        public void scrollWithoutAnimationTo(T var1, ScrollToCommandData var2);
    }
}

