/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.content.Context;
import android.util.SparseArray;
import android.util.SparseBooleanArray;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.PopupMenu;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.animation.Animation;
import com.facebook.react.animation.AnimationListener;
import com.facebook.react.animation.AnimationRegistry;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.SoftAssertions;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.touch.JSResponderHandler;
import com.facebook.react.uimanager.AccessibilityHelper;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.IllegalViewOperationException;
import com.facebook.react.uimanager.NoSuchNativeViewException;
import com.facebook.react.uimanager.RootViewManager;
import com.facebook.react.uimanager.RootViewUtil;
import com.facebook.react.uimanager.SizeMonitoringFrameLayout;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.TouchTargetHelper;
import com.facebook.react.uimanager.ViewAtIndex;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.ViewManagerRegistry;
import com.facebook.react.uimanager.layoutanimation.LayoutAnimationController;
import com.facebook.systrace.Systrace;
import com.facebook.systrace.SystraceMessage;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class NativeViewHierarchyManager {
    private final AnimationRegistry mAnimationRegistry;
    private final SparseArray<View> mTagsToViews;
    private final SparseArray<ViewManager> mTagsToViewManagers;
    private final SparseBooleanArray mRootTags;
    private final ViewManagerRegistry mViewManagers;
    private final JSResponderHandler mJSResponderHandler = new JSResponderHandler();
    private final RootViewManager mRootViewManager = new RootViewManager();
    private final LayoutAnimationController mLayoutAnimator = new LayoutAnimationController();
    private boolean mLayoutAnimationEnabled;

    public NativeViewHierarchyManager(ViewManagerRegistry viewManagers) {
        this.mAnimationRegistry = new AnimationRegistry();
        this.mViewManagers = viewManagers;
        this.mTagsToViews = new SparseArray();
        this.mTagsToViewManagers = new SparseArray();
        this.mRootTags = new SparseBooleanArray();
    }

    protected final View resolveView(int tag) {
        View view = (View)this.mTagsToViews.get(tag);
        if (view == null) {
            throw new IllegalViewOperationException("Trying to resolve view with tag " + tag + " which doesn't exist");
        }
        return view;
    }

    protected final ViewManager resolveViewManager(int tag) {
        ViewManager viewManager = (ViewManager)this.mTagsToViewManagers.get(tag);
        if (viewManager == null) {
            throw new IllegalViewOperationException("ViewManager for tag " + tag + " could not be found");
        }
        return viewManager;
    }

    public AnimationRegistry getAnimationRegistry() {
        return this.mAnimationRegistry;
    }

    public void setLayoutAnimationEnabled(boolean enabled) {
        this.mLayoutAnimationEnabled = enabled;
    }

    public void updateProperties(int tag, CatalystStylesDiffMap props) {
        UiThreadUtil.assertOnUiThread();
        ViewManager viewManager = this.resolveViewManager(tag);
        View viewToUpdate = this.resolveView(tag);
        viewManager.updateProperties(viewToUpdate, props);
    }

    public void updateViewExtraData(int tag, Object extraData) {
        UiThreadUtil.assertOnUiThread();
        ViewManager viewManager = this.resolveViewManager(tag);
        View viewToUpdate = this.resolveView(tag);
        viewManager.updateExtraData(viewToUpdate, extraData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateLayout(int parentTag, int tag, int x, int y, int width, int height) {
        UiThreadUtil.assertOnUiThread();
        SystraceMessage.beginSection(0L, "NativeViewHierarchyManager_updateLayout").arg("parentTag", parentTag).arg("tag", tag).flush();
        try {
            View viewToUpdate = this.resolveView(tag);
            viewToUpdate.measure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
            if (!this.mRootTags.get(parentTag)) {
                ViewManager parentViewManager = (ViewManager)this.mTagsToViewManagers.get(parentTag);
                if (!(parentViewManager instanceof ViewGroupManager)) {
                    throw new IllegalViewOperationException("Trying to use view with tag " + tag + " as a parent, but its Manager doesn't extends ViewGroupManager");
                }
                ViewGroupManager parentViewGroupManager = (ViewGroupManager)parentViewManager;
                if (parentViewGroupManager != null && !parentViewGroupManager.needsCustomLayoutForChildren()) {
                    this.updateLayout(viewToUpdate, x, y, width, height);
                }
            } else {
                this.updateLayout(viewToUpdate, x, y, width, height);
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    private void updateLayout(View viewToUpdate, int x, int y, int width, int height) {
        if (this.mLayoutAnimationEnabled && this.mLayoutAnimator.shouldAnimateLayout(viewToUpdate)) {
            this.mLayoutAnimator.applyLayoutUpdate(viewToUpdate, x, y, width, height);
        } else {
            viewToUpdate.layout(x, y, x + width, y + height);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createView(ThemedReactContext themedContext, int tag, String className, @Nullable CatalystStylesDiffMap initialProps) {
        UiThreadUtil.assertOnUiThread();
        SystraceMessage.beginSection(0L, "NativeViewHierarchyManager_createView").arg("tag", tag).arg("className", className).flush();
        try {
            ViewManager viewManager = this.mViewManagers.get(className);
            Object view = viewManager.createView(themedContext, this.mJSResponderHandler);
            this.mTagsToViews.put(tag, view);
            this.mTagsToViewManagers.put(tag, (Object)viewManager);
            view.setId(tag);
            if (initialProps != null) {
                viewManager.updateProperties(view, initialProps);
            }
        }
        finally {
            Systrace.endSection(0L);
        }
    }

    private static String constructManageChildrenErrorMessage(ViewGroup viewToManage, ViewGroupManager viewManager, @Nullable int[] indicesToRemove, @Nullable ViewAtIndex[] viewsToAdd, @Nullable int[] tagsToDelete) {
        int innerOffset;
        int index;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("View tag:" + viewToManage.getId() + "\n");
        stringBuilder.append("  children(" + viewManager.getChildCount(viewToManage) + "): [\n");
        for (index = 0; index < viewManager.getChildCount(viewToManage); index += 16) {
            for (innerOffset = 0; index + innerOffset < viewManager.getChildCount(viewToManage) && innerOffset < 16; ++innerOffset) {
                stringBuilder.append(viewManager.getChildAt(viewToManage, index + innerOffset).getId() + ",");
            }
            stringBuilder.append("\n");
        }
        stringBuilder.append(" ],\n");
        if (indicesToRemove != null) {
            stringBuilder.append("  indicesToRemove(" + indicesToRemove.length + "): [\n");
            for (index = 0; index < indicesToRemove.length; index += 16) {
                for (innerOffset = 0; index + innerOffset < indicesToRemove.length && innerOffset < 16; ++innerOffset) {
                    stringBuilder.append(indicesToRemove[index + innerOffset] + ",");
                }
                stringBuilder.append("\n");
            }
            stringBuilder.append(" ],\n");
        }
        if (viewsToAdd != null) {
            stringBuilder.append("  viewsToAdd(" + viewsToAdd.length + "): [\n");
            for (index = 0; index < viewsToAdd.length; index += 16) {
                for (innerOffset = 0; index + innerOffset < viewsToAdd.length && innerOffset < 16; ++innerOffset) {
                    stringBuilder.append("[" + viewsToAdd[index + innerOffset].mIndex + "," + viewsToAdd[index + innerOffset].mTag + "],");
                }
                stringBuilder.append("\n");
            }
            stringBuilder.append(" ],\n");
        }
        if (tagsToDelete != null) {
            stringBuilder.append("  tagsToDelete(" + tagsToDelete.length + "): [\n");
            for (index = 0; index < tagsToDelete.length; index += 16) {
                for (innerOffset = 0; index + innerOffset < tagsToDelete.length && innerOffset < 16; ++innerOffset) {
                    stringBuilder.append(tagsToDelete[index + innerOffset] + ",");
                }
                stringBuilder.append("\n");
            }
            stringBuilder.append(" ]\n");
        }
        return stringBuilder.toString();
    }

    public void manageChildren(int tag, @Nullable int[] indicesToRemove, @Nullable ViewAtIndex[] viewsToAdd, @Nullable int[] tagsToDelete) {
        int i;
        ViewGroup viewToManage = (ViewGroup)this.mTagsToViews.get(tag);
        ViewGroupManager viewManager = (ViewGroupManager)this.resolveViewManager(tag);
        if (viewToManage == null) {
            throw new IllegalViewOperationException("Trying to manageChildren view with tag " + tag + " which doesn't exist\n detail: " + NativeViewHierarchyManager.constructManageChildrenErrorMessage(viewToManage, viewManager, indicesToRemove, viewsToAdd, tagsToDelete));
        }
        int lastIndexToRemove = viewManager.getChildCount(viewToManage);
        if (indicesToRemove != null) {
            for (i = indicesToRemove.length - 1; i >= 0; --i) {
                int indexToRemove = indicesToRemove[i];
                if (indexToRemove < 0) {
                    throw new IllegalViewOperationException("Trying to remove a negative view index:" + indexToRemove + " view tag: " + tag + "\n detail: " + NativeViewHierarchyManager.constructManageChildrenErrorMessage(viewToManage, viewManager, indicesToRemove, viewsToAdd, tagsToDelete));
                }
                if (indexToRemove >= viewManager.getChildCount(viewToManage)) {
                    throw new IllegalViewOperationException("Trying to remove a view index above child count " + indexToRemove + " view tag: " + tag + "\n detail: " + NativeViewHierarchyManager.constructManageChildrenErrorMessage(viewToManage, viewManager, indicesToRemove, viewsToAdd, tagsToDelete));
                }
                if (indexToRemove >= lastIndexToRemove) {
                    throw new IllegalViewOperationException("Trying to remove an out of order view index:" + indexToRemove + " view tag: " + tag + "\n detail: " + NativeViewHierarchyManager.constructManageChildrenErrorMessage(viewToManage, viewManager, indicesToRemove, viewsToAdd, tagsToDelete));
                }
                viewManager.removeViewAt(viewToManage, indicesToRemove[i]);
                lastIndexToRemove = indexToRemove;
            }
        }
        if (viewsToAdd != null) {
            for (i = 0; i < viewsToAdd.length; ++i) {
                ViewAtIndex viewAtIndex = viewsToAdd[i];
                View viewToAdd = (View)this.mTagsToViews.get(viewAtIndex.mTag);
                if (viewToAdd == null) {
                    throw new IllegalViewOperationException("Trying to add unknown view tag: " + viewAtIndex.mTag + "\n detail: " + NativeViewHierarchyManager.constructManageChildrenErrorMessage(viewToManage, viewManager, indicesToRemove, viewsToAdd, tagsToDelete));
                }
                viewManager.addView(viewToManage, viewToAdd, viewAtIndex.mIndex);
            }
        }
        if (tagsToDelete != null) {
            for (i = 0; i < tagsToDelete.length; ++i) {
                int tagToDelete = tagsToDelete[i];
                View viewToDestroy = (View)this.mTagsToViews.get(tagToDelete);
                if (viewToDestroy == null) {
                    throw new IllegalViewOperationException("Trying to destroy unknown view tag: " + tagToDelete + "\n detail: " + NativeViewHierarchyManager.constructManageChildrenErrorMessage(viewToManage, viewManager, indicesToRemove, viewsToAdd, tagsToDelete));
                }
                this.dropView(viewToDestroy);
            }
        }
    }

    public void addRootView(int tag, SizeMonitoringFrameLayout view, ThemedReactContext themedContext) {
        this.addRootViewGroup(tag, (ViewGroup)view, themedContext);
    }

    protected final void addRootViewGroup(int tag, ViewGroup view, ThemedReactContext themedContext) {
        UiThreadUtil.assertOnUiThread();
        if (view.getId() != -1) {
            throw new IllegalViewOperationException("Trying to add a root view with an explicit id already set. React Native uses the id field to track react tags and will overwrite this field. If that is fine, explicitly overwrite the id field to View.NO_ID before calling addMeasuredRootView.");
        }
        this.mTagsToViews.put(tag, (Object)view);
        this.mTagsToViewManagers.put(tag, (Object)this.mRootViewManager);
        this.mRootTags.put(tag, true);
        view.setId(tag);
    }

    protected final void dropView(View view) {
        UiThreadUtil.assertOnUiThread();
        if (!this.mRootTags.get(view.getId())) {
            this.resolveViewManager(view.getId()).onDropViewInstance((ThemedReactContext)view.getContext(), view);
        }
        ViewManager viewManager = (ViewManager)this.mTagsToViewManagers.get(view.getId());
        if (view instanceof ViewGroup && viewManager instanceof ViewGroupManager) {
            ViewGroup viewGroup = (ViewGroup)view;
            ViewGroupManager viewGroupManager = (ViewGroupManager)viewManager;
            for (int i = viewGroupManager.getChildCount(viewGroup) - 1; i >= 0; --i) {
                View child = viewGroupManager.getChildAt(viewGroup, i);
                if (this.mTagsToViews.get(child.getId()) == null) continue;
                this.dropView(child);
            }
            viewGroupManager.removeAllViews(viewGroup);
        }
        this.mTagsToViews.remove(view.getId());
        this.mTagsToViewManagers.remove(view.getId());
    }

    public void removeRootView(int rootViewTag) {
        UiThreadUtil.assertOnUiThread();
        if (!this.mRootTags.get(rootViewTag)) {
            SoftAssertions.assertUnreachable("View with tag " + rootViewTag + " is not registered as a root view");
        }
        View rootView = (View)this.mTagsToViews.get(rootViewTag);
        this.dropView(rootView);
        this.mRootTags.delete(rootViewTag);
    }

    public void measure(int tag, int[] outputBuffer) {
        UiThreadUtil.assertOnUiThread();
        View v = (View)this.mTagsToViews.get(tag);
        if (v == null) {
            throw new NoSuchNativeViewException("No native view for " + tag + " currently exists");
        }
        View rootView = (View)RootViewUtil.getRootView(v);
        if (rootView == null) {
            throw new NoSuchNativeViewException("Native view " + tag + " is no longer on screen");
        }
        rootView.getLocationInWindow(outputBuffer);
        int rootX = outputBuffer[0];
        int rootY = outputBuffer[1];
        v.getLocationInWindow(outputBuffer);
        outputBuffer[0] = outputBuffer[0] - rootX;
        outputBuffer[1] = outputBuffer[1] - rootY;
        outputBuffer[2] = v.getWidth();
        outputBuffer[3] = v.getHeight();
    }

    public int findTargetTagForTouch(int reactTag, float touchX, float touchY) {
        View view = (View)this.mTagsToViews.get(reactTag);
        if (view == null) {
            throw new JSApplicationIllegalArgumentException("Could not find view with tag " + reactTag);
        }
        return TouchTargetHelper.findTargetTagForTouch(touchX, touchY, (ViewGroup)view);
    }

    public void setJSResponder(int reactTag, int initialReactTag, boolean blockNativeResponder) {
        if (!blockNativeResponder) {
            this.mJSResponderHandler.setJSResponder(initialReactTag, null);
            return;
        }
        View view = (View)this.mTagsToViews.get(reactTag);
        if (initialReactTag != reactTag && view instanceof ViewParent) {
            this.mJSResponderHandler.setJSResponder(initialReactTag, (ViewParent)view);
            return;
        }
        if (this.mRootTags.get(reactTag)) {
            SoftAssertions.assertUnreachable("Cannot block native responder on " + reactTag + " that is a root view");
        }
        this.mJSResponderHandler.setJSResponder(initialReactTag, view.getParent());
    }

    public void clearJSResponder() {
        this.mJSResponderHandler.clearJSResponder();
    }

    void configureLayoutAnimation(ReadableMap config) {
        this.mLayoutAnimator.initializeFromConfig(config);
    }

    void clearLayoutAnimation() {
        this.mLayoutAnimator.reset();
    }

    void startAnimationForNativeView(int reactTag, Animation animation, final @Nullable Callback animationCallback) {
        UiThreadUtil.assertOnUiThread();
        View view = (View)this.mTagsToViews.get(reactTag);
        final int animationId = animation.getAnimationID();
        if (view == null) {
            throw new IllegalViewOperationException("View with tag " + reactTag + " not found");
        }
        animation.setAnimationListener(new AnimationListener(){

            @Override
            public void onFinished() {
                Animation removedAnimation = NativeViewHierarchyManager.this.mAnimationRegistry.removeAnimation(animationId);
                Assertions.assertNotNull((Object)removedAnimation, (String)"Animation was already removed somehow!");
                if (animationCallback != null) {
                    animationCallback.invoke(true);
                }
            }

            @Override
            public void onCancel() {
                Animation removedAnimation = NativeViewHierarchyManager.this.mAnimationRegistry.removeAnimation(animationId);
                Assertions.assertNotNull((Object)removedAnimation, (String)"Animation was already removed somehow!");
                if (animationCallback != null) {
                    animationCallback.invoke(false);
                }
            }
        });
        animation.start(view);
    }

    public void dispatchCommand(int reactTag, int commandId, @Nullable ReadableArray args) {
        UiThreadUtil.assertOnUiThread();
        View view = (View)this.mTagsToViews.get(reactTag);
        if (view == null) {
            throw new IllegalViewOperationException("Trying to send command to a non-existing view with tag " + reactTag);
        }
        ViewManager viewManager = this.resolveViewManager(reactTag);
        viewManager.receiveCommand(view, commandId, args);
    }

    public void showPopupMenu(int reactTag, ReadableArray items, Callback success) {
        UiThreadUtil.assertOnUiThread();
        View anchor = (View)this.mTagsToViews.get(reactTag);
        if (anchor == null) {
            throw new JSApplicationIllegalArgumentException("Could not find view with tag " + reactTag);
        }
        PopupMenu popupMenu = new PopupMenu((Context)this.getReactContextForView(reactTag), anchor);
        Menu menu = popupMenu.getMenu();
        for (int i = 0; i < items.size(); ++i) {
            menu.add(0, 0, i, (CharSequence)items.getString(i));
        }
        PopupMenuCallbackHandler handler = new PopupMenuCallbackHandler(success);
        popupMenu.setOnMenuItemClickListener((PopupMenu.OnMenuItemClickListener)handler);
        popupMenu.setOnDismissListener((PopupMenu.OnDismissListener)handler);
        popupMenu.show();
    }

    private ThemedReactContext getReactContextForView(int reactTag) {
        View view = (View)this.mTagsToViews.get(reactTag);
        if (view == null) {
            throw new JSApplicationIllegalArgumentException("Could not find view with tag " + reactTag);
        }
        return (ThemedReactContext)view.getContext();
    }

    public void sendAccessibilityEvent(int tag, int eventType) {
        View view = (View)this.mTagsToViews.get(tag);
        if (view == null) {
            throw new JSApplicationIllegalArgumentException("Could not find view with tag " + tag);
        }
        AccessibilityHelper.sendAccessibilityEvent(view, eventType);
    }

    private static class PopupMenuCallbackHandler
    implements PopupMenu.OnMenuItemClickListener,
    PopupMenu.OnDismissListener {
        final Callback mSuccess;
        boolean mConsumed = false;

        private PopupMenuCallbackHandler(Callback success) {
            this.mSuccess = success;
        }

        public void onDismiss(PopupMenu menu) {
            if (!this.mConsumed) {
                this.mSuccess.invoke("dismissed");
                this.mConsumed = true;
            }
        }

        public boolean onMenuItemClick(MenuItem item) {
            if (!this.mConsumed) {
                this.mSuccess.invoke("itemSelected", item.getOrder());
                this.mConsumed = true;
                return true;
            }
            return false;
        }
    }
}

