/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.content.Context;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.facebook.react.modules.network.ForwardingCookieHandler;
import com.facebook.react.modules.network.OkHttpClientProvider;
import com.facebook.react.modules.network.RequestBodyUtil;
import com.facebook.stetho.okhttp.StethoInterceptor;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.CookieHandler;
import javax.annotation.Nullable;

public final class NetworkingModule
extends ReactContextBaseJavaModule {
    private static final String CONTENT_ENCODING_HEADER_NAME = "content-encoding";
    private static final String CONTENT_TYPE_HEADER_NAME = "content-type";
    private static final String REQUEST_BODY_KEY_STRING = "string";
    private static final String REQUEST_BODY_KEY_URI = "uri";
    private static final String REQUEST_BODY_KEY_FORMDATA = "formData";
    private static final String USER_AGENT_HEADER_NAME = "user-agent";
    private static final int MIN_BUFFER_SIZE = 8192;
    private static final int MAX_BUFFER_SIZE = 524288;
    private static final int CHUNK_TIMEOUT_NS = 100000000;
    private final OkHttpClient mClient;
    private final ForwardingCookieHandler mCookieHandler;
    @Nullable
    private final String mDefaultUserAgent;
    private boolean mShuttingDown;

    NetworkingModule(ReactApplicationContext reactContext, @Nullable String defaultUserAgent, OkHttpClient client) {
        super(reactContext);
        this.mClient = client;
        this.mClient.networkInterceptors().add(new StethoInterceptor());
        this.mCookieHandler = new ForwardingCookieHandler(reactContext);
        this.mShuttingDown = false;
        this.mDefaultUserAgent = defaultUserAgent;
    }

    public NetworkingModule(ReactApplicationContext context) {
        this(context, null, OkHttpClientProvider.getOkHttpClient());
    }

    public NetworkingModule(ReactApplicationContext context, String defaultUserAgent) {
        this(context, defaultUserAgent, OkHttpClientProvider.getOkHttpClient());
    }

    public NetworkingModule(ReactApplicationContext reactContext, OkHttpClient client) {
        this(reactContext, null, client);
    }

    @Override
    public void initialize() {
        this.mClient.setCookieHandler((CookieHandler)this.mCookieHandler);
    }

    @Override
    public String getName() {
        return "RCTNetworking";
    }

    @Override
    public void onCatalystInstanceDestroy() {
        this.mShuttingDown = true;
        this.mClient.cancel(null);
        this.mCookieHandler.destroy();
        this.mClient.setCookieHandler(null);
    }

    @ReactMethod
    public void sendRequest(String method, String url, final int requestId, ReadableArray headers, ReadableMap data, final boolean useIncrementalUpdates) {
        Headers requestHeaders;
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (requestId != 0) {
            requestBuilder.tag((Object)requestId);
        }
        if ((requestHeaders = this.extractHeaders(headers, data)) == null) {
            this.onRequestError(requestId, "Unrecognized headers format");
            return;
        }
        String contentType = requestHeaders.get(CONTENT_TYPE_HEADER_NAME);
        String contentEncoding = requestHeaders.get(CONTENT_ENCODING_HEADER_NAME);
        requestBuilder.headers(requestHeaders);
        if (data == null) {
            requestBuilder.method(method, null);
        } else if (data.hasKey(REQUEST_BODY_KEY_STRING)) {
            if (contentType == null) {
                this.onRequestError(requestId, "Payload is set but no content-type header specified");
                return;
            }
            String body = data.getString(REQUEST_BODY_KEY_STRING);
            MediaType contentMediaType = MediaType.parse((String)contentType);
            if (RequestBodyUtil.isGzipEncoding(contentEncoding)) {
                RequestBody requestBody = RequestBodyUtil.createGzip(contentMediaType, body);
                if (requestBody == null) {
                    this.onRequestError(requestId, "Failed to gzip request body");
                    return;
                }
                requestBuilder.method(method, requestBody);
            } else {
                requestBuilder.method(method, RequestBody.create((MediaType)contentMediaType, (String)body));
            }
        } else if (data.hasKey(REQUEST_BODY_KEY_URI)) {
            if (contentType == null) {
                this.onRequestError(requestId, "Payload is set but no content-type header specified");
                return;
            }
            String uri = data.getString(REQUEST_BODY_KEY_URI);
            InputStream fileInputStream = RequestBodyUtil.getFileInputStream((Context)this.getReactApplicationContext(), uri);
            if (fileInputStream == null) {
                this.onRequestError(requestId, "Could not retrieve file for uri " + uri);
                return;
            }
            requestBuilder.method(method, RequestBodyUtil.create(MediaType.parse((String)contentType), fileInputStream));
        } else if (data.hasKey(REQUEST_BODY_KEY_FORMDATA)) {
            ReadableArray parts;
            MultipartBuilder multipartBuilder;
            if (contentType == null) {
                contentType = "multipart/form-data";
            }
            if ((multipartBuilder = this.constructMultipartBody(parts = data.getArray(REQUEST_BODY_KEY_FORMDATA), contentType, requestId)) == null) {
                return;
            }
            requestBuilder.method(method, multipartBuilder.build());
        } else {
            requestBuilder.method(method, null);
        }
        this.mClient.newCall(requestBuilder.build()).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                if (NetworkingModule.this.mShuttingDown) {
                    return;
                }
                NetworkingModule.this.onRequestError(requestId, e.getMessage());
            }

            public void onResponse(Response response) throws IOException {
                if (NetworkingModule.this.mShuttingDown) {
                    return;
                }
                NetworkingModule.this.onResponseReceived(requestId, response);
                ResponseBody responseBody = response.body();
                try {
                    if (useIncrementalUpdates) {
                        NetworkingModule.this.readWithProgress(requestId, responseBody);
                        NetworkingModule.this.onRequestSuccess(requestId);
                    } else {
                        NetworkingModule.this.onDataReceived(requestId, responseBody.string());
                        NetworkingModule.this.onRequestSuccess(requestId);
                    }
                }
                catch (IOException e) {
                    NetworkingModule.this.onRequestError(requestId, e.getMessage());
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readWithProgress(int requestId, ResponseBody responseBody) throws IOException {
        try (Reader reader = responseBody.charStream();){
            int read;
            StringBuilder sb = new StringBuilder(NetworkingModule.getBufferSize(responseBody));
            char[] buffer = new char[8192];
            long last = System.nanoTime();
            while ((read = reader.read(buffer)) != -1) {
                sb.append(buffer, 0, read);
                long now = System.nanoTime();
                if (!NetworkingModule.shouldDispatch(now, last)) continue;
                this.onDataReceived(requestId, sb.toString());
                sb.setLength(0);
                last = now;
            }
            if (sb.length() > 0) {
                this.onDataReceived(requestId, sb.toString());
            }
        }
    }

    private static boolean shouldDispatch(long now, long last) {
        return last + 100000000L < now;
    }

    private static int getBufferSize(ResponseBody responseBody) throws IOException {
        long length = responseBody.contentLength();
        if (length == -1L) {
            return 8192;
        }
        return (int)Math.min(length, 524288L);
    }

    private void onDataReceived(int requestId, String data) {
        WritableArray args = Arguments.createArray();
        args.pushInt(requestId);
        args.pushString(data);
        this.getEventEmitter().emit("didReceiveNetworkData", args);
    }

    private void onRequestError(int requestId, String error) {
        WritableArray args = Arguments.createArray();
        args.pushInt(requestId);
        args.pushString(error);
        this.getEventEmitter().emit("didCompleteNetworkResponse", args);
    }

    private void onRequestSuccess(int requestId) {
        WritableArray args = Arguments.createArray();
        args.pushInt(requestId);
        args.pushNull();
        this.getEventEmitter().emit("didCompleteNetworkResponse", args);
    }

    private void onResponseReceived(int requestId, Response response) {
        WritableMap headers = NetworkingModule.translateHeaders(response.headers());
        WritableArray args = Arguments.createArray();
        args.pushInt(requestId);
        args.pushInt(response.code());
        args.pushMap(headers);
        this.getEventEmitter().emit("didReceiveNetworkResponse", args);
    }

    private static WritableMap translateHeaders(Headers headers) {
        WritableMap responseHeaders = Arguments.createMap();
        for (int i = 0; i < headers.size(); ++i) {
            String headerName = headers.name(i);
            if (responseHeaders.hasKey(headerName)) {
                responseHeaders.putString(headerName, responseHeaders.getString(headerName) + ", " + headers.value(i));
                continue;
            }
            responseHeaders.putString(headerName, headers.value(i));
        }
        return responseHeaders;
    }

    @ReactMethod
    public void abortRequest(final int requestId) {
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            protected void doInBackgroundGuarded(Void ... params) {
                NetworkingModule.this.mClient.cancel((Object)requestId);
            }
        }.execute(new Void[0]);
    }

    @ReactMethod
    public void clearCookies(com.facebook.react.bridge.Callback callback) {
        this.mCookieHandler.clearCookies(callback);
    }

    @Nullable
    private MultipartBuilder constructMultipartBody(ReadableArray body, String contentType, int requestId) {
        MultipartBuilder multipartBuilder = new MultipartBuilder();
        multipartBuilder.type(MediaType.parse((String)contentType));
        int size = body.size();
        for (int i = 0; i < size; ++i) {
            ReadableMap bodyPart = body.getMap(i);
            ReadableArray headersArray = bodyPart.getArray("headers");
            Headers headers = this.extractHeaders(headersArray, null);
            if (headers == null) {
                this.onRequestError(requestId, "Missing or invalid header format for FormData part.");
                return null;
            }
            MediaType partContentType = null;
            String partContentTypeStr = headers.get(CONTENT_TYPE_HEADER_NAME);
            if (partContentTypeStr != null) {
                partContentType = MediaType.parse((String)partContentTypeStr);
                headers = headers.newBuilder().removeAll(CONTENT_TYPE_HEADER_NAME).build();
            }
            if (bodyPart.hasKey(REQUEST_BODY_KEY_STRING)) {
                String bodyValue = bodyPart.getString(REQUEST_BODY_KEY_STRING);
                multipartBuilder.addPart(headers, RequestBody.create((MediaType)partContentType, (String)bodyValue));
                continue;
            }
            if (bodyPart.hasKey(REQUEST_BODY_KEY_URI)) {
                if (partContentType == null) {
                    this.onRequestError(requestId, "Binary FormData part needs a content-type header.");
                    return null;
                }
                String fileContentUriStr = bodyPart.getString(REQUEST_BODY_KEY_URI);
                InputStream fileInputStream = RequestBodyUtil.getFileInputStream((Context)this.getReactApplicationContext(), fileContentUriStr);
                if (fileInputStream == null) {
                    this.onRequestError(requestId, "Could not retrieve file for uri " + fileContentUriStr);
                    return null;
                }
                multipartBuilder.addPart(headers, RequestBodyUtil.create(partContentType, fileInputStream));
                continue;
            }
            this.onRequestError(requestId, "Unrecognized FormData part.");
        }
        return multipartBuilder;
    }

    @Nullable
    private Headers extractHeaders(@Nullable ReadableArray headersArray, @Nullable ReadableMap requestData) {
        boolean isGzipSupported;
        if (headersArray == null) {
            return null;
        }
        Headers.Builder headersBuilder = new Headers.Builder();
        int size = headersArray.size();
        for (int headersIdx = 0; headersIdx < size; ++headersIdx) {
            ReadableArray header = headersArray.getArray(headersIdx);
            if (header == null || header.size() != 2) {
                return null;
            }
            String headerName = header.getString(0);
            String headerValue = header.getString(1);
            headersBuilder.add(headerName, headerValue);
        }
        if (headersBuilder.get(USER_AGENT_HEADER_NAME) == null && this.mDefaultUserAgent != null) {
            headersBuilder.add(USER_AGENT_HEADER_NAME, this.mDefaultUserAgent);
        }
        boolean bl = isGzipSupported = requestData != null && requestData.hasKey(REQUEST_BODY_KEY_STRING);
        if (!isGzipSupported) {
            headersBuilder.removeAll(CONTENT_ENCODING_HEADER_NAME);
        }
        return headersBuilder.build();
    }

    private DeviceEventManagerModule.RCTDeviceEventEmitter getEventEmitter() {
        return this.getReactApplicationContext().getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class);
    }
}

