/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.viewpager;

import android.view.View;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.ReactProp;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.views.viewpager.ReactViewPager;
import java.util.Map;

public class ReactViewPagerManager
extends ViewGroupManager<ReactViewPager> {
    private static final String REACT_CLASS = "AndroidViewPager";

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    protected ReactViewPager createViewInstance(ThemedReactContext reactContext) {
        return new ReactViewPager(reactContext);
    }

    @ReactProp(name="selectedPage")
    public void setSelectedPage(ReactViewPager view, int page) {
        view.setCurrentItemFromJs(page);
    }

    @Override
    public boolean needsCustomLayoutForChildren() {
        return true;
    }

    @Override
    public Map getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.of("topPageScroll", MapBuilder.of("registrationName", "onPageScroll"), "topPageSelected", MapBuilder.of("registrationName", "onPageSelected"));
    }

    @Override
    public void addView(ReactViewPager parent, View child, int index) {
        parent.addViewToAdapter(child, index);
    }

    @Override
    public int getChildCount(ReactViewPager parent) {
        return parent.getViewCountInAdapter();
    }

    @Override
    public View getChildAt(ReactViewPager parent, int index) {
        return parent.getViewFromAdapter(index);
    }

    @Override
    public void removeViewAt(ReactViewPager parent, int index) {
        parent.removeViewFromAdapter(index);
    }
}

