/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactCompoundView;
import com.facebook.react.uimanager.ReactPointerEventsView;
import javax.annotation.Nullable;

public class TouchTargetHelper {
    private static final float[] mEventCoords = new float[2];

    public static int findTargetTagForTouch(float eventY, float eventX, ViewGroup viewGroup) {
        View reactTargetView;
        UiThreadUtil.assertOnUiThread();
        int targetTag = viewGroup.getId();
        float[] eventCoords = mEventCoords;
        eventCoords[0] = eventY;
        eventCoords[1] = eventX;
        View nativeTargetView = TouchTargetHelper.findTouchTargetView(eventCoords, viewGroup);
        if (nativeTargetView != null && (reactTargetView = TouchTargetHelper.findClosestReactAncestor(nativeTargetView)) != null) {
            targetTag = TouchTargetHelper.getTouchTargetForView(reactTargetView, eventCoords[0], eventCoords[1]);
        }
        return targetTag;
    }

    private static View findClosestReactAncestor(View view) {
        while (view != null && view.getId() <= 0) {
            view = (View)view.getParent();
        }
        return view;
    }

    private static View findTouchTargetView(float[] eventCoords, ViewGroup viewGroup) {
        int childrenCount = viewGroup.getChildCount();
        for (int i = childrenCount - 1; i >= 0; --i) {
            View child = viewGroup.getChildAt(i);
            if (!TouchTargetHelper.isTouchPointInView(eventCoords[0], eventCoords[1], viewGroup, child)) continue;
            eventCoords[0] = eventCoords[0] + (float)(viewGroup.getScrollY() - child.getTop());
            eventCoords[1] = eventCoords[1] + (float)(viewGroup.getScrollX() - child.getLeft());
            View targetView = TouchTargetHelper.findTouchTargetViewWithPointerEvents(eventCoords, child);
            if (targetView != null) {
                return targetView;
            }
            eventCoords[0] = eventCoords[0] - (float)(viewGroup.getScrollY() - child.getTop());
            eventCoords[1] = eventCoords[1] - (float)(viewGroup.getScrollX() - child.getLeft());
        }
        return viewGroup;
    }

    private static boolean isTouchPointInView(float y, float x, ViewGroup parent, View child) {
        float localY = y + (float)parent.getScrollY() - (float)child.getTop();
        float localX = x + (float)parent.getScrollX() - (float)child.getLeft();
        return localY >= 0.0f && localY < (float)(child.getBottom() - child.getTop()) && localX >= 0.0f && localX < (float)(child.getRight() - child.getLeft());
    }

    @Nullable
    private static View findTouchTargetViewWithPointerEvents(float[] eventCoords, View view) {
        PointerEvents pointerEvents;
        PointerEvents pointerEvents2 = pointerEvents = view instanceof ReactPointerEventsView ? ((ReactPointerEventsView)view).getPointerEvents() : PointerEvents.AUTO;
        if (pointerEvents == PointerEvents.NONE) {
            return null;
        }
        if (pointerEvents == PointerEvents.BOX_ONLY) {
            return view;
        }
        if (pointerEvents == PointerEvents.BOX_NONE) {
            if (view instanceof ViewGroup) {
                View targetView = TouchTargetHelper.findTouchTargetView(eventCoords, (ViewGroup)view);
                return targetView != view ? targetView : null;
            }
            return null;
        }
        if (pointerEvents == PointerEvents.AUTO) {
            if (view instanceof ViewGroup) {
                return TouchTargetHelper.findTouchTargetView(eventCoords, (ViewGroup)view);
            }
            return view;
        }
        throw new JSApplicationIllegalArgumentException("Unknown pointer event type: " + pointerEvents.toString());
    }

    private static int getTouchTargetForView(View targetView, float eventY, float eventX) {
        if (targetView instanceof ReactCompoundView) {
            return ((ReactCompoundView)targetView).reactTagForTouch(eventX, eventY);
        }
        return targetView.getId();
    }
}

