/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.AlertDialog;
import android.app.ProgressDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.hardware.SensorManager;
import android.os.Debug;
import android.os.Environment;
import android.widget.Toast;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.R;
import com.facebook.react.bridge.NativeModuleCallExceptionHandler;
import com.facebook.react.bridge.ProxyJavaScriptExecutor;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WebsocketJavaScriptExecutor;
import com.facebook.react.common.ShakeDetector;
import com.facebook.react.devsupport.DebugOverlayController;
import com.facebook.react.devsupport.DebugServerException;
import com.facebook.react.devsupport.DevInternalSettings;
import com.facebook.react.devsupport.DevOptionHandler;
import com.facebook.react.devsupport.DevServerHelper;
import com.facebook.react.devsupport.DevSettingsActivity;
import com.facebook.react.devsupport.ReactInstanceDevCommandsHandler;
import com.facebook.react.devsupport.RedBoxDialog;
import com.facebook.react.devsupport.StackTraceHelper;
import com.facebook.react.modules.debug.DeveloperSettings;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Locale;
import javax.annotation.Nullable;

public class DevSupportManager
implements NativeModuleCallExceptionHandler {
    private static final int JAVA_ERROR_COOKIE = -1;
    private static final String JS_BUNDLE_FILE_NAME = "ReactNativeDevBundle.js";
    private static final String EXOPACKAGE_LOCATION_FORMAT = "/data/local/tmp/exopackage/%s//secondary-dex";
    private static final int JAVA_SAMPLING_PROFILE_MEMORY_BYTES = 0x800000;
    private static final int JAVA_SAMPLING_PROFILE_DELTA_US = 100;
    private final Context mApplicationContext;
    private final ShakeDetector mShakeDetector;
    private final BroadcastReceiver mReloadAppBroadcastReceiver;
    private final DevServerHelper mDevServerHelper;
    private final LinkedHashMap<String, DevOptionHandler> mCustomDevOptions = new LinkedHashMap();
    private final ReactInstanceDevCommandsHandler mReactInstanceCommandsHandler;
    @Nullable
    private final String mJSAppBundleName;
    private final File mJSBundleTempFile;
    @Nullable
    private RedBoxDialog mRedBoxDialog;
    @Nullable
    private AlertDialog mDevOptionsDialog;
    @Nullable
    private DebugOverlayController mDebugOverlayController;
    @Nullable
    private ReactContext mCurrentContext;
    private DevInternalSettings mDevSettings;
    private boolean mIsUsingJSProxy = false;
    private boolean mIsReceiverRegistered = false;
    private boolean mIsShakeDetectorStarted = false;
    private boolean mIsDevSupportEnabled = false;
    private boolean mIsCurrentlyProfiling = false;
    private int mProfileIndex = 0;

    public DevSupportManager(Context applicationContext, ReactInstanceDevCommandsHandler reactInstanceCommandsHandler, @Nullable String packagerPathForJSBundleName, boolean enableOnCreate) {
        this.mReactInstanceCommandsHandler = reactInstanceCommandsHandler;
        this.mApplicationContext = applicationContext;
        this.mJSAppBundleName = packagerPathForJSBundleName;
        this.mDevSettings = new DevInternalSettings(applicationContext, this);
        this.mDevServerHelper = new DevServerHelper(this.mDevSettings);
        this.mShakeDetector = new ShakeDetector(new ShakeDetector.ShakeListener(){

            @Override
            public void onShake() {
                DevSupportManager.this.showDevOptionsDialog();
            }
        });
        this.mReloadAppBroadcastReceiver = new BroadcastReceiver(){

            public void onReceive(Context context, Intent intent) {
                String action = intent.getAction();
                if (DevServerHelper.getReloadAppAction(context).equals(action)) {
                    if (intent.getBooleanExtra("jsproxy", false)) {
                        DevSupportManager.this.mIsUsingJSProxy = true;
                        DevSupportManager.this.mDevServerHelper.launchChromeDevtools();
                    } else {
                        DevSupportManager.this.mIsUsingJSProxy = false;
                    }
                    DevSupportManager.this.handleReloadJS();
                }
            }
        };
        this.mJSBundleTempFile = new File(applicationContext.getFilesDir(), JS_BUNDLE_FILE_NAME);
        this.setDevSupportEnabled(enableOnCreate);
    }

    @Override
    public void handleException(Exception e) {
        if (!this.mIsDevSupportEnabled) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        FLog.e((String)"React", (String)"Exception in native call from JS", (Throwable)e);
        this.showNewError(e.getMessage(), StackTraceHelper.convertJavaStackTrace(e), -1);
    }

    public void addCustomDevOption(String optionName, DevOptionHandler optionHandler) {
        this.mCustomDevOptions.put(optionName, optionHandler);
    }

    public void showNewJSError(String message, ReadableArray details, int errorCookie) {
        this.showNewError(message, StackTraceHelper.convertJsStackTrace(details), errorCookie);
    }

    public void updateJSError(final String message, final ReadableArray details, final int errorCookie) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (DevSupportManager.this.mRedBoxDialog == null || !DevSupportManager.this.mRedBoxDialog.isShowing() || errorCookie != DevSupportManager.this.mRedBoxDialog.getErrorCookie()) {
                    return;
                }
                DevSupportManager.this.mRedBoxDialog.setExceptionDetails(message, StackTraceHelper.convertJsStackTrace(details));
                DevSupportManager.this.mRedBoxDialog.show();
            }
        });
    }

    private void showNewError(final String message, final StackTraceHelper.StackFrame[] stack, final int errorCookie) {
        UiThreadUtil.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                if (DevSupportManager.this.mRedBoxDialog == null) {
                    DevSupportManager.this.mRedBoxDialog = new RedBoxDialog(DevSupportManager.this.mApplicationContext, DevSupportManager.this);
                    DevSupportManager.this.mRedBoxDialog.getWindow().setType(2003);
                }
                if (DevSupportManager.this.mRedBoxDialog.isShowing()) {
                    return;
                }
                DevSupportManager.this.mRedBoxDialog.setExceptionDetails(message, stack);
                DevSupportManager.this.mRedBoxDialog.setErrorCookie(errorCookie);
                DevSupportManager.this.mRedBoxDialog.show();
            }
        });
    }

    public void showDevOptionsDialog() {
        if (this.mDevOptionsDialog != null || !this.mIsDevSupportEnabled) {
            return;
        }
        LinkedHashMap<String, DevOptionHandler> options = new LinkedHashMap<String, DevOptionHandler>();
        options.put(this.mApplicationContext.getString(R.string.catalyst_reloadjs), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                DevSupportManager.this.handleReloadJS();
            }
        });
        options.put(this.mIsUsingJSProxy ? this.mApplicationContext.getString(R.string.catalyst_debugjs_off) : this.mApplicationContext.getString(R.string.catalyst_debugjs), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                DevSupportManager.this.mIsUsingJSProxy = !DevSupportManager.this.mIsUsingJSProxy;
                DevSupportManager.this.handleReloadJS();
            }
        });
        options.put(this.mApplicationContext.getString(R.string.catalyst_settings), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                Intent intent = new Intent(DevSupportManager.this.mApplicationContext, DevSettingsActivity.class);
                intent.setFlags(0x10000000);
                DevSupportManager.this.mApplicationContext.startActivity(intent);
            }
        });
        options.put(this.mApplicationContext.getString(R.string.catalyst_inspect_element), new DevOptionHandler(){

            @Override
            public void onOptionSelected() {
                DevSupportManager.this.mReactInstanceCommandsHandler.toggleElementInspector();
            }
        });
        if (this.mCurrentContext != null && this.mCurrentContext.getCatalystInstance() != null && !this.mCurrentContext.getCatalystInstance().isDestroyed() && this.mCurrentContext.getCatalystInstance().getBridge() != null && this.mCurrentContext.getCatalystInstance().getBridge().supportsProfiling()) {
            options.put(this.mApplicationContext.getString(this.mIsCurrentlyProfiling ? R.string.catalyst_stop_profile : R.string.catalyst_start_profile), new DevOptionHandler(){

                @Override
                public void onOptionSelected() {
                    if (DevSupportManager.this.mCurrentContext != null && DevSupportManager.this.mCurrentContext.hasActiveCatalystInstance()) {
                        String profileName = Environment.getExternalStorageDirectory().getPath() + "/profile_" + DevSupportManager.this.mProfileIndex + ".json";
                        if (DevSupportManager.this.mIsCurrentlyProfiling) {
                            DevSupportManager.this.mIsCurrentlyProfiling = false;
                            DevSupportManager.this.mProfileIndex++;
                            Debug.stopMethodTracing();
                            DevSupportManager.this.mCurrentContext.getCatalystInstance().getBridge().stopProfiler("profile", profileName);
                            Toast.makeText((Context)DevSupportManager.this.mCurrentContext, (CharSequence)("Profile output to " + profileName), (int)1).show();
                        } else {
                            DevSupportManager.this.mIsCurrentlyProfiling = true;
                            DevSupportManager.this.mCurrentContext.getCatalystInstance().getBridge().startProfiler("profile");
                            Debug.startMethodTracingSampling((String)profileName, (int)0x800000, (int)100);
                        }
                    }
                }
            });
        }
        if (this.mCustomDevOptions.size() > 0) {
            options.putAll(this.mCustomDevOptions);
        }
        final DevOptionHandler[] optionHandlers = options.values().toArray(new DevOptionHandler[0]);
        this.mDevOptionsDialog = new AlertDialog.Builder(this.mApplicationContext).setItems((CharSequence[])options.keySet().toArray(new String[0]), new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                optionHandlers[which].onOptionSelected();
                DevSupportManager.this.mDevOptionsDialog = null;
            }
        }).setOnCancelListener(new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                DevSupportManager.this.mDevOptionsDialog = null;
            }
        }).create();
        this.mDevOptionsDialog.getWindow().setType(2003);
        this.mDevOptionsDialog.show();
    }

    public void setDevSupportEnabled(boolean isDevSupportEnabled) {
        this.mIsDevSupportEnabled = isDevSupportEnabled;
        this.reload();
    }

    public boolean getDevSupportEnabled() {
        return this.mIsDevSupportEnabled;
    }

    public DeveloperSettings getDevSettings() {
        return this.mDevSettings;
    }

    public void onNewReactContextCreated(ReactContext reactContext) {
        this.resetCurrentContext(reactContext);
    }

    public void onReactInstanceDestroyed(ReactContext reactContext) {
        if (reactContext == this.mCurrentContext) {
            this.resetCurrentContext(null);
        }
    }

    public String getSourceMapUrl() {
        if (this.mJSAppBundleName == null) {
            return "";
        }
        return this.mDevServerHelper.getSourceMapUrl((String)Assertions.assertNotNull((Object)this.mJSAppBundleName));
    }

    public String getSourceUrl() {
        if (this.mJSAppBundleName == null) {
            return "";
        }
        return this.mDevServerHelper.getSourceUrl((String)Assertions.assertNotNull((Object)this.mJSAppBundleName));
    }

    public String getJSBundleURLForRemoteDebugging() {
        return this.mDevServerHelper.getJSBundleURLForRemoteDebugging((String)Assertions.assertNotNull((Object)this.mJSAppBundleName));
    }

    public String getDownloadedJSBundleFile() {
        return this.mJSBundleTempFile.getAbsolutePath();
    }

    public boolean hasUpToDateJSBundleInCache() {
        if (this.mIsDevSupportEnabled && this.mJSBundleTempFile.exists()) {
            try {
                String packageName = this.mApplicationContext.getPackageName();
                PackageInfo thisPackage = this.mApplicationContext.getPackageManager().getPackageInfo(packageName, 0);
                if (this.mJSBundleTempFile.lastModified() > thisPackage.lastUpdateTime) {
                    File exopackageDir = new File(String.format(Locale.US, EXOPACKAGE_LOCATION_FORMAT, packageName));
                    if (exopackageDir.exists()) {
                        return this.mJSBundleTempFile.lastModified() > exopackageDir.lastModified();
                    }
                    return true;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                FLog.e((String)"React", (String)"DevSupport is unable to get current app info");
            }
        }
        return false;
    }

    public boolean hasBundleInAssets(String bundleAssetName) {
        try {
            String[] assets = this.mApplicationContext.getAssets().list("");
            for (int i = 0; i < assets.length; ++i) {
                if (!assets[i].equals(bundleAssetName)) continue;
                return true;
            }
        }
        catch (IOException e) {
            FLog.e((String)"React", (String)"Error while loading assets list");
        }
        return false;
    }

    private void resetCurrentContext(@Nullable ReactContext reactContext) {
        if (this.mCurrentContext == reactContext) {
            return;
        }
        if (this.mIsCurrentlyProfiling) {
            this.mIsCurrentlyProfiling = false;
            String profileName = Environment.getExternalStorageDirectory().getPath() + "/profile_" + this.mProfileIndex + ".json";
            ++this.mProfileIndex;
            Debug.stopMethodTracing();
            this.mCurrentContext.getCatalystInstance().getBridge().stopProfiler("profile", profileName);
        }
        this.mCurrentContext = reactContext;
        if (this.mDebugOverlayController != null) {
            this.mDebugOverlayController.setFpsDebugViewVisible(false);
        }
        if (reactContext != null) {
            this.mDebugOverlayController = new DebugOverlayController(reactContext);
        }
        this.reloadSettings();
    }

    void reloadSettings() {
        this.reload();
    }

    public void handleReloadJS() {
        UiThreadUtil.assertOnUiThread();
        if (this.mRedBoxDialog != null) {
            this.mRedBoxDialog.dismiss();
        }
        ProgressDialog progressDialog = new ProgressDialog(this.mApplicationContext);
        progressDialog.setTitle(R.string.catalyst_jsload_title);
        progressDialog.setMessage((CharSequence)this.mApplicationContext.getString(this.mIsUsingJSProxy ? R.string.catalyst_remotedbg_message : R.string.catalyst_jsload_message));
        progressDialog.setIndeterminate(true);
        progressDialog.setCancelable(false);
        progressDialog.getWindow().setType(2003);
        progressDialog.show();
        if (this.mIsUsingJSProxy) {
            this.reloadJSInProxyMode(progressDialog);
        } else {
            this.reloadJSFromServer(progressDialog);
        }
    }

    public void isPackagerRunning(DevServerHelper.PackagerStatusCallback callback) {
        this.mDevServerHelper.isPackagerRunning(callback);
    }

    private void reloadJSInProxyMode(final ProgressDialog progressDialog) {
        this.mDevServerHelper.launchChromeDevtools();
        final WebsocketJavaScriptExecutor webSocketJSExecutor = new WebsocketJavaScriptExecutor();
        webSocketJSExecutor.connect(this.mDevServerHelper.getWebsocketProxyURL(), new WebsocketJavaScriptExecutor.JSExecutorConnectCallback(){

            @Override
            public void onSuccess() {
                progressDialog.dismiss();
                UiThreadUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        DevSupportManager.this.mReactInstanceCommandsHandler.onReloadWithJSDebugger(new ProxyJavaScriptExecutor(webSocketJSExecutor));
                    }
                });
            }

            @Override
            public void onFailure(final Throwable cause) {
                progressDialog.dismiss();
                FLog.e((String)"React", (String)"Unable to connect to remote debugger", (Throwable)cause);
                UiThreadUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        DevSupportManager.this.showNewError(DevSupportManager.this.mApplicationContext.getString(R.string.catalyst_remotedbg_error), StackTraceHelper.convertJavaStackTrace(cause), -1);
                    }
                });
            }
        });
    }

    private void reloadJSFromServer(final ProgressDialog progressDialog) {
        this.mDevServerHelper.downloadBundleFromURL(new DevServerHelper.BundleDownloadCallback(){

            @Override
            public void onSuccess() {
                progressDialog.dismiss();
                UiThreadUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        DevSupportManager.this.mReactInstanceCommandsHandler.onJSBundleLoadedFromServer();
                    }
                });
            }

            @Override
            public void onFailure(final Exception cause) {
                progressDialog.dismiss();
                FLog.e((String)"React", (String)"Unable to download JS bundle", (Throwable)cause);
                UiThreadUtil.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (cause instanceof DebugServerException) {
                            DebugServerException debugServerException = (DebugServerException)cause;
                            DevSupportManager.this.showNewError(debugServerException.description, StackTraceHelper.convertJavaStackTrace(cause), -1);
                        } else {
                            DevSupportManager.this.showNewError(DevSupportManager.this.mApplicationContext.getString(R.string.catalyst_jsload_error), StackTraceHelper.convertJavaStackTrace(cause), -1);
                        }
                    }
                });
            }
        }, (String)Assertions.assertNotNull((Object)this.mJSAppBundleName), this.mJSBundleTempFile);
    }

    private void reload() {
        if (this.mIsDevSupportEnabled) {
            if (this.mDebugOverlayController != null) {
                this.mDebugOverlayController.setFpsDebugViewVisible(this.mDevSettings.isFpsDebugEnabled());
            }
            if (!this.mIsShakeDetectorStarted) {
                this.mShakeDetector.start((SensorManager)this.mApplicationContext.getSystemService("sensor"));
                this.mIsShakeDetectorStarted = true;
            }
            if (!this.mIsReceiverRegistered) {
                IntentFilter filter = new IntentFilter();
                filter.addAction(DevServerHelper.getReloadAppAction(this.mApplicationContext));
                this.mApplicationContext.registerReceiver(this.mReloadAppBroadcastReceiver, filter);
                this.mIsReceiverRegistered = true;
            }
            if (this.mDevSettings.isReloadOnJSChangeEnabled()) {
                this.mDevServerHelper.startPollingOnChangeEndpoint(new DevServerHelper.OnServerContentChangeListener(){

                    @Override
                    public void onServerContentChanged() {
                        DevSupportManager.this.handleReloadJS();
                    }
                });
            } else {
                this.mDevServerHelper.stopPollingOnChangeEndpoint();
            }
        } else {
            if (this.mDebugOverlayController != null) {
                this.mDebugOverlayController.setFpsDebugViewVisible(false);
            }
            if (this.mIsShakeDetectorStarted) {
                this.mShakeDetector.stop();
                this.mIsShakeDetectorStarted = false;
            }
            if (this.mIsReceiverRegistered) {
                this.mApplicationContext.unregisterReceiver(this.mReloadAppBroadcastReceiver);
                this.mIsReceiverRegistered = false;
            }
            if (this.mRedBoxDialog != null) {
                this.mRedBoxDialog.dismiss();
            }
            if (this.mDevOptionsDialog != null) {
                this.mDevOptionsDialog.dismiss();
            }
            this.mDevServerHelper.stopPollingOnChangeEndpoint();
        }
    }
}

