/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.text;

import android.content.Context;
import android.text.Spanned;
import android.text.TextUtils;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.BaseViewManager;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactProp;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.views.text.ReactTextShadowNode;
import com.facebook.react.views.text.ReactTextView;
import javax.annotation.Nullable;

public class ReactTextViewManager
extends BaseViewManager<ReactTextView, ReactTextShadowNode> {
    @VisibleForTesting
    public static final String REACT_CLASS = "RCTText";

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactTextView createViewInstance(ThemedReactContext context) {
        return new ReactTextView((Context)context);
    }

    @ReactProp(name="numberOfLines", defaultInt=0x7FFFFFFF)
    public void setNumberOfLines(ReactTextView view, int numberOfLines) {
        view.setMaxLines(numberOfLines);
        view.setEllipsize(TextUtils.TruncateAt.END);
    }

    @ReactProp(name="textAlign")
    public void setTextAlign(ReactTextView view, @Nullable String textAlign) {
        if (textAlign == null || "auto".equals(textAlign)) {
            view.setGravity(0);
        } else if ("left".equals(textAlign)) {
            view.setGravity(3);
        } else if ("right".equals(textAlign)) {
            view.setGravity(5);
        } else if ("center".equals(textAlign)) {
            view.setGravity(1);
        } else {
            throw new JSApplicationIllegalArgumentException("Invalid textAlign: " + textAlign);
        }
    }

    @ReactProp(name="lineHeight", defaultFloat=NaNf)
    public void setLineHeight(ReactTextView view, float lineHeight) {
        if (Float.isNaN(lineHeight)) {
            view.setLineSpacing(0.0f, 1.0f);
        } else {
            view.setLineSpacing(PixelUtil.toPixelFromSP(lineHeight), 0.0f);
        }
    }

    @Override
    public void updateExtraData(ReactTextView view, Object extraData) {
        view.setText((CharSequence)((Spanned)extraData));
    }

    @Override
    public ReactTextShadowNode createShadowNodeInstance() {
        return new ReactTextShadowNode(false);
    }

    @Override
    public Class<ReactTextShadowNode> getShadowNodeClass() {
        return ReactTextShadowNode.class;
    }
}

