/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.progressbar;

import android.content.Context;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ProgressBar;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.views.progressbar.ReactProgressBarViewManager;
import javax.annotation.Nullable;

class ProgressBarContainerView
extends FrameLayout {
    @Nullable
    private Integer mColor;
    @Nullable
    private ProgressBar mProgressBar;

    public ProgressBarContainerView(Context context) {
        super(context);
    }

    public void setStyle(@Nullable String styleName) {
        int style2 = ReactProgressBarViewManager.getStyleFromString(styleName);
        this.mProgressBar = new ProgressBar(this.getContext(), null, style2);
        this.removeAllViews();
        this.addView((View)this.mProgressBar, new ViewGroup.LayoutParams(-2, -2));
    }

    public void setColor(@Nullable Integer color) {
        this.mColor = color;
    }

    public void apply() {
        if (this.mProgressBar == null) {
            throw new JSApplicationIllegalArgumentException("setStyle() not called");
        }
        this.setColor(this.mProgressBar);
    }

    private void setColor(ProgressBar progressBar) {
        Drawable drawable = progressBar.isIndeterminate() ? progressBar.getIndeterminateDrawable() : progressBar.getProgressDrawable();
        if (drawable == null) {
            return;
        }
        if (this.mColor != null) {
            drawable.setColorFilter(this.mColor.intValue(), PorterDuff.Mode.SRC_IN);
        } else {
            drawable.clearColorFilter();
        }
    }
}

