/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.recyclerview;

import android.content.Context;
import android.os.SystemClock;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.NativeGestureUtil;
import com.facebook.react.views.recyclerview.NotAnimatedItemAnimator;
import com.facebook.react.views.scroll.ScrollEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@VisibleForTesting
public class RecyclerViewBackedScrollView
extends RecyclerView {
    protected void onScrollChanged(int l, int t, int oldl, int oldt) {
        super.onScrollChanged(l, t, oldl, oldt);
        ReactListAdapter adapter = (ReactListAdapter)this.getAdapter();
        int offsetY = 0;
        if (this.getChildCount() > 0) {
            View recyclerViewChild = this.getChildAt(0);
            int childPosition = this.getChildAdapterPosition(recyclerViewChild);
            offsetY = adapter.getTopOffsetForItem(childPosition) - recyclerViewChild.getTop();
        }
        ScrollEvent event = new ScrollEvent(this.getId(), SystemClock.uptimeMillis(), 0, offsetY, this.getWidth(), adapter.getTotalChildrenHeight(), this.getWidth(), this.getHeight());
        ((ReactContext)this.getContext()).getNativeModule(UIManagerModule.class).getEventDispatcher().dispatchEvent(event);
    }

    public RecyclerViewBackedScrollView(Context context) {
        super(context);
        this.setHasFixedSize(true);
        this.setItemAnimator(new NotAnimatedItemAnimator());
        this.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(context));
        this.setAdapter(new ReactListAdapter());
    }

    void addViewToAdapter(View child, int index) {
        ((ReactListAdapter)this.getAdapter()).addView(child, index);
    }

    void removeViewFromAdapter(View child) {
        ((ReactListAdapter)this.getAdapter()).removeView(child);
    }

    View getChildAtFromAdapter(int index) {
        return ((ReactListAdapter)this.getAdapter()).getView(index);
    }

    int getChildCountFromAdapter() {
        return this.getAdapter().getItemCount();
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (super.onInterceptTouchEvent(ev)) {
            NativeGestureUtil.notifyNativeGestureStarted((View)this, ev);
            return true;
        }
        return false;
    }

    static class ReactListAdapter
    extends RecyclerView.Adapter<ConcreteViewHolder> {
        private final List<View> mViews = new ArrayList<View>();
        private final Map<View, Integer> mTopOffsetsFromLayout = new HashMap<View, Integer>();
        private int mTotalChildrenHeight = 0;
        private final View.OnLayoutChangeListener mChildLayoutChangeListener = new View.OnLayoutChangeListener(){
            private boolean mReentrant = false;

            public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
                if (!this.mReentrant) {
                    int oldHeight = oldBottom - oldTop;
                    int newHeight = bottom - top;
                    int width = right - left;
                    ReactListAdapter.this.mTopOffsetsFromLayout.put(v, top);
                    ReactListAdapter.this.mTotalChildrenHeight = ReactListAdapter.this.mTotalChildrenHeight - oldHeight + newHeight;
                    this.mReentrant = true;
                    v.layout(0, 0, width, newHeight);
                    this.mReentrant = false;
                    if (newHeight != oldHeight && v.getParent() != null && v.getParent().getParent() != null) {
                        View wrapper = (View)v.getParent();
                        wrapper.forceLayout();
                        ((View)wrapper.getParent()).forceLayout();
                    }
                }
            }
        };

        public ReactListAdapter() {
            this.setHasStableIds(true);
        }

        public void addView(View child, int index) {
            this.mViews.add(index, child);
            this.mTotalChildrenHeight += child.getMeasuredHeight();
            this.mTopOffsetsFromLayout.put(child, child.getTop());
            child.addOnLayoutChangeListener(this.mChildLayoutChangeListener);
            this.notifyDataSetChanged();
        }

        public void removeView(View child) {
            if (this.mViews.remove(child)) {
                this.mTopOffsetsFromLayout.remove(child);
                child.removeOnLayoutChangeListener(this.mChildLayoutChangeListener);
                this.mTotalChildrenHeight -= child.getMeasuredHeight();
                this.notifyDataSetChanged();
            }
        }

        public ConcreteViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
            return new ConcreteViewHolder((View)new RecyclableWrapperViewGroup(parent.getContext()));
        }

        public void onBindViewHolder(ConcreteViewHolder holder, int position) {
            RecyclableWrapperViewGroup vg = (RecyclableWrapperViewGroup)holder.itemView;
            View row = this.mViews.get(position);
            if (row.getParent() != vg) {
                vg.addView(row, 0);
            }
        }

        public void onViewRecycled(ConcreteViewHolder holder) {
            super.onViewRecycled((RecyclerView.ViewHolder)holder);
            ((RecyclableWrapperViewGroup)holder.itemView).removeAllViews();
        }

        public int getItemCount() {
            return this.mViews.size();
        }

        public long getItemId(int position) {
            return this.mViews.get(position).getId();
        }

        public View getView(int index) {
            return this.mViews.get(index);
        }

        public int getTotalChildrenHeight() {
            return this.mTotalChildrenHeight;
        }

        public int getTopOffsetForItem(int index) {
            return (Integer)Assertions.assertNotNull((Object)this.mTopOffsetsFromLayout.get(Assertions.assertNotNull((Object)this.mViews.get(index))));
        }
    }

    private static class RecyclableWrapperViewGroup
    extends ViewGroup {
        public RecyclableWrapperViewGroup(Context context) {
            super(context);
        }

        protected void onLayout(boolean changed, int l, int t, int r, int b) {
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            if (this.getChildCount() > 0) {
                View child = this.getChildAt(0);
                this.setMeasuredDimension(child.getMeasuredWidth(), child.getMeasuredHeight());
            } else {
                Assertions.assertUnreachable((String)"RecyclableWrapperView measured but no view attached");
            }
        }
    }

    private static class ConcreteViewHolder
    extends RecyclerView.ViewHolder {
        public ConcreteViewHolder(View itemView) {
            super(itemView);
        }
    }
}

