/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.view.View;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapKeySetIterator;
import com.facebook.react.touch.CatalystInterceptingViewGroup;
import com.facebook.react.touch.JSResponderHandler;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIProp;
import com.facebook.react.uimanager.ViewManagersPropertyCache;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;

public abstract class ViewManager<T extends View, C extends ReactShadowNode> {
    private static final Map<Class, Map<String, UIProp.Type>> CLASS_PROP_CACHE = new HashMap<Class, Map<String, UIProp.Type>>();

    public final void updateProperties(T viewToUpdate, CatalystStylesDiffMap props) {
        Map<String, ViewManagersPropertyCache.PropSetter> propSetters = ViewManagersPropertyCache.getNativePropSettersForViewManagerClass(this.getClass());
        ReadableMap propMap = props.mBackingMap;
        ReadableMapKeySetIterator iterator = propMap.keySetIterator();
        boolean missingSetters = false;
        while (iterator.hasNextKey()) {
            String key = iterator.nextKey();
            ViewManagersPropertyCache.PropSetter setter = propSetters.get(key);
            if (setter != null) {
                setter.updateViewProp(this, (View)viewToUpdate, props);
                continue;
            }
            missingSetters = true;
        }
        if (missingSetters) {
            this.updateView(viewToUpdate, props);
        }
        this.onAfterUpdateTransaction(viewToUpdate);
    }

    public final T createView(ThemedReactContext reactContext, JSResponderHandler jsResponderHandler) {
        T view = this.createViewInstance(reactContext);
        this.addEventEmitters(reactContext, view);
        if (view instanceof CatalystInterceptingViewGroup) {
            ((CatalystInterceptingViewGroup)view).setOnInterceptTouchEventListener(jsResponderHandler);
        }
        return view;
    }

    public abstract String getName();

    public abstract C createShadowNodeInstance();

    public abstract Class<? extends C> getShadowNodeClass();

    protected abstract T createViewInstance(ThemedReactContext var1);

    public void onDropViewInstance(ThemedReactContext reactContext, T view) {
    }

    protected void addEventEmitters(ThemedReactContext reactContext, T view) {
    }

    @Deprecated
    protected void updateView(T root, CatalystStylesDiffMap props) {
    }

    protected void onAfterUpdateTransaction(T view) {
    }

    public abstract void updateExtraData(T var1, Object var2);

    public void receiveCommand(T root, int commandId, @Nullable ReadableArray args) {
    }

    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedCustomBubblingEventTypeConstants() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedCustomDirectEventTypeConstants() {
        return null;
    }

    @Nullable
    public Map<String, Object> getExportedViewConstants() {
        return null;
    }

    public Map<String, String> getNativeProps() {
        Class<?> cls = this.getClass();
        Map<String, String> nativeProps = ViewManagersPropertyCache.getNativePropsForView(cls, this.getShadowNodeClass());
        while (cls.getSuperclass() != null) {
            Map<String, UIProp.Type> props = this.getNativePropsForClass(cls);
            for (Map.Entry<String, UIProp.Type> entry : props.entrySet()) {
                nativeProps.put(entry.getKey(), entry.getValue().toString());
            }
            cls = cls.getSuperclass();
        }
        return nativeProps;
    }

    private Map<String, UIProp.Type> getNativePropsForClass(Class cls) {
        Map<String, UIProp.Type> props = CLASS_PROP_CACHE.get(cls);
        if (props != null) {
            return props;
        }
        props = new HashMap<String, UIProp.Type>();
        for (Field f : cls.getDeclaredFields()) {
            UIProp annotation = f.getAnnotation(UIProp.class);
            if (annotation == null) continue;
            UIProp.Type type = annotation.value();
            try {
                String name = (String)f.get(this);
                props.put(name, type);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("UIProp " + cls.getName() + "." + f.getName() + " must be public.");
            }
        }
        CLASS_PROP_CACHE.put(cls, props);
        return props;
    }
}

