/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.websocket;

import com.facebook.common.logging.FLog;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.modules.core.DeviceEventManagerModule;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ws.WebSocket;
import com.squareup.okhttp.ws.WebSocketCall;
import com.squareup.okhttp.ws.WebSocketListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okio.Buffer;
import okio.BufferedSource;

public class WebSocketModule
extends ReactContextBaseJavaModule {
    private Map<Integer, WebSocket> mWebSocketConnections = new HashMap<Integer, WebSocket>();
    private ReactContext mReactContext;

    public WebSocketModule(ReactApplicationContext context) {
        super(context);
        this.mReactContext = context;
    }

    private void sendEvent(String eventName, WritableMap params) {
        this.mReactContext.getJSModule(DeviceEventManagerModule.RCTDeviceEventEmitter.class).emit(eventName, params);
    }

    @Override
    public String getName() {
        return "WebSocketModule";
    }

    @ReactMethod
    public void connect(String url, final int id2) {
        OkHttpClient client = new OkHttpClient();
        client.setConnectTimeout(10L, TimeUnit.SECONDS);
        client.setWriteTimeout(10L, TimeUnit.SECONDS);
        client.setReadTimeout(0L, TimeUnit.MINUTES);
        Request request = new Request.Builder().tag((Object)id2).url(url).build();
        WebSocketCall.create((OkHttpClient)client, (Request)request).enqueue(new WebSocketListener(){

            public void onOpen(WebSocket webSocket, Response response) {
                WebSocketModule.this.mWebSocketConnections.put(id2, webSocket);
                WritableMap params = Arguments.createMap();
                params.putInt("id", id2);
                WebSocketModule.this.sendEvent("websocketOpen", params);
            }

            public void onClose(int code, String reason) {
                WritableMap params = Arguments.createMap();
                params.putInt("id", id2);
                params.putInt("code", code);
                params.putString("reason", reason);
                WebSocketModule.this.sendEvent("websocketClosed", params);
            }

            public void onFailure(IOException e, Response response) {
                WebSocketModule.this.notifyWebSocketFailed(id2, e.getMessage());
            }

            public void onPong(Buffer buffer) {
            }

            public void onMessage(BufferedSource bufferedSource, WebSocket.PayloadType payloadType) {
                String message;
                try {
                    message = bufferedSource.readUtf8();
                }
                catch (IOException e) {
                    WebSocketModule.this.notifyWebSocketFailed(id2, e.getMessage());
                    return;
                }
                try {
                    bufferedSource.close();
                }
                catch (IOException e) {
                    FLog.e((String)"React", (String)("Could not close BufferedSource for WebSocket id " + id2), (Throwable)e);
                }
                WritableMap params = Arguments.createMap();
                params.putInt("id", id2);
                params.putString("data", message);
                WebSocketModule.this.sendEvent("websocketMessage", params);
            }
        });
        client.getDispatcher().getExecutorService().shutdown();
    }

    @ReactMethod
    public void close(int code, String reason, int id2) {
        WebSocket client = this.mWebSocketConnections.get(id2);
        if (client == null) {
            throw new RuntimeException("Cannot close WebSocket. Unknown WebSocket id " + id2);
        }
        try {
            client.close(code, reason);
            this.mWebSocketConnections.remove(id2);
        }
        catch (Exception e) {
            FLog.e((String)"React", (String)("Could not close WebSocket connection for id " + id2), (Throwable)e);
        }
    }

    @ReactMethod
    public void send(String message, int id2) {
        WebSocket client = this.mWebSocketConnections.get(id2);
        if (client == null) {
            throw new RuntimeException("Cannot send a message. Unknown WebSocket id " + id2);
        }
        try {
            client.sendMessage(WebSocket.PayloadType.TEXT, new Buffer().writeUtf8(message));
        }
        catch (IOException e) {
            this.notifyWebSocketFailed(id2, e.getMessage());
        }
    }

    private void notifyWebSocketFailed(int id2, String message) {
        WritableMap params = Arguments.createMap();
        params.putInt("id", id2);
        params.putString("message", message);
        this.sendEvent("websocketFailed", params);
    }
}

