/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.graphics.Rect;
import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.views.textinput.ReactTextUpdate;
import java.util.ArrayList;
import javax.annotation.Nullable;

public class ReactEditText
extends EditText {
    private final InputMethodManager mInputMethodManager;
    private boolean mIsSettingTextFromJS;
    private boolean mIsJSSettingFocus;
    private int mDefaultGravityHorizontal;
    private int mDefaultGravityVertical;
    private int mNativeEventCount;
    @Nullable
    private ArrayList<TextWatcher> mListeners;
    @Nullable
    private TextWatcherDelegator mTextWatcherDelegator;
    private int mStagedInputType;

    public ReactEditText(Context context) {
        super(context);
        this.setFocusableInTouchMode(false);
        this.mInputMethodManager = (InputMethodManager)Assertions.assertNotNull((Object)this.getContext().getSystemService("input_method"));
        this.mDefaultGravityHorizontal = this.getGravity() & 0x800007;
        this.mDefaultGravityVertical = this.getGravity() & 0x70;
        this.mNativeEventCount = 0;
        this.mIsSettingTextFromJS = false;
        this.mIsJSSettingFocus = false;
        this.mListeners = null;
        this.mTextWatcherDelegator = null;
        this.mStagedInputType = this.getInputType();
    }

    public boolean isLayoutRequested() {
        return false;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 66 && (this.getInputType() & 0x20000) == 0) {
            this.hideSoftKeyboard();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    public void clearFocus() {
        this.setFocusableInTouchMode(false);
        super.clearFocus();
        this.hideSoftKeyboard();
    }

    public boolean requestFocus(int direction, Rect previouslyFocusedRect) {
        if (!this.mIsJSSettingFocus) {
            return false;
        }
        this.setFocusableInTouchMode(true);
        boolean focused = super.requestFocus(direction, previouslyFocusedRect);
        this.showSoftKeyboard();
        return focused;
    }

    public void addTextChangedListener(TextWatcher watcher) {
        if (this.mListeners == null) {
            this.mListeners = new ArrayList();
            super.addTextChangedListener((TextWatcher)this.getTextWatcherDelegator());
        }
        this.mListeners.add(watcher);
    }

    public void removeTextChangedListener(TextWatcher watcher) {
        if (this.mListeners != null) {
            this.mListeners.remove(watcher);
            if (this.mListeners.isEmpty()) {
                this.mListeners = null;
                super.removeTextChangedListener((TextWatcher)this.getTextWatcherDelegator());
            }
        }
    }

    int getStagedInputType() {
        return this.mStagedInputType;
    }

    void setStagedInputType(int stagedInputType) {
        this.mStagedInputType = stagedInputType;
    }

    void commitStagedInputType() {
        if (this.getInputType() != this.mStagedInputType) {
            this.setInputType(this.mStagedInputType);
        }
    }

    public void setInputType(int type) {
        super.setInputType(type);
        this.mStagedInputType = type;
    }

    void requestFocusFromJS() {
        this.mIsJSSettingFocus = true;
        this.requestFocus();
        this.mIsJSSettingFocus = false;
    }

    void clearFocusFromJS() {
        this.clearFocus();
    }

    public int incrementAndGetEventCounter() {
        return ++this.mNativeEventCount;
    }

    public void maybeSetText(ReactTextUpdate reactTextUpdate) {
        if (reactTextUpdate.getJsEventCounter() < this.mNativeEventCount) {
            return;
        }
        SpannableStringBuilder spannableStringBuilder = new SpannableStringBuilder((CharSequence)reactTextUpdate.getText());
        this.manageSpans(spannableStringBuilder);
        this.mIsSettingTextFromJS = true;
        this.getText().replace(0, this.length(), (CharSequence)spannableStringBuilder);
        this.mIsSettingTextFromJS = false;
    }

    private void manageSpans(SpannableStringBuilder spannableStringBuilder) {
        Object[] spans = this.getText().getSpans(0, this.length(), Object.class);
        for (int spanIdx = 0; spanIdx < spans.length; ++spanIdx) {
            if ((this.getText().getSpanFlags(spans[spanIdx]) & 0x21) != 33) continue;
            Object span = spans[spanIdx];
            int spanStart = this.getText().getSpanStart(spans[spanIdx]);
            int spanEnd = this.getText().getSpanEnd(spans[spanIdx]);
            int spanFlags = this.getText().getSpanFlags(spans[spanIdx]);
            this.getText().removeSpan(spans[spanIdx]);
            if (!ReactEditText.sameTextForSpan(this.getText(), spannableStringBuilder, spanStart, spanEnd)) continue;
            spannableStringBuilder.setSpan(span, spanStart, spanEnd, spanFlags);
        }
    }

    private static boolean sameTextForSpan(Editable oldText, SpannableStringBuilder newText, int start, int end) {
        if (start > newText.length() || end > newText.length()) {
            return false;
        }
        for (int charIdx = start; charIdx < end; ++charIdx) {
            if (oldText.charAt(charIdx) == newText.charAt(charIdx)) continue;
            return false;
        }
        return true;
    }

    private boolean showSoftKeyboard() {
        return this.mInputMethodManager.showSoftInput((View)this, 0);
    }

    private void hideSoftKeyboard() {
        this.mInputMethodManager.hideSoftInputFromWindow(this.getWindowToken(), 0);
    }

    private TextWatcherDelegator getTextWatcherDelegator() {
        if (this.mTextWatcherDelegator == null) {
            this.mTextWatcherDelegator = new TextWatcherDelegator();
        }
        return this.mTextWatcherDelegator;
    }

    void setGravityHorizontal(int gravityHorizontal) {
        if (gravityHorizontal == 0) {
            gravityHorizontal = this.mDefaultGravityHorizontal;
        }
        this.setGravity(this.getGravity() & 0xFFFFFFF8 & 0xFF7FFFF8 | gravityHorizontal);
    }

    void setGravityVertical(int gravityVertical) {
        if (gravityVertical == 0) {
            gravityVertical = this.mDefaultGravityVertical;
        }
        this.setGravity(this.getGravity() & 0xFFFFFF8F | gravityVertical);
    }

    private class TextWatcherDelegator
    implements TextWatcher {
        private TextWatcherDelegator() {
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            if (!ReactEditText.this.mIsSettingTextFromJS && ReactEditText.this.mListeners != null) {
                for (TextWatcher listener : ReactEditText.this.mListeners) {
                    listener.beforeTextChanged(s, start, count, after);
                }
            }
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (!ReactEditText.this.mIsSettingTextFromJS && ReactEditText.this.mListeners != null) {
                for (TextWatcher listener : ReactEditText.this.mListeners) {
                    listener.onTextChanged(s, start, before, count);
                }
            }
        }

        public void afterTextChanged(Editable s) {
            if (!ReactEditText.this.mIsSettingTextFromJS && ReactEditText.this.mListeners != null) {
                for (TextWatcher listener : ReactEditText.this.mListeners) {
                    listener.afterTextChanged(s);
                }
            }
        }
    }
}

