/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewGroup;
import com.facebook.react.bridge.JSApplicationIllegalArgumentException;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.uimanager.PointerEvents;
import com.facebook.react.uimanager.ReactCompoundView;
import com.facebook.react.uimanager.ReactPointerEventsView;
import javax.annotation.Nullable;

public class TouchTargetHelper {
    private static final Rect mVisibleRect = new Rect();
    private static final int[] mViewLocationInScreen = new int[]{0, 0};

    public static int findTargetTagForTouch(float eventY, float eventX, ViewGroup viewGroup) {
        View reactTargetView;
        UiThreadUtil.assertOnUiThread();
        int targetTag = viewGroup.getId();
        View nativeTargetView = TouchTargetHelper.findTouchTargetView(eventX, eventY, viewGroup);
        if (nativeTargetView != null && (reactTargetView = TouchTargetHelper.findClosestReactAncestor(nativeTargetView)) != null) {
            targetTag = TouchTargetHelper.getTouchTargetForView(reactTargetView, eventX, eventY);
        }
        return targetTag;
    }

    private static View findClosestReactAncestor(View view) {
        while (view != null && view.getId() <= 0) {
            view = (View)view.getParent();
        }
        return view;
    }

    private static View findTouchTargetView(float eventX, float eventY, ViewGroup viewGroup) {
        int childrenCount = viewGroup.getChildCount();
        for (int i = childrenCount - 1; i >= 0; --i) {
            View targetView;
            View child = viewGroup.getChildAt(i);
            if (child.getParent() == null || !TouchTargetHelper.isTouchPointInView(eventX, eventY, viewGroup, child) || (targetView = TouchTargetHelper.findTouchTargetViewWithPointerEvents(eventX += (float)(viewGroup.getScrollX() - child.getLeft()), eventY += (float)(viewGroup.getScrollY() - child.getTop()), child)) == null) continue;
            return targetView;
        }
        return viewGroup;
    }

    private static boolean isTouchPointInView(float x, float y, ViewGroup parent, View child) {
        float localX = x + (float)parent.getScrollX() - (float)child.getLeft();
        float localY = y + (float)parent.getScrollY() - (float)child.getTop();
        return localX >= 0.0f && localX < (float)(child.getRight() - child.getLeft()) && localY >= 0.0f && localY < (float)(child.getBottom() - child.getTop());
    }

    @Nullable
    private static View findTouchTargetViewWithPointerEvents(float eventX, float eventY, View view) {
        PointerEvents pointerEvents;
        PointerEvents pointerEvents2 = pointerEvents = view instanceof ReactPointerEventsView ? ((ReactPointerEventsView)view).getPointerEvents() : PointerEvents.AUTO;
        if (pointerEvents == PointerEvents.NONE) {
            return null;
        }
        if (pointerEvents == PointerEvents.BOX_ONLY) {
            return view;
        }
        if (pointerEvents == PointerEvents.BOX_NONE) {
            if (view instanceof ViewGroup) {
                View targetView = TouchTargetHelper.findTouchTargetView(eventX, eventY, (ViewGroup)view);
                return targetView != view ? targetView : null;
            }
            return null;
        }
        if (pointerEvents == PointerEvents.AUTO) {
            if (view instanceof ViewGroup) {
                return TouchTargetHelper.findTouchTargetView(eventX, eventY, (ViewGroup)view);
            }
            return view;
        }
        throw new JSApplicationIllegalArgumentException("Unknown pointer event type: " + pointerEvents.toString());
    }

    private static int getTouchTargetForView(View targetView, float eventX, float eventY) {
        if (targetView instanceof ReactCompoundView) {
            targetView.getLocationOnScreen(mViewLocationInScreen);
            return ((ReactCompoundView)targetView).reactTagForTouch(eventX - (float)mViewLocationInScreen[0], eventY - (float)mViewLocationInScreen[1]);
        }
        return targetView.getId();
    }
}

