/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.os.Build;
import android.view.View;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.uimanager.AccessibilityHelper;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ReactProp;
import com.facebook.react.uimanager.ReactShadowNode;
import com.facebook.react.uimanager.ViewManager;

public abstract class BaseViewManager<T extends View, C extends ReactShadowNode>
extends ViewManager<T, C> {
    private static final String PROP_BACKGROUND_COLOR = "backgroundColor";
    private static final String PROP_DECOMPOSED_MATRIX = "decomposedMatrix";
    private static final String PROP_DECOMPOSED_MATRIX_ROTATE = "rotate";
    private static final String PROP_DECOMPOSED_MATRIX_SCALE_X = "scaleX";
    private static final String PROP_DECOMPOSED_MATRIX_SCALE_Y = "scaleY";
    private static final String PROP_DECOMPOSED_MATRIX_TRANSLATE_X = "translateX";
    private static final String PROP_DECOMPOSED_MATRIX_TRANSLATE_Y = "translateY";
    private static final String PROP_OPACITY = "opacity";
    private static final String PROP_RENDER_TO_HARDWARE_TEXTURE = "renderToHardwareTextureAndroid";
    private static final String PROP_ACCESSIBILITY_LABEL = "accessibilityLabel";
    private static final String PROP_ACCESSIBILITY_COMPONENT_TYPE = "accessibilityComponentType";
    private static final String PROP_ACCESSIBILITY_LIVE_REGION = "accessibilityLiveRegion";
    private static final String PROP_IMPORTANT_FOR_ACCESSIBILITY = "importantForAccessibility";
    private static final String PROP_ROTATION = "rotation";
    private static final String PROP_SCALE_X = "scaleX";
    private static final String PROP_SCALE_Y = "scaleY";
    private static final String PROP_TRANSLATE_X = "translateX";
    private static final String PROP_TRANSLATE_Y = "translateY";
    public static final String PROP_TEST_ID = "testID";

    @ReactProp(name="backgroundColor", defaultInt=0, customType="Color")
    public void setBackgroundColor(T view, int backgroundColor) {
        view.setBackgroundColor(backgroundColor);
    }

    @ReactProp(name="decomposedMatrix")
    public void setDecomposedMatrix(T view, ReadableMap decomposedMatrix) {
        if (decomposedMatrix == null) {
            BaseViewManager.resetTransformMatrix(view);
        } else {
            BaseViewManager.setTransformMatrix(view, decomposedMatrix);
        }
    }

    @ReactProp(name="opacity", defaultFloat=1.0f)
    public void setOpacity(T view, float opacity) {
        view.setAlpha(opacity);
    }

    @ReactProp(name="renderToHardwareTextureAndroid")
    public void setRenderToHardwareTexture(T view, boolean useHWTexture) {
        view.setLayerType(useHWTexture ? 2 : 0, null);
    }

    @ReactProp(name="testID")
    public void setTestId(T view, String testId) {
        view.setTag((Object)testId);
    }

    @ReactProp(name="accessibilityLabel")
    public void setAccessibilityLabel(T view, String accessibilityLabel) {
        view.setContentDescription((CharSequence)accessibilityLabel);
    }

    @ReactProp(name="accessibilityComponentType")
    public void setAccessibilityComponentType(T view, String accessibilityComponentType) {
        AccessibilityHelper.updateAccessibilityComponentType(view, accessibilityComponentType);
    }

    @ReactProp(name="importantForAccessibility")
    public void setImportantForAccessibility(T view, String importantForAccessibility) {
        if (importantForAccessibility == null || importantForAccessibility.equals("auto")) {
            view.setImportantForAccessibility(0);
        } else if (importantForAccessibility.equals("yes")) {
            view.setImportantForAccessibility(1);
        } else if (importantForAccessibility.equals("no")) {
            view.setImportantForAccessibility(2);
        } else if (importantForAccessibility.equals("no-hide-descendants")) {
            view.setImportantForAccessibility(4);
        }
    }

    @Deprecated
    @ReactProp(name="rotation")
    public void setRotation(T view, float rotation) {
        view.setRotation(rotation);
    }

    @Deprecated
    @ReactProp(name="scaleX", defaultFloat=1.0f)
    public void setScaleX(T view, float scaleX) {
        view.setScaleX(scaleX);
    }

    @Deprecated
    @ReactProp(name="scaleY", defaultFloat=1.0f)
    public void setScaleY(T view, float scaleY) {
        view.setScaleY(scaleY);
    }

    @Deprecated
    @ReactProp(name="translateX", defaultFloat=1.0f)
    public void setTranslateX(T view, float translateX) {
        view.setTranslationX(translateX);
    }

    @Deprecated
    @ReactProp(name="translateY", defaultFloat=1.0f)
    public void setTranslateY(T view, float translateY) {
        view.setTranslationY(translateY);
    }

    @ReactProp(name="accessibilityLiveRegion")
    public void setAccessibilityLiveRegion(T view, String liveRegion) {
        if (Build.VERSION.SDK_INT >= 19) {
            if (liveRegion == null || liveRegion.equals("none")) {
                view.setAccessibilityLiveRegion(0);
            } else if (liveRegion.equals("polite")) {
                view.setAccessibilityLiveRegion(1);
            } else if (liveRegion.equals("assertive")) {
                view.setAccessibilityLiveRegion(2);
            }
        }
    }

    private static void setTransformMatrix(View view, ReadableMap matrix) {
        view.setTranslationX(PixelUtil.toPixelFromDIP((float)matrix.getDouble("translateX")));
        view.setTranslationY(PixelUtil.toPixelFromDIP((float)matrix.getDouble("translateY")));
        view.setRotation((float)matrix.getDouble(PROP_DECOMPOSED_MATRIX_ROTATE));
        view.setScaleX((float)matrix.getDouble("scaleX"));
        view.setScaleY((float)matrix.getDouble("scaleY"));
    }

    private static void resetTransformMatrix(View view) {
        view.setTranslationX(PixelUtil.toPixelFromDIP(0.0f));
        view.setTranslationY(PixelUtil.toPixelFromDIP(0.0f));
        view.setRotation(0.0f);
        view.setScaleX(1.0f);
        view.setScaleY(1.0f);
    }
}

