/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.network;

import android.content.Context;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.modules.network.OkHttpClientProvider;
import com.facebook.react.modules.network.RequestBodyUtil;
import com.squareup.okhttp.Callback;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.MultipartBuilder;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;

public final class NetworkingModule
extends ReactContextBaseJavaModule {
    private static final String CONTENT_ENCODING_HEADER_NAME = "content-encoding";
    private static final String CONTENT_TYPE_HEADER_NAME = "content-type";
    private static final String REQUEST_BODY_KEY_STRING = "string";
    private static final String REQUEST_BODY_KEY_URI = "uri";
    private static final String REQUEST_BODY_KEY_FORMDATA = "formData";
    private static final String USER_AGENT_HEADER_NAME = "user-agent";
    private final OkHttpClient mClient;
    @Nullable
    private final String mDefaultUserAgent;
    private boolean mShuttingDown;

    NetworkingModule(ReactApplicationContext reactContext, @Nullable String defaultUserAgent, OkHttpClient client) {
        super(reactContext);
        this.mClient = client;
        this.mShuttingDown = false;
        this.mDefaultUserAgent = defaultUserAgent;
    }

    public NetworkingModule(ReactApplicationContext reactContext) {
        this(reactContext, null, OkHttpClientProvider.getOkHttpClient());
    }

    public NetworkingModule(ReactApplicationContext reactContext, String defaultUserAgent) {
        this(reactContext, defaultUserAgent, OkHttpClientProvider.getOkHttpClient());
    }

    @Override
    public String getName() {
        return "RCTNetworking";
    }

    @Override
    public void onCatalystInstanceDestroy() {
        this.mShuttingDown = true;
        this.mClient.cancel(null);
    }

    @ReactMethod
    public void sendRequest(String method, String url, int requestId, ReadableArray headers, ReadableMap data, final com.facebook.react.bridge.Callback callback) {
        Headers requestHeaders;
        Request.Builder requestBuilder = new Request.Builder().url(url);
        if (requestId != 0) {
            requestBuilder.tag((Object)requestId);
        }
        if ((requestHeaders = this.extractHeaders(headers, data)) == null) {
            callback.invoke(0, null, "Unrecognized headers format");
            return;
        }
        String contentType = requestHeaders.get(CONTENT_TYPE_HEADER_NAME);
        String contentEncoding = requestHeaders.get(CONTENT_ENCODING_HEADER_NAME);
        requestBuilder.headers(requestHeaders);
        if (data == null) {
            requestBuilder.method(method, null);
        } else if (data.hasKey(REQUEST_BODY_KEY_STRING)) {
            if (contentType == null) {
                callback.invoke(0, null, "Payload is set but no content-type header specified");
                return;
            }
            String body = data.getString(REQUEST_BODY_KEY_STRING);
            MediaType contentMediaType = MediaType.parse((String)contentType);
            if (RequestBodyUtil.isGzipEncoding(contentEncoding)) {
                RequestBody requestBody = RequestBodyUtil.createGzip(contentMediaType, body);
                if (requestBody == null) {
                    callback.invoke(0, null, "Failed to gzip request body");
                    return;
                }
                requestBuilder.method(method, requestBody);
            } else {
                requestBuilder.method(method, RequestBody.create((MediaType)contentMediaType, (String)body));
            }
        } else if (data.hasKey(REQUEST_BODY_KEY_URI)) {
            if (contentType == null) {
                callback.invoke(0, null, "Payload is set but no content-type header specified");
                return;
            }
            String uri = data.getString(REQUEST_BODY_KEY_URI);
            InputStream fileInputStream = RequestBodyUtil.getFileInputStream((Context)this.getReactApplicationContext(), uri);
            if (fileInputStream == null) {
                callback.invoke(0, null, "Could not retrieve file for uri " + uri);
                return;
            }
            requestBuilder.method(method, RequestBodyUtil.create(MediaType.parse((String)contentType), fileInputStream));
        } else if (data.hasKey(REQUEST_BODY_KEY_FORMDATA)) {
            ReadableArray parts;
            MultipartBuilder multipartBuilder;
            if (contentType == null) {
                contentType = "multipart/form-data";
            }
            if ((multipartBuilder = this.constructMultipartBody(parts = data.getArray(REQUEST_BODY_KEY_FORMDATA), contentType, callback)) == null) {
                return;
            }
            requestBuilder.method(method, multipartBuilder.build());
        } else {
            requestBuilder.method(method, null);
        }
        this.mClient.newCall(requestBuilder.build()).enqueue(new Callback(){

            public void onFailure(Request request, IOException e) {
                if (NetworkingModule.this.mShuttingDown) {
                    return;
                }
                callback.invoke(0, null, e.getMessage());
            }

            public void onResponse(Response response) throws IOException {
                String responseBody;
                if (NetworkingModule.this.mShuttingDown) {
                    return;
                }
                try {
                    responseBody = response.body().string();
                }
                catch (IOException e) {
                    callback.invoke(0, null, e.getMessage());
                    return;
                }
                callback.invoke(response.code(), null, responseBody);
            }
        });
    }

    @ReactMethod
    public void abortRequest(final int requestId) {
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            protected void doInBackgroundGuarded(Void ... params) {
                NetworkingModule.this.mClient.cancel((Object)requestId);
            }
        }.execute(new Void[0]);
    }

    @Nullable
    private MultipartBuilder constructMultipartBody(ReadableArray body, String contentType, com.facebook.react.bridge.Callback callback) {
        MultipartBuilder multipartBuilder = new MultipartBuilder();
        multipartBuilder.type(MediaType.parse((String)contentType));
        int size = body.size();
        for (int i = 0; i < size; ++i) {
            ReadableMap bodyPart = body.getMap(i);
            ReadableArray headersArray = bodyPart.getArray("headers");
            Headers headers = this.extractHeaders(headersArray, null);
            if (headers == null) {
                callback.invoke(0, null, "Missing or invalid header format for FormData part.");
                return null;
            }
            MediaType partContentType = null;
            String partContentTypeStr = headers.get(CONTENT_TYPE_HEADER_NAME);
            if (partContentTypeStr != null) {
                partContentType = MediaType.parse((String)partContentTypeStr);
                headers = headers.newBuilder().removeAll(CONTENT_TYPE_HEADER_NAME).build();
            }
            if (bodyPart.hasKey(REQUEST_BODY_KEY_STRING)) {
                String bodyValue = bodyPart.getString(REQUEST_BODY_KEY_STRING);
                multipartBuilder.addPart(headers, RequestBody.create((MediaType)partContentType, (String)bodyValue));
                continue;
            }
            if (bodyPart.hasKey(REQUEST_BODY_KEY_URI)) {
                if (partContentType == null) {
                    callback.invoke(0, null, "Binary FormData part needs a content-type header.");
                    return null;
                }
                String fileContentUriStr = bodyPart.getString(REQUEST_BODY_KEY_URI);
                InputStream fileInputStream = RequestBodyUtil.getFileInputStream((Context)this.getReactApplicationContext(), fileContentUriStr);
                if (fileInputStream == null) {
                    callback.invoke(0, null, "Could not retrieve file for uri " + fileContentUriStr);
                    return null;
                }
                multipartBuilder.addPart(headers, RequestBodyUtil.create(partContentType, fileInputStream));
                continue;
            }
            callback.invoke(0, null, "Unrecognized FormData part.");
        }
        return multipartBuilder;
    }

    @Nullable
    private Headers extractHeaders(@Nullable ReadableArray headersArray, @Nullable ReadableMap requestData) {
        boolean isGzipSupported;
        if (headersArray == null) {
            return null;
        }
        Headers.Builder headersBuilder = new Headers.Builder();
        int size = headersArray.size();
        for (int headersIdx = 0; headersIdx < size; ++headersIdx) {
            ReadableArray header = headersArray.getArray(headersIdx);
            if (header == null || header.size() != 2) {
                return null;
            }
            String headerName = header.getString(0);
            String headerValue = header.getString(1);
            headersBuilder.add(headerName, headerValue);
        }
        if (headersBuilder.get(USER_AGENT_HEADER_NAME) == null && this.mDefaultUserAgent != null) {
            headersBuilder.add(USER_AGENT_HEADER_NAME, this.mDefaultUserAgent);
        }
        boolean bl = isGzipSupported = requestData != null && requestData.hasKey(REQUEST_BODY_KEY_STRING);
        if (!isGzipSupported) {
            headersBuilder.removeAll(CONTENT_ENCODING_HEADER_NAME);
        }
        return headersBuilder.build();
    }
}

