/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.content.Context;
import android.graphics.PorterDuff;
import android.os.SystemClock;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.View;
import android.widget.TextView;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.JSApplicationCausedNativeException;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.BaseViewPropertyApplicator;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.UIProp;
import com.facebook.react.uimanager.ViewManager;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.text.DefaultStyleValuesUtil;
import com.facebook.react.views.textinput.ReactEditText;
import com.facebook.react.views.textinput.ReactTextChangedEvent;
import com.facebook.react.views.textinput.ReactTextInputBlurEvent;
import com.facebook.react.views.textinput.ReactTextInputEndEditingEvent;
import com.facebook.react.views.textinput.ReactTextInputEvent;
import com.facebook.react.views.textinput.ReactTextInputFocusEvent;
import com.facebook.react.views.textinput.ReactTextInputShadowNode;
import com.facebook.react.views.textinput.ReactTextInputSubmitEditingEvent;
import com.facebook.react.views.textinput.ReactTextUpdate;
import java.util.Map;
import javax.annotation.Nullable;

public class ReactTextInputManager
extends ViewManager<ReactEditText, ReactTextInputShadowNode> {
    static final String REACT_CLASS = "AndroidTextInput";
    private static final int FOCUS_TEXT_INPUT = 1;
    private static final int BLUR_TEXT_INPUT = 2;
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_TEXT_INPUT_TEXT = "text";
    @UIProp(value=UIProp.Type.NUMBER)
    public static final String PROP_TEXT_INPUT_MOST_RECENT_EVENT_COUNT = "mostRecentEventCount";
    @UIProp(value=UIProp.Type.NUMBER)
    public static final String PROP_FONT_SIZE = "fontSize";
    @UIProp(value=UIProp.Type.BOOLEAN)
    public static final String PROP_TEXT_INPUT_AUTO_CORRECT = "autoCorrect";
    @UIProp(value=UIProp.Type.NUMBER)
    public static final String PROP_TEXT_INPUT_AUTO_CAPITALIZE = "autoCapitalize";
    @UIProp(value=UIProp.Type.NUMBER)
    public static final String PROP_TEXT_ALIGN = "textAlign";
    @UIProp(value=UIProp.Type.NUMBER)
    public static final String PROP_TEXT_ALIGN_VERTICAL = "textAlignVertical";
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_TEXT_INPUT_HINT = "placeholder";
    @UIProp(value=UIProp.Type.COLOR)
    public static final String PROP_TEXT_INPUT_HINT_COLOR = "placeholderTextColor";
    @UIProp(value=UIProp.Type.NUMBER)
    public static final String PROP_TEXT_INPUT_NUMLINES = "numberOfLines";
    @UIProp(value=UIProp.Type.BOOLEAN)
    public static final String PROP_TEXT_INPUT_MULTILINE = "multiline";
    @UIProp(value=UIProp.Type.STRING)
    public static final String PROP_TEXT_INPUT_KEYBOARD_TYPE = "keyboardType";
    @UIProp(value=UIProp.Type.BOOLEAN)
    public static final String PROP_TEXT_INPUT_PASSWORD = "password";
    @UIProp(value=UIProp.Type.BOOLEAN)
    public static final String PROP_TEXT_INPUT_EDITABLE = "editable";
    @UIProp(value=UIProp.Type.COLOR)
    public static final String PROP_TEXT_INPUT_UNDERLINE_COLOR = "underlineColorAndroid";
    @UIProp(value=UIProp.Type.NUMBER)
    public static final String PROP_TEST_ID = "testID";
    private static final String KEYBOARD_TYPE_EMAIL_ADDRESS = "email-address";
    private static final String KEYBOARD_TYPE_NUMERIC = "numeric";

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactEditText createViewInstance(ThemedReactContext context) {
        ReactEditText editText = new ReactEditText((Context)context);
        int inputType = editText.getInputType();
        editText.setInputType(inputType & 0xFFFDFFFF);
        editText.setImeOptions(6);
        editText.setTextSize(0, (int)Math.ceil(PixelUtil.toPixelFromSP(14.0f)));
        return editText;
    }

    @Override
    public ReactTextInputShadowNode createCSSNodeInstance() {
        return new ReactTextInputShadowNode();
    }

    @Override
    @Nullable
    public Map<String, Object> getExportedCustomBubblingEventTypeConstants() {
        return MapBuilder.builder().put("topSubmitEditing", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onSubmitEditing", "captured", "onSubmitEditingCapture"))).put("topEndEditing", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onEndEditing", "captured", "onEndEditingCapture"))).put("topTextInput", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onTextInput", "captured", "onTextInputCapture"))).put("topFocus", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onFocus", "captured", "onFocusCapture"))).put("topBlur", MapBuilder.of("phasedRegistrationNames", MapBuilder.of("bubbled", "onBlur", "captured", "onBlurCapture"))).build();
    }

    @Override
    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return MapBuilder.of("focusTextInput", 1, "blurTextInput", 2);
    }

    @Override
    public void receiveCommand(ReactEditText reactEditText, int commandId, @Nullable ReadableArray args) {
        switch (commandId) {
            case 1: {
                reactEditText.requestFocusFromJS();
                break;
            }
            case 2: {
                reactEditText.clearFocusFromJS();
            }
        }
    }

    @Override
    public void updateExtraData(ReactEditText view, Object extraData) {
        if (extraData instanceof float[]) {
            float[] padding = (float[])extraData;
            view.setPadding((int)Math.ceil(padding[0]), (int)Math.ceil(padding[1]), (int)Math.ceil(padding[2]), (int)Math.ceil(padding[3]));
        } else if (extraData instanceof ReactTextUpdate) {
            view.maybeSetText((ReactTextUpdate)extraData);
        }
    }

    @Override
    public void updateView(ReactEditText view, CatalystStylesDiffMap props) {
        BaseViewPropertyApplicator.applyCommonViewProperties((View)view, props);
        if (props.hasKey(PROP_FONT_SIZE)) {
            float textSize = props.getFloat(PROP_FONT_SIZE, 14.0f);
            view.setTextSize(0, (int)Math.ceil(PixelUtil.toPixelFromSP(textSize)));
        }
        if (props.hasKey("color")) {
            if (props.isNull("color")) {
                view.setTextColor(DefaultStyleValuesUtil.getDefaultTextColor(view.getContext()));
            } else {
                int textColor = props.getInt("color", 0);
                view.setTextColor(textColor);
            }
        }
        if (props.hasKey(PROP_TEXT_INPUT_HINT)) {
            view.setHint(props.getString(PROP_TEXT_INPUT_HINT));
        }
        if (props.hasKey(PROP_TEXT_INPUT_HINT_COLOR)) {
            if (props.isNull(PROP_TEXT_INPUT_HINT_COLOR)) {
                view.setHintTextColor(DefaultStyleValuesUtil.getDefaultTextColorHint(view.getContext()));
            } else {
                int hintColor = props.getInt(PROP_TEXT_INPUT_HINT_COLOR, 0);
                view.setHintTextColor(hintColor);
            }
        }
        if (props.hasKey(PROP_TEXT_INPUT_UNDERLINE_COLOR)) {
            if (props.isNull(PROP_TEXT_INPUT_UNDERLINE_COLOR)) {
                view.getBackground().clearColorFilter();
            } else {
                int underlineColor = props.getInt(PROP_TEXT_INPUT_UNDERLINE_COLOR, 0);
                view.getBackground().setColorFilter(underlineColor, PorterDuff.Mode.SRC_IN);
            }
        }
        if (props.hasKey(PROP_TEXT_ALIGN)) {
            int gravityHorizontal = props.getInt(PROP_TEXT_ALIGN, 0);
            view.setGravityHorizontal(gravityHorizontal);
        }
        if (props.hasKey(PROP_TEXT_ALIGN_VERTICAL)) {
            int gravityVertical = props.getInt(PROP_TEXT_ALIGN_VERTICAL, 0);
            view.setGravityVertical(gravityVertical);
        }
        if (props.hasKey(PROP_TEXT_INPUT_EDITABLE)) {
            if (props.getBoolean(PROP_TEXT_INPUT_EDITABLE, true)) {
                view.setEnabled(true);
            } else {
                view.setEnabled(false);
            }
        }
        int newInputType = view.getInputType();
        if (props.hasKey(PROP_TEXT_INPUT_AUTO_CORRECT)) {
            newInputType &= 0xFFF77FFF;
            if (props.getBoolean(PROP_TEXT_INPUT_AUTO_CORRECT, false)) {
                newInputType |= 0x8000;
            } else if (!props.isNull(PROP_TEXT_INPUT_AUTO_CORRECT)) {
                newInputType |= 0x80000;
            }
        }
        if (props.hasKey(PROP_TEXT_INPUT_MULTILINE)) {
            newInputType = props.getBoolean(PROP_TEXT_INPUT_MULTILINE, false) ? (newInputType |= 0x20000) : (newInputType &= 0xFFFDFFFF);
        }
        if (props.hasKey(PROP_TEXT_INPUT_KEYBOARD_TYPE)) {
            newInputType = newInputType & 0xFFFFFFFD & 0xFFFFFFDF;
            String keyboardType = props.getString(PROP_TEXT_INPUT_KEYBOARD_TYPE);
            if (KEYBOARD_TYPE_NUMERIC.equalsIgnoreCase(keyboardType)) {
                newInputType |= 2;
            } else if (KEYBOARD_TYPE_EMAIL_ADDRESS.equalsIgnoreCase(keyboardType)) {
                newInputType |= 0x20;
            }
        }
        if (props.hasKey(PROP_TEXT_INPUT_PASSWORD)) {
            newInputType = props.getBoolean(PROP_TEXT_INPUT_PASSWORD, false) ? (newInputType |= 0x80) : (newInputType &= 0xFFFFFF7F);
        }
        if (props.hasKey(PROP_TEXT_INPUT_AUTO_CAPITALIZE)) {
            newInputType &= 0xFFFF8FFF;
            int autoCapitalize = props.getInt(PROP_TEXT_INPUT_AUTO_CAPITALIZE, 1);
            switch (autoCapitalize) {
                case 1: 
                case 4096: 
                case 8192: 
                case 16384: {
                    newInputType |= autoCapitalize;
                    break;
                }
                default: {
                    throw new JSApplicationCausedNativeException("Invalid autoCapitalize value: " + autoCapitalize);
                }
            }
        }
        if (view.getInputType() != newInputType) {
            view.setInputType(newInputType);
        }
        if (props.hasKey(PROP_TEXT_INPUT_NUMLINES)) {
            view.setLines(props.getInt(PROP_TEXT_INPUT_NUMLINES, 1));
        }
    }

    @Override
    protected void addEventEmitters(final ThemedReactContext reactContext, final ReactEditText editText) {
        editText.addTextChangedListener(new ReactTextInputTextWatcher(reactContext, editText));
        editText.setOnFocusChangeListener(new View.OnFocusChangeListener(){

            public void onFocusChange(View v, boolean hasFocus) {
                EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
                if (hasFocus) {
                    eventDispatcher.dispatchEvent(new ReactTextInputFocusEvent(editText.getId(), SystemClock.uptimeMillis()));
                } else {
                    eventDispatcher.dispatchEvent(new ReactTextInputBlurEvent(editText.getId(), SystemClock.uptimeMillis()));
                    eventDispatcher.dispatchEvent(new ReactTextInputEndEditingEvent(editText.getId(), SystemClock.uptimeMillis(), editText.getText().toString()));
                }
            }
        });
        editText.setOnEditorActionListener(new TextView.OnEditorActionListener(){

            public boolean onEditorAction(TextView v, int actionId, KeyEvent keyEvent) {
                if ((actionId & 0xFF) > 0 || actionId == 0) {
                    EventDispatcher eventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
                    eventDispatcher.dispatchEvent(new ReactTextInputSubmitEditingEvent(editText.getId(), SystemClock.uptimeMillis(), editText.getText().toString()));
                }
                return false;
            }
        });
    }

    @Override
    @Nullable
    public Map getExportedViewConstants() {
        return MapBuilder.of("TextAlign", MapBuilder.of("start", 0x800003, "center", 1, "end", 0x800005), "TextAlignVertical", MapBuilder.of("top", 48, "center", 16, "bottom", 80));
    }

    private class ReactTextInputTextWatcher
    implements TextWatcher {
        private EventDispatcher mEventDispatcher;
        private ReactEditText mEditText;
        private String mPreviousText;

        public ReactTextInputTextWatcher(ReactContext reactContext, ReactEditText editText) {
            this.mEventDispatcher = reactContext.getNativeModule(UIManagerModule.class).getEventDispatcher();
            this.mEditText = editText;
            this.mPreviousText = null;
        }

        public void beforeTextChanged(CharSequence s, int start, int count, int after) {
            this.mPreviousText = s.toString();
        }

        public void onTextChanged(CharSequence s, int start, int before, int count) {
            if (count > 0 || before > 0) {
                Assertions.assertNotNull((Object)this.mPreviousText);
                int contentWidth = this.mEditText.getWidth();
                int contentHeight = this.mEditText.getHeight();
                if (this.mEditText.getLayout() != null) {
                    contentWidth = this.mEditText.getCompoundPaddingLeft() + this.mEditText.getLayout().getWidth() + this.mEditText.getCompoundPaddingRight();
                    contentHeight = this.mEditText.getCompoundPaddingTop() + this.mEditText.getLayout().getHeight() + this.mEditText.getCompoundPaddingTop();
                }
                this.mEventDispatcher.dispatchEvent(new ReactTextChangedEvent(this.mEditText.getId(), SystemClock.uptimeMillis(), s.toString(), (int)PixelUtil.toDIPFromPixel(contentWidth), (int)PixelUtil.toDIPFromPixel(contentHeight), this.mEditText.incrementAndGetEventCounter()));
                this.mEventDispatcher.dispatchEvent(new ReactTextInputEvent(this.mEditText.getId(), SystemClock.uptimeMillis(), count > 0 ? s.toString().substring(start, start + count) : "", before > 0 ? this.mPreviousText.substring(start, start + before) : "", start, count > 0 ? start + count - 1 : start + before));
            }
        }

        public void afterTextChanged(Editable s) {
        }
    }
}

