/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.content.Context;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.common.MapBuilder;
import com.facebook.react.uimanager.CatalystStylesDiffMap;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIProp;
import com.facebook.react.uimanager.ViewGroupManager;
import com.facebook.react.views.scroll.ReactScrollView;
import com.facebook.react.views.scroll.ReactScrollViewCommandHelper;
import com.facebook.react.views.view.ReactClippingViewGroupHelper;
import java.util.Map;
import javax.annotation.Nullable;

public class ReactScrollViewManager
extends ViewGroupManager<ReactScrollView>
implements ReactScrollViewCommandHelper.ScrollCommandHandler<ReactScrollView> {
    private static final String REACT_CLASS = "RCTScrollView";
    @UIProp(value=UIProp.Type.BOOLEAN)
    public static final String PROP_SHOWS_VERTICAL_SCROLL_INDICATOR = "showsVerticalScrollIndicator";
    @UIProp(value=UIProp.Type.BOOLEAN)
    public static final String PROP_SHOWS_HORIZONTAL_SCROLL_INDICATOR = "showsHorizontalScrollIndicator";

    @Override
    public String getName() {
        return REACT_CLASS;
    }

    @Override
    public ReactScrollView createViewInstance(ThemedReactContext context) {
        return new ReactScrollView((Context)context);
    }

    @Override
    public void updateView(ReactScrollView scrollView, CatalystStylesDiffMap props) {
        super.updateView(scrollView, props);
        if (props.hasKey(PROP_SHOWS_VERTICAL_SCROLL_INDICATOR)) {
            scrollView.setVerticalScrollBarEnabled(props.getBoolean(PROP_SHOWS_VERTICAL_SCROLL_INDICATOR, true));
        }
        if (props.hasKey(PROP_SHOWS_HORIZONTAL_SCROLL_INDICATOR)) {
            scrollView.setHorizontalScrollBarEnabled(props.getBoolean(PROP_SHOWS_HORIZONTAL_SCROLL_INDICATOR, true));
        }
        ReactClippingViewGroupHelper.applyRemoveClippedSubviewsProperty(scrollView, props);
    }

    @Override
    @Nullable
    public Map<String, Integer> getCommandsMap() {
        return ReactScrollViewCommandHelper.getCommandsMap();
    }

    @Override
    public void receiveCommand(ReactScrollView scrollView, int commandId, @Nullable ReadableArray args) {
        ReactScrollViewCommandHelper.receiveCommand(this, scrollView, commandId, args);
    }

    @Override
    public void scrollTo(ReactScrollView scrollView, ReactScrollViewCommandHelper.ScrollToCommandData data) {
        scrollView.smoothScrollTo(data.mDestX, data.mDestY);
    }

    @Override
    public void scrollWithoutAnimationTo(ReactScrollView scrollView, ReactScrollViewCommandHelper.ScrollToCommandData data) {
        scrollView.scrollTo(data.mDestX, data.mDestY);
    }

    @Override
    @Nullable
    public Map getExportedCustomDirectEventTypeConstants() {
        return MapBuilder.builder().put("topScroll", MapBuilder.of("registrationName", "onScroll")).put("topScrollBeginDrag", MapBuilder.of("registrationName", "onScrollBeginDrag")).put("topScrollEndDrag", MapBuilder.of("registrationName", "onScrollEndDrag")).put("topScrollAnimationEnd", MapBuilder.of("registrationName", "onScrollAnimationEnd")).put("topMomentumScrollBegin", MapBuilder.of("registrationName", "onMomentumScrollBegin")).put("topMomentumScrollEnd", MapBuilder.of("registrationName", "onMomentumScrollEnd")).build();
    }
}

