/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.devsupport;

import android.app.Dialog;
import android.content.Context;
import android.graphics.Typeface;
import android.text.method.MovementMethod;
import android.text.method.ScrollingMovementMethod;
import android.view.KeyEvent;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.facebook.react.R;
import com.facebook.react.devsupport.DevSupportManager;

class RedBoxDialog
extends Dialog {
    private final DevSupportManager mDevSupportManager;
    private TextView mTitle;
    private TextView mDetails;
    private Button mReloadJs;
    private int mCookie = 0;

    protected RedBoxDialog(Context context, DevSupportManager devSupportManager) {
        super(context, R.style.Theme_Catalyst_RedBox);
        this.requestWindowFeature(1);
        this.setContentView(R.layout.redbox_view);
        this.mDevSupportManager = devSupportManager;
        this.mTitle = (TextView)this.findViewById(R.id.catalyst_redbox_title);
        this.mDetails = (TextView)this.findViewById(R.id.catalyst_redbox_details);
        this.mDetails.setTypeface(Typeface.MONOSPACE);
        this.mDetails.setHorizontallyScrolling(true);
        this.mDetails.setMovementMethod((MovementMethod)new ScrollingMovementMethod());
        this.mReloadJs = (Button)this.findViewById(R.id.catalyst_redbox_reloadjs);
        this.mReloadJs.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                RedBoxDialog.this.mDevSupportManager.handleReloadJS();
            }
        });
    }

    public void setTitle(String title) {
        this.mTitle.setText((CharSequence)title);
    }

    public void setDetails(CharSequence details) {
        this.mDetails.setText(details);
    }

    public void setErrorCookie(int cookie) {
        this.mCookie = cookie;
    }

    public int getErrorCookie() {
        return this.mCookie;
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (keyCode == 82) {
            this.mDevSupportManager.showDevOptionsDialog();
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }
}

