/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.bridge;

import android.content.res.AssetManager;
import com.facebook.react.bridge.ReactBridge;

public abstract class JSBundleLoader {
    public static JSBundleLoader createAssetLoader(final AssetManager assetManager, final String assetFileName) {
        return new JSBundleLoader(){

            @Override
            public void loadScript(ReactBridge bridge) {
                bridge.loadScriptFromAssets(assetManager, assetFileName);
            }
        };
    }

    public static JSBundleLoader createCachedBundleFromNetworkLoader(final String sourceURL, final String cachedFileLocation) {
        return new JSBundleLoader(){

            @Override
            public void loadScript(ReactBridge bridge) {
                bridge.loadScriptFromNetworkCached(sourceURL, cachedFileLocation);
            }
        };
    }

    public static JSBundleLoader createRemoteDebuggerBundleLoader(final String sourceURL) {
        return new JSBundleLoader(){

            @Override
            public void loadScript(ReactBridge bridge) {
                bridge.loadScriptFromNetworkCached(sourceURL, null);
            }
        };
    }

    public abstract void loadScript(ReactBridge var1);
}

