/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.modules.storage;

import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteStatement;
import com.facebook.common.logging.FLog;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.Callback;
import com.facebook.react.bridge.GuardedAsyncTask;
import com.facebook.react.bridge.ReactApplicationContext;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.ReactContextBaseJavaModule;
import com.facebook.react.bridge.ReactMethod;
import com.facebook.react.bridge.ReadableArray;
import com.facebook.react.bridge.WritableArray;
import com.facebook.react.common.SetBuilder;
import com.facebook.react.modules.common.ModuleDataCleaner;
import com.facebook.react.modules.storage.AsyncLocalStorageUtil;
import com.facebook.react.modules.storage.AsyncStorageErrorUtil;
import com.facebook.react.modules.storage.CatalystSQLiteOpenHelper;
import java.util.HashSet;
import javax.annotation.Nullable;

public final class AsyncStorageModule
extends ReactContextBaseJavaModule
implements ModuleDataCleaner.Cleanable {
    @Nullable
    private SQLiteDatabase mDb;
    private boolean mShuttingDown = false;

    public AsyncStorageModule(ReactApplicationContext reactContext) {
        super(reactContext);
    }

    @Override
    public String getName() {
        return "AsyncSQLiteDBStorage";
    }

    @Override
    public void initialize() {
        super.initialize();
        this.mShuttingDown = false;
    }

    @Override
    public void onCatalystInstanceDestroy() {
        this.mShuttingDown = true;
        if (this.mDb != null && this.mDb.isOpen()) {
            this.mDb.close();
            this.mDb = null;
        }
    }

    @Override
    public void clearSensitiveData() {
        this.clear(new Callback(){

            @Override
            public void invoke(Object ... args) {
                if (args.length > 0) {
                    throw new RuntimeException("Clearing AsyncLocalStorage failed: " + args[0]);
                }
                FLog.d((String)"React", (String)"Cleaned AsyncLocalStorage.");
            }
        });
    }

    @ReactMethod
    public void multiGet(final ReadableArray keys, final Callback callback) {
        if (keys == null) {
            callback.invoke(AsyncStorageErrorUtil.getInvalidKeyError(null), null);
            return;
        }
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doInBackgroundGuarded(Void ... params) {
                if (!AsyncStorageModule.this.ensureDatabase()) {
                    callback.invoke(AsyncStorageErrorUtil.getDBError(null), null);
                    return;
                }
                String[] columns = new String[]{"key", "value"};
                HashSet<String> keysRemaining = SetBuilder.newHashSet();
                WritableArray data = Arguments.createArray();
                try (Cursor cursor = ((SQLiteDatabase)Assertions.assertNotNull((Object)AsyncStorageModule.this.mDb)).query("catalystLocalStorage", columns, AsyncLocalStorageUtil.buildKeySelection(keys.size()), AsyncLocalStorageUtil.buildKeySelectionArgs(keys), null, null, null);){
                    if (cursor.getCount() != keys.size()) {
                        for (int keyIndex = 0; keyIndex < keys.size(); ++keyIndex) {
                            keysRemaining.add(keys.getString(keyIndex));
                        }
                    }
                    if (cursor.moveToFirst()) {
                        do {
                            WritableArray row = Arguments.createArray();
                            row.pushString(cursor.getString(0));
                            row.pushString(cursor.getString(1));
                            data.pushArray(row);
                            keysRemaining.remove(cursor.getString(0));
                        } while (cursor.moveToNext());
                    }
                }
                for (String key : keysRemaining) {
                    WritableArray row = Arguments.createArray();
                    row.pushString(key);
                    row.pushNull();
                    data.pushArray(row);
                }
                keysRemaining.clear();
                callback.invoke(null, data);
            }
        }.execute(new Void[0]);
    }

    @ReactMethod
    public void multiSet(final ReadableArray keyValueArray, final Callback callback) {
        if (keyValueArray.size() == 0) {
            callback.invoke(AsyncStorageErrorUtil.getInvalidKeyError(null));
            return;
        }
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doInBackgroundGuarded(Void ... params) {
                if (!AsyncStorageModule.this.ensureDatabase()) {
                    callback.invoke(AsyncStorageErrorUtil.getDBError(null));
                    return;
                }
                String sql = "INSERT OR REPLACE INTO catalystLocalStorage VALUES (?, ?);";
                SQLiteStatement statement = ((SQLiteDatabase)Assertions.assertNotNull((Object)AsyncStorageModule.this.mDb)).compileStatement(sql);
                AsyncStorageModule.this.mDb.beginTransaction();
                try {
                    for (int idx = 0; idx < keyValueArray.size(); ++idx) {
                        if (keyValueArray.getArray(idx).size() != 2) {
                            callback.invoke(AsyncStorageErrorUtil.getInvalidValueError(null));
                            return;
                        }
                        if (keyValueArray.getArray(idx).getString(0) == null) {
                            callback.invoke(AsyncStorageErrorUtil.getInvalidKeyError(null));
                            return;
                        }
                        if (keyValueArray.getArray(idx).getString(1) == null) {
                            callback.invoke(AsyncStorageErrorUtil.getInvalidValueError(null));
                            return;
                        }
                        statement.clearBindings();
                        statement.bindString(1, keyValueArray.getArray(idx).getString(0));
                        statement.bindString(2, keyValueArray.getArray(idx).getString(1));
                        statement.execute();
                    }
                    AsyncStorageModule.this.mDb.setTransactionSuccessful();
                }
                catch (Exception e) {
                    FLog.w((String)"React", (String)"Exception in database multiSet ", (Throwable)e);
                    callback.invoke(AsyncStorageErrorUtil.getError(null, e.getMessage()));
                }
                finally {
                    AsyncStorageModule.this.mDb.endTransaction();
                }
                callback.invoke(new Object[0]);
            }
        }.execute(new Void[0]);
    }

    @ReactMethod
    public void multiRemove(final ReadableArray keys, final Callback callback) {
        if (keys.size() == 0) {
            callback.invoke(AsyncStorageErrorUtil.getInvalidKeyError(null));
            return;
        }
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            protected void doInBackgroundGuarded(Void ... params) {
                if (!AsyncStorageModule.this.ensureDatabase()) {
                    callback.invoke(AsyncStorageErrorUtil.getDBError(null));
                    return;
                }
                try {
                    ((SQLiteDatabase)Assertions.assertNotNull((Object)AsyncStorageModule.this.mDb)).delete("catalystLocalStorage", AsyncLocalStorageUtil.buildKeySelection(keys.size()), AsyncLocalStorageUtil.buildKeySelectionArgs(keys));
                }
                catch (Exception e) {
                    FLog.w((String)"React", (String)"Exception in database multiRemove ", (Throwable)e);
                    callback.invoke(AsyncStorageErrorUtil.getError(null, e.getMessage()));
                }
                callback.invoke(new Object[0]);
            }
        }.execute(new Void[0]);
    }

    @ReactMethod
    public void multiMerge(final ReadableArray keyValueArray, final Callback callback) {
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doInBackgroundGuarded(Void ... params) {
                if (!AsyncStorageModule.this.ensureDatabase()) {
                    callback.invoke(AsyncStorageErrorUtil.getDBError(null));
                    return;
                }
                ((SQLiteDatabase)Assertions.assertNotNull((Object)AsyncStorageModule.this.mDb)).beginTransaction();
                try {
                    for (int idx = 0; idx < keyValueArray.size(); ++idx) {
                        if (keyValueArray.getArray(idx).size() != 2) {
                            callback.invoke(AsyncStorageErrorUtil.getInvalidValueError(null));
                            return;
                        }
                        if (keyValueArray.getArray(idx).getString(0) == null) {
                            callback.invoke(AsyncStorageErrorUtil.getInvalidKeyError(null));
                            return;
                        }
                        if (keyValueArray.getArray(idx).getString(1) == null) {
                            callback.invoke(AsyncStorageErrorUtil.getInvalidValueError(null));
                            return;
                        }
                        if (AsyncLocalStorageUtil.mergeImpl(AsyncStorageModule.this.mDb, keyValueArray.getArray(idx).getString(0), keyValueArray.getArray(idx).getString(1))) continue;
                        callback.invoke(AsyncStorageErrorUtil.getDBError(null));
                        return;
                    }
                    AsyncStorageModule.this.mDb.setTransactionSuccessful();
                }
                catch (Exception e) {
                    FLog.w((String)"React", (String)e.getMessage(), (Throwable)e);
                    callback.invoke(AsyncStorageErrorUtil.getError(null, e.getMessage()));
                }
                finally {
                    AsyncStorageModule.this.mDb.endTransaction();
                }
                callback.invoke(new Object[0]);
            }
        }.execute(new Void[0]);
    }

    @ReactMethod
    public void clear(final Callback callback) {
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            protected void doInBackgroundGuarded(Void ... params) {
                if (!AsyncStorageModule.this.ensureDatabase()) {
                    callback.invoke(AsyncStorageErrorUtil.getDBError(null));
                    return;
                }
                try {
                    ((SQLiteDatabase)Assertions.assertNotNull((Object)AsyncStorageModule.this.mDb)).delete("catalystLocalStorage", null, null);
                }
                catch (Exception e) {
                    FLog.w((String)"React", (String)"Exception in database clear ", (Throwable)e);
                    callback.invoke(AsyncStorageErrorUtil.getError(null, e.getMessage()));
                }
                callback.invoke(new Object[0]);
            }
        }.execute(new Void[0]);
    }

    @ReactMethod
    public void getAllKeys(final Callback callback) {
        new GuardedAsyncTask<Void, Void>((ReactContext)this.getReactApplicationContext()){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void doInBackgroundGuarded(Void ... params) {
                if (!AsyncStorageModule.this.ensureDatabase()) {
                    callback.invoke(AsyncStorageErrorUtil.getDBError(null), null);
                    return;
                }
                WritableArray data = Arguments.createArray();
                String[] columns = new String[]{"key"};
                try (Cursor cursor = ((SQLiteDatabase)Assertions.assertNotNull((Object)AsyncStorageModule.this.mDb)).query("catalystLocalStorage", columns, null, null, null, null, null);){
                    if (cursor.moveToFirst()) {
                        do {
                            data.pushString(cursor.getString(0));
                        } while (cursor.moveToNext());
                    }
                }
                callback.invoke(null, data);
            }
        }.execute(new Void[0]);
    }

    private boolean ensureDatabase() {
        if (this.mShuttingDown) {
            return false;
        }
        if (this.mDb != null && this.mDb.isOpen()) {
            return true;
        }
        this.mDb = this.initializeDatabase();
        return true;
    }

    private SQLiteDatabase initializeDatabase() {
        CatalystSQLiteOpenHelper helperForDb = new CatalystSQLiteOpenHelper((Context)this.getReactApplicationContext());
        return helperForDb.getWritableDatabase();
    }
}

