/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.textinput;

import android.text.Editable;
import android.view.KeyEvent;
import android.view.View;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputConnectionWrapper;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.uimanager.UIManagerHelper;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.textinput.ReactEditText;
import com.facebook.react.views.textinput.ReactTextInputKeyPressEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0010\u001a\u00020\rH\u0016J\b\u0010\u0011\u001a\u00020\rH\u0016J\u0018\u0010\u0012\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0018\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u0016H\u0016J\u0010\u0010\u001b\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000fH\u0002J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u000fH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/facebook/react/views/textinput/ReactEditTextInputConnectionWrapper;", "Landroid/view/inputmethod/InputConnectionWrapper;", "target", "Landroid/view/inputmethod/InputConnection;", "reactContext", "Lcom/facebook/react/bridge/ReactContext;", "editText", "Lcom/facebook/react/views/textinput/ReactEditText;", "eventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "<init>", "(Landroid/view/inputmethod/InputConnection;Lcom/facebook/react/bridge/ReactContext;Lcom/facebook/react/views/textinput/ReactEditText;Lcom/facebook/react/uimanager/events/EventDispatcher;)V", "isBatchEdit", "", "key", "", "beginBatchEdit", "endBatchEdit", "setComposingText", "text", "", "newCursorPosition", "", "commitText", "deleteSurroundingText", "beforeLength", "afterLength", "sendKeyEvent", "event", "Landroid/view/KeyEvent;", "dispatchKeyEventOrEnqueue", "", "inputKey", "dispatchKeyEvent", "Companion", "ReactAndroid_release"})
public final class ReactEditTextInputConnectionWrapper
extends InputConnectionWrapper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ReactEditText editText;
    @NotNull
    private final EventDispatcher eventDispatcher;
    private boolean isBatchEdit;
    @Nullable
    private String key;
    @NotNull
    public static final String NEWLINE_RAW_VALUE = "\n";
    @NotNull
    public static final String BACKSPACE_KEY_VALUE = "Backspace";
    @NotNull
    public static final String ENTER_KEY_VALUE = "Enter";

    public ReactEditTextInputConnectionWrapper(@NotNull InputConnection target, @NotNull ReactContext reactContext, @NotNull ReactEditText editText, @NotNull EventDispatcher eventDispatcher) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)((Object)reactContext), (String)"reactContext");
        Intrinsics.checkNotNullParameter((Object)((Object)editText), (String)"editText");
        Intrinsics.checkNotNullParameter((Object)eventDispatcher, (String)"eventDispatcher");
        super(target, false);
        this.editText = editText;
        this.eventDispatcher = eventDispatcher;
    }

    public boolean beginBatchEdit() {
        this.isBatchEdit = true;
        return super.beginBatchEdit();
    }

    public boolean endBatchEdit() {
        block0: {
            this.isBatchEdit = false;
            String string2 = this.key;
            if (string2 == null) break block0;
            String k = string2;
            boolean bl = false;
            this.dispatchKeyEvent(k);
            this.key = null;
        }
        return super.endBatchEdit();
    }

    public boolean setComposingText(@NotNull CharSequence text, int newCursorPosition) {
        String string2;
        boolean cursorMovedBackwardsOrAtBeginningOfInput;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        int previousSelectionStart = this.editText.getSelectionStart();
        int previousSelectionEnd = this.editText.getSelectionEnd();
        boolean consumed = super.setComposingText(text, newCursorPosition);
        int currentSelectionStart = this.editText.getSelectionStart();
        boolean noPreviousSelection = previousSelectionStart == previousSelectionEnd;
        boolean cursorDidNotMove = currentSelectionStart == previousSelectionStart;
        boolean bl = cursorMovedBackwardsOrAtBeginningOfInput = currentSelectionStart < previousSelectionStart || currentSelectionStart <= 0;
        if (cursorMovedBackwardsOrAtBeginningOfInput || !noPreviousSelection && cursorDidNotMove) {
            string2 = BACKSPACE_KEY_VALUE;
        } else {
            Editable editable = this.editText.getText();
            string2 = String.valueOf(editable != null ? Character.valueOf(editable.charAt(currentSelectionStart - 1)) : null);
        }
        String inputKey = string2;
        this.dispatchKeyEventOrEnqueue(inputKey);
        return consumed;
    }

    public boolean commitText(@NotNull CharSequence text, int newCursorPosition) {
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        String inputKey = ((Object)text).toString();
        if (inputKey.length() <= 2) {
            if (((CharSequence)inputKey).length() == 0) {
                inputKey = BACKSPACE_KEY_VALUE;
            }
            this.dispatchKeyEventOrEnqueue(inputKey);
        }
        return super.commitText(text, newCursorPosition);
    }

    public boolean deleteSurroundingText(int beforeLength, int afterLength) {
        this.dispatchKeyEvent(BACKSPACE_KEY_VALUE);
        return super.deleteSurroundingText(beforeLength, afterLength);
    }

    public boolean sendKeyEvent(@NotNull KeyEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (event.getAction() == 0) {
            int n = event.getUnicodeChar();
            boolean isNumberKey = 48 <= n ? n < 58 : false;
            switch (event.getKeyCode()) {
                case 67: {
                    this.dispatchKeyEvent(BACKSPACE_KEY_VALUE);
                    break;
                }
                case 66: {
                    this.dispatchKeyEvent(ENTER_KEY_VALUE);
                    break;
                }
                default: {
                    if (!isNumberKey) break;
                    this.dispatchKeyEvent(String.valueOf(event.getNumber()));
                }
            }
        }
        return super.sendKeyEvent(event);
    }

    private final void dispatchKeyEventOrEnqueue(String inputKey) {
        if (this.isBatchEdit) {
            this.key = inputKey;
        } else {
            this.dispatchKeyEvent(inputKey);
        }
    }

    private final void dispatchKeyEvent(String inputKey) {
        String resolvedKey = Intrinsics.areEqual((Object)inputKey, (Object)NEWLINE_RAW_VALUE) ? ENTER_KEY_VALUE : inputKey;
        int surfaceId = UIManagerHelper.getSurfaceId((View)this.editText);
        this.eventDispatcher.dispatchEvent(new ReactTextInputKeyPressEvent(surfaceId, this.editText.getId(), resolvedKey));
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/facebook/react/views/textinput/ReactEditTextInputConnectionWrapper$Companion;", "", "<init>", "()V", "NEWLINE_RAW_VALUE", "", "BACKSPACE_KEY_VALUE", "ENTER_KEY_VALUE", "ReactAndroid_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

