/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.modal;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.ViewStructure;
import android.view.Window;
import android.view.WindowInsets;
import android.view.accessibility.AccessibilityEvent;
import android.view.accessibility.AccessibilityNodeInfo;
import android.widget.FrameLayout;
import androidx.activity.ComponentDialog;
import androidx.activity.OnBackPressedCallback;
import androidx.annotation.UiThread;
import androidx.core.view.WindowInsetsCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import androidx.lifecycle.LifecycleOwner;
import com.facebook.common.logging.FLog;
import com.facebook.react.R;
import com.facebook.react.bridge.GuardedRunnable;
import com.facebook.react.bridge.LifecycleEventListener;
import com.facebook.react.bridge.ReactContext;
import com.facebook.react.bridge.UiThreadUtil;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.bridge.WritableNativeMap;
import com.facebook.react.common.annotations.VisibleForTesting;
import com.facebook.react.common.build.ReactBuildConfig;
import com.facebook.react.config.ReactFeatureFlags;
import com.facebook.react.uimanager.DisplayMetricsHolder;
import com.facebook.react.uimanager.JSPointerDispatcher;
import com.facebook.react.uimanager.JSTouchDispatcher;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.RootView;
import com.facebook.react.uimanager.StateWrapper;
import com.facebook.react.uimanager.ThemedReactContext;
import com.facebook.react.uimanager.UIManagerModule;
import com.facebook.react.uimanager.events.EventDispatcher;
import com.facebook.react.views.common.ContextUtils;
import com.facebook.react.views.view.ReactViewGroup;
import com.facebook.react.views.view.WindowUtilKt;
import com.facebook.yoga.annotations.DoNotStrip;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u00a4\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0006\b\u0007\u0018\u0000 s2\u00020\u00012\u00020\u0002:\u0003rstB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0016J0\u0010@\u001a\u00020=2\u0006\u0010A\u001a\u00020\r2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u00020C2\u0006\u0010E\u001a\u00020C2\u0006\u0010F\u001a\u00020CH\u0014J\u0010\u0010G\u001a\u00020=2\u0006\u0010H\u001a\u00020CH\u0016J\b\u0010I\u001a\u00020=H\u0014J\b\u0010J\u001a\u00020=H\u0014J\u001a\u0010K\u001a\u00020=2\b\u0010L\u001a\u0004\u0018\u00010M2\u0006\u0010N\u001a\u00020CH\u0016J\b\u0010O\u001a\u00020CH\u0016J\u0012\u0010P\u001a\u0004\u0018\u00010M2\u0006\u0010N\u001a\u00020CH\u0016J\u0012\u0010Q\u001a\u00020=2\b\u0010L\u001a\u0004\u0018\u00010MH\u0016J\u0010\u0010R\u001a\u00020=2\u0006\u0010N\u001a\u00020CH\u0016J \u0010S\u001a\u00020=2\u0016\u0010T\u001a\u0012\u0012\u0004\u0012\u00020M0Uj\b\u0012\u0004\u0012\u00020M`VH\u0016J\u0010\u0010W\u001a\u00020\r2\u0006\u0010X\u001a\u00020YH\u0016J\u0006\u0010Z\u001a\u00020=J\b\u0010[\u001a\u00020=H\u0002J\b\u0010\\\u001a\u00020=H\u0016J\b\u0010]\u001a\u00020=H\u0016J\b\u0010^\u001a\u00020=H\u0016J\n\u0010_\u001a\u0004\u0018\u00010`H\u0002J\u0012\u0010a\u001a\u00020\r2\b\u0010b\u001a\u0004\u0018\u00010`H\u0002J\u0006\u0010c\u001a\u00020=J\b\u0010g\u001a\u00020=H\u0002J\b\u0010h\u001a\u00020=H\u0002J*\u0010i\u001a\u00020=2\u0006\u0010j\u001a\u00020k2\b\u0010l\u001a\u0004\u0018\u00010m2\u000e\b\u0002\u0010n\u001a\b\u0012\u0004\u0012\u00020C0oH\u0002J\u0010\u0010p\u001a\u00020=2\b\u0010q\u001a\u0004\u0018\u00010$R$\u0010\t\u001a\u0004\u0018\u00010\b2\b\u0010\u0007\u001a\u0004\u0018\u00010\b8G@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001a\u0010\f\u001a\u00020\rX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u001c\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001dR&\u0010\u001e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001f\u0010\u000f\"\u0004\b \u0010\u0011R&\u0010!\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r8F@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010\u000f\"\u0004\b#\u0010\u0011R(\u0010%\u001a\u0004\u0018\u00010$2\b\u0010\u0007\u001a\u0004\u0018\u00010$@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R$\u0010*\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\r@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010\u000f\"\u0004\b,\u0010\u0011R(\u0010-\u001a\u0004\u0018\u00010.2\b\u0010-\u001a\u0004\u0018\u00010.8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b/\u00100\"\u0004\b1\u00102R(\u00103\u001a\u0004\u0018\u0001042\b\u00103\u001a\u0004\u0018\u0001048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u000e\u00109\u001a\u00020:X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010;\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010d\u001a\u00020M8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\be\u0010f\u00a8\u0006u"}, d2={"Lcom/facebook/react/views/modal/ReactModalHostView;", "Landroid/view/ViewGroup;", "Lcom/facebook/react/bridge/LifecycleEventListener;", "context", "Lcom/facebook/react/uimanager/ThemedReactContext;", "<init>", "(Lcom/facebook/react/uimanager/ThemedReactContext;)V", "value", "Landroidx/activity/ComponentDialog;", "dialog", "getDialog", "()Landroidx/activity/ComponentDialog;", "transparent", "", "getTransparent", "()Z", "setTransparent", "(Z)V", "onShowListener", "Landroid/content/DialogInterface$OnShowListener;", "getOnShowListener", "()Landroid/content/DialogInterface$OnShowListener;", "setOnShowListener", "(Landroid/content/DialogInterface$OnShowListener;)V", "onRequestCloseListener", "Lcom/facebook/react/views/modal/ReactModalHostView$OnRequestCloseListener;", "getOnRequestCloseListener", "()Lcom/facebook/react/views/modal/ReactModalHostView$OnRequestCloseListener;", "setOnRequestCloseListener", "(Lcom/facebook/react/views/modal/ReactModalHostView$OnRequestCloseListener;)V", "statusBarTranslucent", "getStatusBarTranslucent", "setStatusBarTranslucent", "navigationBarTranslucent", "getNavigationBarTranslucent", "setNavigationBarTranslucent", "", "animationType", "getAnimationType", "()Ljava/lang/String;", "setAnimationType", "(Ljava/lang/String;)V", "hardwareAccelerated", "getHardwareAccelerated", "setHardwareAccelerated", "stateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "getStateWrapper", "()Lcom/facebook/react/uimanager/StateWrapper;", "setStateWrapper", "(Lcom/facebook/react/uimanager/StateWrapper;)V", "eventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "getEventDispatcher", "()Lcom/facebook/react/uimanager/events/EventDispatcher;", "setEventDispatcher", "(Lcom/facebook/react/uimanager/events/EventDispatcher;)V", "dialogRootViewGroup", "Lcom/facebook/react/views/modal/ReactModalHostView$DialogRootViewGroup;", "createNewDialog", "dispatchProvideStructure", "", "structure", "Landroid/view/ViewStructure;", "onLayout", "changed", "l", "", "t", "r", "b", "setId", "id", "onAttachedToWindow", "onDetachedFromWindow", "addView", "child", "Landroid/view/View;", "index", "getChildCount", "getChildAt", "removeView", "removeViewAt", "addChildrenForAccessibility", "outChildren", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "dispatchPopulateAccessibilityEvent", "event", "Landroid/view/accessibility/AccessibilityEvent;", "onDropInstance", "dismiss", "onHostResume", "onHostPause", "onHostDestroy", "getCurrentActivity", "Landroid/app/Activity;", "isFlagSecureSet", "activity", "showOrUpdate", "contentView", "getContentView", "()Landroid/view/View;", "updateProperties", "updateSystemAppearance", "syncSystemBarsVisibility", "activityRootWindowInsets", "Landroidx/core/view/WindowInsetsCompat;", "dialogWindowInsetsController", "Landroidx/core/view/WindowInsetsControllerCompat;", "types", "", "setDialogRootViewGroupTestId", "testId", "OnRequestCloseListener", "Companion", "DialogRootViewGroup", "ReactAndroid_release"})
@SuppressLint(value={"ViewConstructor"})
@DoNotStrip
@SourceDebugExtension(value={"SMAP\nReactModalHostView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactModalHostView.kt\ncom/facebook/react/views/modal/ReactModalHostView\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,635:1\n1#2:636\n1869#3,2:637\n*S KotlinDebug\n*F\n+ 1 ReactModalHostView.kt\ncom/facebook/react/views/modal/ReactModalHostView\n*L\n454#1:637,2\n*E\n"})
public final class ReactModalHostView
extends ViewGroup
implements LifecycleEventListener {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @Nullable
    private ComponentDialog dialog;
    private boolean transparent;
    @Nullable
    private DialogInterface.OnShowListener onShowListener;
    @Nullable
    private OnRequestCloseListener onRequestCloseListener;
    private boolean statusBarTranslucent;
    private boolean navigationBarTranslucent;
    @Nullable
    private String animationType;
    private boolean hardwareAccelerated;
    @NotNull
    private final DialogRootViewGroup dialogRootViewGroup;
    private boolean createNewDialog;
    @NotNull
    private static final String TAG = "ReactModalHost";
    private static int statusBarHeight;

    public ReactModalHostView(@NotNull ThemedReactContext context) {
        Intrinsics.checkNotNullParameter((Object)((Object)context), (String)"context");
        super((Context)context);
        ReactModalHostView.Companion.initStatusBarHeight(context);
        this.dialogRootViewGroup = new DialogRootViewGroup((Context)context);
    }

    @VisibleForTesting
    @Nullable
    public final ComponentDialog getDialog() {
        return this.dialog;
    }

    public final boolean getTransparent() {
        return this.transparent;
    }

    public final void setTransparent(boolean bl) {
        this.transparent = bl;
    }

    @Nullable
    public final DialogInterface.OnShowListener getOnShowListener() {
        return this.onShowListener;
    }

    public final void setOnShowListener(@Nullable DialogInterface.OnShowListener onShowListener) {
        this.onShowListener = onShowListener;
    }

    @Nullable
    public final OnRequestCloseListener getOnRequestCloseListener() {
        return this.onRequestCloseListener;
    }

    public final void setOnRequestCloseListener(@Nullable OnRequestCloseListener onRequestCloseListener) {
        this.onRequestCloseListener = onRequestCloseListener;
    }

    public final boolean getStatusBarTranslucent() {
        return this.statusBarTranslucent || WindowUtilKt.isEdgeToEdgeFeatureFlagOn();
    }

    public final void setStatusBarTranslucent(boolean value) {
        this.statusBarTranslucent = value;
        this.createNewDialog = this.createNewDialog || !WindowUtilKt.isEdgeToEdgeFeatureFlagOn();
    }

    public final boolean getNavigationBarTranslucent() {
        return this.navigationBarTranslucent || WindowUtilKt.isEdgeToEdgeFeatureFlagOn();
    }

    public final void setNavigationBarTranslucent(boolean value) {
        this.navigationBarTranslucent = value;
        this.createNewDialog = this.createNewDialog || !WindowUtilKt.isEdgeToEdgeFeatureFlagOn();
    }

    @Nullable
    public final String getAnimationType() {
        return this.animationType;
    }

    public final void setAnimationType(@Nullable String value) {
        this.animationType = value;
        this.createNewDialog = true;
    }

    public final boolean getHardwareAccelerated() {
        return this.hardwareAccelerated;
    }

    public final void setHardwareAccelerated(boolean value) {
        this.hardwareAccelerated = value;
        this.createNewDialog = true;
    }

    @Nullable
    public final StateWrapper getStateWrapper() {
        return this.dialogRootViewGroup.getStateWrapper$ReactAndroid_release();
    }

    public final void setStateWrapper(@Nullable StateWrapper stateWrapper) {
        this.dialogRootViewGroup.setStateWrapper$ReactAndroid_release(stateWrapper);
    }

    @Nullable
    public final EventDispatcher getEventDispatcher() {
        return this.dialogRootViewGroup.getEventDispatcher$ReactAndroid_release();
    }

    public final void setEventDispatcher(@Nullable EventDispatcher eventDispatcher) {
        this.dialogRootViewGroup.setEventDispatcher$ReactAndroid_release(eventDispatcher);
    }

    public void dispatchProvideStructure(@NotNull ViewStructure structure) {
        Intrinsics.checkNotNullParameter((Object)structure, (String)"structure");
        this.dialogRootViewGroup.dispatchProvideStructure(structure);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
    }

    public void setId(int id2) {
        super.setId(id2);
        this.dialogRootViewGroup.setId(id2);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        Context context = this.getContext();
        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.ThemedReactContext");
        ((ThemedReactContext)context).addLifecycleEventListener(this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        this.onDropInstance();
    }

    public void addView(@Nullable View child, int index) {
        UiThreadUtil.assertOnUiThread();
        this.dialogRootViewGroup.addView(child, index);
    }

    public int getChildCount() {
        return this.dialogRootViewGroup.getChildCount();
    }

    @Nullable
    public View getChildAt(int index) {
        return this.dialogRootViewGroup.getChildAt(index);
    }

    public void removeView(@Nullable View child) {
        UiThreadUtil.assertOnUiThread();
        if (child != null) {
            this.dialogRootViewGroup.removeView(child);
        }
    }

    public void removeViewAt(int index) {
        UiThreadUtil.assertOnUiThread();
        View child = this.getChildAt(index);
        this.dialogRootViewGroup.removeView(child);
    }

    public void addChildrenForAccessibility(@NotNull ArrayList<View> outChildren) {
        Intrinsics.checkNotNullParameter(outChildren, (String)"outChildren");
    }

    public boolean dispatchPopulateAccessibilityEvent(@NotNull AccessibilityEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        return false;
    }

    public final void onDropInstance() {
        Context context = this.getContext();
        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.ThemedReactContext");
        ((ThemedReactContext)context).removeLifecycleEventListener(this);
        this.dismiss();
    }

    private final void dismiss() {
        block2: {
            Activity dialogContext;
            UiThreadUtil.assertOnUiThread();
            ComponentDialog componentDialog = this.dialog;
            if (componentDialog == null) break block2;
            ComponentDialog nonNullDialog = componentDialog;
            boolean bl = false;
            if (nonNullDialog.isShowing() && ((dialogContext = ContextUtils.findContextOfType(nonNullDialog.getContext(), Activity.class)) == null || !dialogContext.isFinishing())) {
                nonNullDialog.dismiss();
            }
            this.dialog = null;
            this.createNewDialog = true;
            ViewParent viewParent = this.dialogRootViewGroup.getParent();
            ViewGroup viewGroup = viewParent instanceof ViewGroup ? (ViewGroup)viewParent : null;
            if (viewGroup != null) {
                viewGroup.removeViewAt(0);
            }
        }
    }

    @Override
    public void onHostResume() {
        this.showOrUpdate();
    }

    @Override
    public void onHostPause() {
    }

    @Override
    public void onHostDestroy() {
        this.onDropInstance();
    }

    private final Activity getCurrentActivity() {
        Context context = this.getContext();
        Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.ThemedReactContext");
        return ((ThemedReactContext)context).getCurrentActivity();
    }

    private final boolean isFlagSecureSet(Activity activity) {
        if (activity == null) {
            return false;
        }
        int flags = activity.getWindow().getAttributes().flags;
        return (flags & 0x2000) != 0;
    }

    public final void showOrUpdate() {
        boolean flagSecureSet;
        ComponentDialog newDialog;
        Activity currentActivity;
        UiThreadUtil.assertOnUiThread();
        if (!this.createNewDialog) {
            this.updateProperties();
            return;
        }
        this.dismiss();
        this.createNewDialog = false;
        String string2 = this.animationType;
        int theme = Intrinsics.areEqual((Object)string2, (Object)"fade") ? R.style.Theme_FullScreenDialogAnimatedFade : (Intrinsics.areEqual((Object)string2, (Object)"slide") ? R.style.Theme_FullScreenDialogAnimatedSlide : R.style.Theme_FullScreenDialog);
        Activity activity = currentActivity = this.getCurrentActivity();
        Context context = activity != null ? (Context)activity : this.getContext();
        Intrinsics.checkNotNull((Object)context);
        this.dialog = newDialog = new ComponentDialog(context, theme);
        Window window = newDialog.getWindow();
        if (window == null) {
            String string3 = "Required value was null.";
            throw new IllegalArgumentException(string3.toString());
        }
        Window window2 = window;
        window2.setFlags(8, 8);
        newDialog.setContentView(this.getContentView());
        this.updateProperties();
        newDialog.setOnShowListener(this.onShowListener);
        Function0 handleCloseAction = () -> ReactModalHostView.showOrUpdate$lambda$2(this, newDialog);
        OnBackPressedCallback backPressedCallback2 = new OnBackPressedCallback((Function0<Unit>)handleCloseAction){
            final /* synthetic */ Function0<Unit> $handleCloseAction;
            {
                this.$handleCloseAction = $handleCloseAction;
                super(true);
            }

            public void handleOnBackPressed() {
                this.$handleCloseAction.invoke();
            }
        };
        newDialog.getOnBackPressedDispatcher().addCallback((LifecycleOwner)newDialog, backPressedCallback2);
        newDialog.setOnKeyListener(new DialogInterface.OnKeyListener((Function0<Unit>)handleCloseAction, this){
            final /* synthetic */ Function0<Unit> $handleCloseAction;
            final /* synthetic */ ReactModalHostView this$0;
            {
                this.$handleCloseAction = $handleCloseAction;
                this.this$0 = $receiver;
            }

            public boolean onKey(DialogInterface dialog, int keyCode, KeyEvent event) {
                Intrinsics.checkNotNullParameter((Object)dialog, (String)"dialog");
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (event.getAction() == 1) {
                    switch (keyCode) {
                        case 4: 
                        case 111: {
                            this.$handleCloseAction.invoke();
                            return true;
                        }
                    }
                    Context context = this.this$0.getContext();
                    Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.bridge.ReactContext");
                    Activity innerCurrentActivity = ((ReactContext)context).getCurrentActivity();
                    if (innerCurrentActivity != null) {
                        return innerCurrentActivity.onKeyUp(keyCode, event);
                    }
                }
                return false;
            }
        });
        window2.setSoftInputMode(16);
        if (this.hardwareAccelerated) {
            window2.addFlags(0x1000000);
        }
        if (flagSecureSet = this.isFlagSecureSet(currentActivity)) {
            window2.setFlags(8192, 8192);
        }
        Activity activity2 = currentActivity;
        boolean bl = activity2 != null ? !activity2.isFinishing() : false;
        if (bl) {
            newDialog.show();
            this.updateSystemAppearance();
            window2.clearFlags(8);
        }
    }

    private final View getContentView() {
        FrameLayout frameLayout;
        FrameLayout $this$_get_contentView__u24lambda_u243 = frameLayout = new FrameLayout(this.getContext());
        boolean bl = false;
        $this$_get_contentView__u24lambda_u243.addView((View)this.dialogRootViewGroup);
        if (!this.getStatusBarTranslucent()) {
            $this$_get_contentView__u24lambda_u243.setFitsSystemWindows(true);
        }
        return (View)frameLayout;
    }

    private final void updateProperties() {
        ComponentDialog componentDialog = this.dialog;
        if (componentDialog == null) {
            boolean $i$a$-checkNotNull-ReactModalHostView$updateProperties$dialog$22 = false;
            String $i$a$-checkNotNull-ReactModalHostView$updateProperties$dialog$22 = "dialog must exist when we call updateProperties";
            throw new IllegalStateException($i$a$-checkNotNull-ReactModalHostView$updateProperties$dialog$22.toString());
        }
        ComponentDialog dialog = componentDialog;
        Window window = dialog.getWindow();
        if (window == null) {
            boolean $i$a$-checkNotNull-ReactModalHostView$updateProperties$dialogWindow$22 = false;
            String $i$a$-checkNotNull-ReactModalHostView$updateProperties$dialogWindow$22 = "dialog must have window when we call updateProperties";
            throw new IllegalStateException($i$a$-checkNotNull-ReactModalHostView$updateProperties$dialogWindow$22.toString());
        }
        Window dialogWindow = window;
        Activity currentActivity = this.getCurrentActivity();
        if (currentActivity == null || currentActivity.isFinishing() || currentActivity.isDestroyed()) {
            return;
        }
        try {
            Window activityWindow = currentActivity.getWindow();
            if (activityWindow != null) {
                int activityWindowFlags = activityWindow.getAttributes().flags;
                if ((activityWindowFlags & 0x400) != 0) {
                    dialogWindow.addFlags(1024);
                } else {
                    dialogWindow.clearFlags(1024);
                }
            }
            if (this.getNavigationBarTranslucent()) {
                WindowUtilKt.enableEdgeToEdge(dialogWindow);
            } else {
                WindowUtilKt.disableEdgeToEdge(dialogWindow);
                WindowUtilKt.setStatusBarTranslucency(dialogWindow, this.getStatusBarTranslucent());
            }
            if (this.transparent) {
                dialogWindow.clearFlags(2);
            } else {
                dialogWindow.setDimAmount(0.5f);
                dialogWindow.setFlags(2, 2);
            }
        }
        catch (IllegalArgumentException e) {
            Object[] objectArray = new Object[]{e.getMessage()};
            FLog.e((String)TAG, (String)"ReactModalHostView: error while setting window flags: ", (Object[])objectArray);
        }
    }

    private final void updateSystemAppearance() {
        Activity activity = this.getCurrentActivity();
        if (activity == null) {
            return;
        }
        Activity currentActivity = activity;
        ComponentDialog componentDialog = this.dialog;
        if (componentDialog == null) {
            boolean $i$a$-checkNotNull-ReactModalHostView$updateSystemAppearance$dialog$22 = false;
            String $i$a$-checkNotNull-ReactModalHostView$updateSystemAppearance$dialog$22 = "dialog must exist when we call updateProperties";
            throw new IllegalStateException($i$a$-checkNotNull-ReactModalHostView$updateSystemAppearance$dialog$22.toString());
        }
        ComponentDialog dialog = componentDialog;
        Window window = dialog.getWindow();
        if (window == null) {
            boolean $i$a$-checkNotNull-ReactModalHostView$updateSystemAppearance$dialogWindow$22 = false;
            String $i$a$-checkNotNull-ReactModalHostView$updateSystemAppearance$dialogWindow$22 = "dialog must have window when we call updateProperties";
            throw new IllegalStateException($i$a$-checkNotNull-ReactModalHostView$updateSystemAppearance$dialogWindow$22.toString());
        }
        Window dialogWindow = window;
        Window activityWindow = currentActivity.getWindow();
        if (Build.VERSION.SDK_INT > 30) {
            WindowInsetsControllerCompat activityWindowInsetsController = new WindowInsetsControllerCompat(activityWindow, activityWindow.getDecorView());
            WindowInsetsControllerCompat dialogWindowInsetsController = new WindowInsetsControllerCompat(dialogWindow, dialogWindow.getDecorView());
            if (WindowUtilKt.isEdgeToEdgeFeatureFlagOn()) {
                activityWindowInsetsController.setSystemBarsBehavior(2);
                dialogWindowInsetsController.setSystemBarsBehavior(2);
            }
            dialogWindowInsetsController.setAppearanceLightStatusBars(activityWindowInsetsController.isAppearanceLightStatusBars());
            WindowInsets windowInsets = activityWindow.getDecorView().getRootWindowInsets();
            if (windowInsets != null) {
                WindowInsets insets = windowInsets;
                boolean bl = false;
                WindowInsetsCompat windowInsetsCompat = WindowInsetsCompat.toWindowInsetsCompat((WindowInsets)insets);
                Intrinsics.checkNotNullExpressionValue((Object)windowInsetsCompat, (String)"toWindowInsetsCompat(...)");
                WindowInsetsCompat activityRootWindowInsets = windowInsetsCompat;
                ReactModalHostView.syncSystemBarsVisibility$default(this, activityRootWindowInsets, dialogWindowInsetsController, null, 4, null);
            }
        } else {
            dialogWindow.getDecorView().setSystemUiVisibility(activityWindow.getDecorView().getSystemUiVisibility());
        }
    }

    private final void syncSystemBarsVisibility(WindowInsetsCompat activityRootWindowInsets, WindowInsetsControllerCompat dialogWindowInsetsController, List<Integer> types) {
        Iterable $this$forEach$iv = types;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            int type = ((Number)element$iv).intValue();
            boolean bl = false;
            boolean isVisible = activityRootWindowInsets.isVisible(type);
            if (isVisible) {
                WindowInsetsControllerCompat windowInsetsControllerCompat = dialogWindowInsetsController;
                if (windowInsetsControllerCompat != null) {
                    windowInsetsControllerCompat.show(type);
                }
                continue;
            }
            WindowInsetsControllerCompat windowInsetsControllerCompat = dialogWindowInsetsController;
            if (windowInsetsControllerCompat == null) continue;
            windowInsetsControllerCompat.hide(type);
        }
    }

    static /* synthetic */ void syncSystemBarsVisibility$default(ReactModalHostView reactModalHostView, WindowInsetsCompat windowInsetsCompat, WindowInsetsControllerCompat windowInsetsControllerCompat, List list, int n, Object object) {
        if ((n & 4) != 0) {
            Object[] objectArray = new Integer[]{WindowInsetsCompat.Type.statusBars(), WindowInsetsCompat.Type.navigationBars()};
            list = CollectionsKt.listOf((Object[])objectArray);
        }
        reactModalHostView.syncSystemBarsVisibility(windowInsetsCompat, windowInsetsControllerCompat, list);
    }

    public final void setDialogRootViewGroupTestId(@Nullable String testId) {
        this.dialogRootViewGroup.setTag(R.id.react_test_id, testId);
    }

    private static final Unit showOrUpdate$lambda$2(ReactModalHostView this$0, ComponentDialog $newDialog) {
        OnRequestCloseListener onRequestCloseListener = this$0.onRequestCloseListener;
        if (onRequestCloseListener == null) {
            boolean bl = false;
            String string2 = "onRequestClose callback must be set if back key is expected to close the modal";
            throw new IllegalStateException(string2.toString());
        }
        OnRequestCloseListener listener = onRequestCloseListener;
        listener.onRequestClose((DialogInterface)$newDialog);
        return Unit.INSTANCE;
    }

    @JvmStatic
    @DoNotStrip
    private static final long getScreenDisplayMetricsWithoutInsets() {
        return ReactModalHostView.Companion.getScreenDisplayMetricsWithoutInsets();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\b\u0010\f\u001a\u00020\rH\u0003J\u0018\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/facebook/react/views/modal/ReactModalHostView$Companion;", "", "<init>", "()V", "TAG", "", "statusBarHeight", "", "initStatusBarHeight", "", "reactContext", "Lcom/facebook/react/bridge/ReactContext;", "getScreenDisplayMetricsWithoutInsets", "", "encodeFloatsToLong", "width", "", "height", "ReactAndroid_release"})
    private static final class Companion {
        private Companion() {
        }

        private final void initStatusBarHeight(ReactContext reactContext) {
            statusBarHeight = DisplayMetricsHolder.INSTANCE.getStatusBarHeightPx$ReactAndroid_release(reactContext.getCurrentActivity());
        }

        @JvmStatic
        @DoNotStrip
        private final long getScreenDisplayMetricsWithoutInsets() {
            DisplayMetrics displayMetrics = DisplayMetricsHolder.getScreenDisplayMetrics();
            return this.encodeFloatsToLong(PixelUtil.INSTANCE.pxToDp((float)displayMetrics.widthPixels), PixelUtil.INSTANCE.pxToDp((float)(displayMetrics.heightPixels - statusBarHeight)));
        }

        private final long encodeFloatsToLong(float width, float height) {
            return (long)Float.floatToRawIntBits(width) << 32 | (long)Float.floatToRawIntBits(height);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u0003\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0016J(\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u00142\u0006\u0010$\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\u0014H\u0014J\u0018\u0010'\u001a\u00020\u001f2\u0006\u0010(\u001a\u00020\u00142\u0006\u0010)\u001a\u00020\u0014H\u0007J\u0010\u0010*\u001a\u00020\u001f2\u0006\u0010+\u001a\u00020,H\u0016J\u0010\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00101\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0017J\u0010\u00102\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u0010\u00103\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0016J\u001a\u00104\u001a\u00020\u001f2\b\u00105\u001a\u0004\u0018\u0001062\u0006\u00107\u001a\u000200H\u0016J\u0018\u00108\u001a\u00020\u001f2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000200H\u0016J\u0010\u00109\u001a\u00020\u001f2\u0006\u0010:\u001a\u00020.H\u0016R\u001c\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001c\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u001b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006;"}, d2={"Lcom/facebook/react/views/modal/ReactModalHostView$DialogRootViewGroup;", "Lcom/facebook/react/views/view/ReactViewGroup;", "Lcom/facebook/react/uimanager/RootView;", "context", "Landroid/content/Context;", "<init>", "(Landroid/content/Context;)V", "stateWrapper", "Lcom/facebook/react/uimanager/StateWrapper;", "getStateWrapper$ReactAndroid_release", "()Lcom/facebook/react/uimanager/StateWrapper;", "setStateWrapper$ReactAndroid_release", "(Lcom/facebook/react/uimanager/StateWrapper;)V", "eventDispatcher", "Lcom/facebook/react/uimanager/events/EventDispatcher;", "getEventDispatcher$ReactAndroid_release", "()Lcom/facebook/react/uimanager/events/EventDispatcher;", "setEventDispatcher$ReactAndroid_release", "(Lcom/facebook/react/uimanager/events/EventDispatcher;)V", "viewWidth", "", "viewHeight", "jSTouchDispatcher", "Lcom/facebook/react/uimanager/JSTouchDispatcher;", "jSPointerDispatcher", "Lcom/facebook/react/uimanager/JSPointerDispatcher;", "reactContext", "Lcom/facebook/react/uimanager/ThemedReactContext;", "getReactContext", "()Lcom/facebook/react/uimanager/ThemedReactContext;", "onInitializeAccessibilityNodeInfo", "", "info", "Landroid/view/accessibility/AccessibilityNodeInfo;", "onSizeChanged", "w", "h", "oldw", "oldh", "updateState", "width", "height", "handleException", "t", "", "onInterceptTouchEvent", "", "event", "Landroid/view/MotionEvent;", "onTouchEvent", "onInterceptHoverEvent", "onHoverEvent", "onChildStartedNativeGesture", "childView", "Landroid/view/View;", "ev", "onChildEndedNativeGesture", "requestDisallowInterceptTouchEvent", "disallowIntercept", "ReactAndroid_release"})
    @SourceDebugExtension(value={"SMAP\nReactModalHostView.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ReactModalHostView.kt\ncom/facebook/react/views/modal/ReactModalHostView$DialogRootViewGroup\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,635:1\n1#2:636\n*E\n"})
    public static final class DialogRootViewGroup
    extends ReactViewGroup
    implements RootView {
        @Nullable
        private StateWrapper stateWrapper;
        @Nullable
        private EventDispatcher eventDispatcher;
        private int viewWidth;
        private int viewHeight;
        @NotNull
        private final JSTouchDispatcher jSTouchDispatcher;
        @Nullable
        private JSPointerDispatcher jSPointerDispatcher;

        public DialogRootViewGroup(@NotNull Context context) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            super(context);
            this.jSTouchDispatcher = new JSTouchDispatcher(this);
            if (ReactFeatureFlags.dispatchPointerEvents) {
                this.jSPointerDispatcher = new JSPointerDispatcher(this);
            }
        }

        @Nullable
        public final StateWrapper getStateWrapper$ReactAndroid_release() {
            return this.stateWrapper;
        }

        public final void setStateWrapper$ReactAndroid_release(@Nullable StateWrapper stateWrapper) {
            this.stateWrapper = stateWrapper;
        }

        @Nullable
        public final EventDispatcher getEventDispatcher$ReactAndroid_release() {
            return this.eventDispatcher;
        }

        public final void setEventDispatcher$ReactAndroid_release(@Nullable EventDispatcher eventDispatcher) {
            this.eventDispatcher = eventDispatcher;
        }

        private final ThemedReactContext getReactContext() {
            Context context = this.getContext();
            Intrinsics.checkNotNull((Object)context, (String)"null cannot be cast to non-null type com.facebook.react.uimanager.ThemedReactContext");
            return (ThemedReactContext)context;
        }

        public void onInitializeAccessibilityNodeInfo(@NotNull AccessibilityNodeInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            super.onInitializeAccessibilityNodeInfo(info);
            String testId = (String)this.getTag(R.id.react_test_id);
            if (testId != null) {
                info.setViewIdResourceName(testId);
            }
        }

        @Override
        protected void onSizeChanged(int w, int h, int oldw, int oldh) {
            super.onSizeChanged(w, h, oldw, oldh);
            this.viewWidth = w;
            this.viewHeight = h;
            this.updateState(this.viewWidth, this.viewHeight);
        }

        @UiThread
        public final void updateState(int width, int height) {
            float realWidth = PixelUtil.INSTANCE.pxToDp((float)width);
            float realHeight = PixelUtil.INSTANCE.pxToDp((float)height);
            StateWrapper sw = this.stateWrapper;
            if (sw != null) {
                WritableMap newStateData = new WritableNativeMap();
                newStateData.putDouble("screenWidth", realWidth);
                newStateData.putDouble("screenHeight", realHeight);
                sw.updateState(newStateData);
            } else if (!ReactBuildConfig.UNSTABLE_ENABLE_MINIFY_LEGACY_ARCHITECTURE) {
                DialogRootViewGroup $this$updateState_u24lambda_u240 = this;
                boolean bl = false;
                ThemedReactContext themedReactContext = $this$updateState_u24lambda_u240.getReactContext();
                $this$updateState_u24lambda_u240.getReactContext().runOnNativeModulesQueueThread(new GuardedRunnable($this$updateState_u24lambda_u240, themedReactContext){
                    final /* synthetic */ DialogRootViewGroup $this_run;
                    {
                        this.$this_run = $receiver;
                        super($super_call_param$1);
                    }

                    public void runGuarded() {
                        UIManagerModule uIManagerModule = DialogRootViewGroup.access$getReactContext(this.$this_run).getReactApplicationContext().getNativeModule(UIManagerModule.class);
                        if (uIManagerModule != null) {
                            uIManagerModule.updateNodeSize(this.$this_run.getId(), DialogRootViewGroup.access$getViewWidth$p(this.$this_run), DialogRootViewGroup.access$getViewHeight$p(this.$this_run));
                        }
                    }
                });
            }
        }

        @Override
        public void handleException(@NotNull Throwable t) {
            Intrinsics.checkNotNullParameter((Object)t, (String)"t");
            this.getReactContext().getReactApplicationContext().handleException(new RuntimeException(t));
        }

        @Override
        public boolean onInterceptTouchEvent(@NotNull MotionEvent event) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EventDispatcher eventDispatcher = this.eventDispatcher;
                if (eventDispatcher == null) break block1;
                EventDispatcher eventDispatcher2 = eventDispatcher;
                boolean bl = false;
                this.jSTouchDispatcher.handleTouchEvent(event, eventDispatcher2, this.getReactContext());
                JSPointerDispatcher jSPointerDispatcher = this.jSPointerDispatcher;
                if (jSPointerDispatcher != null) {
                    jSPointerDispatcher.handleMotionEvent(event, eventDispatcher2, true);
                }
            }
            return super.onInterceptTouchEvent(event);
        }

        @Override
        @SuppressLint(value={"ClickableViewAccessibility"})
        public boolean onTouchEvent(@NotNull MotionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            EventDispatcher eventDispatcher = this.eventDispatcher;
            if (eventDispatcher != null) {
                EventDispatcher eventDispatcher2 = eventDispatcher;
                boolean bl = false;
                this.jSTouchDispatcher.handleTouchEvent(event, eventDispatcher2, this.getReactContext());
                JSPointerDispatcher jSPointerDispatcher = this.jSPointerDispatcher;
                if (jSPointerDispatcher != null) {
                    jSPointerDispatcher.handleMotionEvent(event, eventDispatcher2, false);
                }
            }
            super.onTouchEvent(event);
            return true;
        }

        public boolean onInterceptHoverEvent(@NotNull MotionEvent event) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EventDispatcher eventDispatcher = this.eventDispatcher;
                if (eventDispatcher == null) break block1;
                EventDispatcher it = eventDispatcher;
                boolean bl = false;
                JSPointerDispatcher jSPointerDispatcher = this.jSPointerDispatcher;
                if (jSPointerDispatcher != null) {
                    jSPointerDispatcher.handleMotionEvent(event, it, true);
                }
            }
            return super.onHoverEvent(event);
        }

        @Override
        public boolean onHoverEvent(@NotNull MotionEvent event) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                EventDispatcher eventDispatcher = this.eventDispatcher;
                if (eventDispatcher == null) break block1;
                EventDispatcher it = eventDispatcher;
                boolean bl = false;
                JSPointerDispatcher jSPointerDispatcher = this.jSPointerDispatcher;
                if (jSPointerDispatcher != null) {
                    jSPointerDispatcher.handleMotionEvent(event, it, false);
                }
            }
            return super.onHoverEvent(event);
        }

        @Override
        public void onChildStartedNativeGesture(@Nullable View childView, @NotNull MotionEvent ev) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
                EventDispatcher eventDispatcher = this.eventDispatcher;
                if (eventDispatcher == null) break block1;
                EventDispatcher eventDispatcher2 = eventDispatcher;
                boolean bl = false;
                this.jSTouchDispatcher.onChildStartedNativeGesture(ev, eventDispatcher2);
                JSPointerDispatcher jSPointerDispatcher = this.jSPointerDispatcher;
                if (jSPointerDispatcher != null) {
                    jSPointerDispatcher.onChildStartedNativeGesture(childView, ev, eventDispatcher2);
                }
            }
        }

        @Override
        public void onChildEndedNativeGesture(@NotNull View childView, @NotNull MotionEvent ev) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)childView, (String)"childView");
                Intrinsics.checkNotNullParameter((Object)ev, (String)"ev");
                EventDispatcher eventDispatcher = this.eventDispatcher;
                if (eventDispatcher != null) {
                    EventDispatcher it = eventDispatcher;
                    boolean bl = false;
                    this.jSTouchDispatcher.onChildEndedNativeGesture(ev, it);
                }
                JSPointerDispatcher jSPointerDispatcher = this.jSPointerDispatcher;
                if (jSPointerDispatcher == null) break block1;
                jSPointerDispatcher.onChildEndedNativeGesture();
            }
        }

        public void requestDisallowInterceptTouchEvent(boolean disallowIntercept) {
        }

        public static final /* synthetic */ ThemedReactContext access$getReactContext(DialogRootViewGroup $this) {
            return $this.getReactContext();
        }

        public static final /* synthetic */ int access$getViewWidth$p(DialogRootViewGroup $this) {
            return $this.viewWidth;
        }

        public static final /* synthetic */ int access$getViewHeight$p(DialogRootViewGroup $this) {
            return $this.viewHeight;
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00e6\u0080\u0001\u0018\u00002\u00020\u0001J\u0012\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lcom/facebook/react/views/modal/ReactModalHostView$OnRequestCloseListener;", "", "onRequestClose", "", "dialog", "Landroid/content/DialogInterface;", "ReactAndroid_release"})
    public static interface OnRequestCloseListener {
        public void onRequestClose(@Nullable DialogInterface var1);
    }
}

