/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.uimanager;

import android.graphics.Rect;
import android.view.View;
import android.view.ViewParent;
import com.facebook.react.uimanager.ReactClippingViewGroup;
import javax.annotation.concurrent.NotThreadSafe;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/facebook/react/uimanager/ReactClippingViewGroupHelper;", "", "<init>", "()V", "PROP_REMOVE_CLIPPED_SUBVIEWS", "", "helperRect", "Landroid/graphics/Rect;", "calculateClippingRect", "", "view", "Landroid/view/View;", "outputRect", "ReactAndroid_release"})
@NotThreadSafe
public final class ReactClippingViewGroupHelper {
    @NotNull
    public static final ReactClippingViewGroupHelper INSTANCE = new ReactClippingViewGroupHelper();
    @NotNull
    public static final String PROP_REMOVE_CLIPPED_SUBVIEWS = "removeClippedSubviews";
    @NotNull
    private static final Rect helperRect = new Rect();

    private ReactClippingViewGroupHelper() {
    }

    @JvmStatic
    public static final void calculateClippingRect(@NotNull View view, @NotNull Rect outputRect) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)outputRect, (String)"outputRect");
        ViewParent parent = view.getParent();
        if (parent == null) {
            outputRect.setEmpty();
            return;
        }
        if (parent instanceof ReactClippingViewGroup && ((ReactClippingViewGroup)parent).getRemoveClippedSubviews()) {
            ((ReactClippingViewGroup)parent).getClippingRect(helperRect);
            if (!helperRect.intersect(view.getLeft(), view.getTop() + (int)view.getTranslationY(), view.getRight(), view.getBottom() + (int)view.getTranslationY())) {
                outputRect.setEmpty();
                return;
            }
            helperRect.offset(-view.getLeft(), -view.getTop());
            helperRect.offset(-((int)view.getTranslationX()), -((int)view.getTranslationY()));
            helperRect.offset(view.getScrollX(), view.getScrollY());
            outputRect.set(helperRect);
            return;
        }
        view.getDrawingRect(outputRect);
    }
}

