/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.react.views.scroll;

import android.os.SystemClock;
import androidx.core.util.Pools;
import com.facebook.infer.annotation.Assertions;
import com.facebook.react.bridge.Arguments;
import com.facebook.react.bridge.ReactSoftExceptionLogger;
import com.facebook.react.bridge.ReadableMap;
import com.facebook.react.bridge.ReadableMapBuilder;
import com.facebook.react.bridge.WritableMap;
import com.facebook.react.uimanager.PixelUtil;
import com.facebook.react.uimanager.events.Event;
import com.facebook.react.views.scroll.ScrollEventType;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u001d2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u001dB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0016Jb\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\n2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\nH\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001cH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/facebook/react/views/scroll/ScrollEvent;", "Lcom/facebook/react/uimanager/events/Event;", "<init>", "()V", "scrollX", "", "scrollY", "xVelocity", "yVelocity", "contentWidth", "", "contentHeight", "scrollViewWidth", "scrollViewHeight", "scrollEventType", "Lcom/facebook/react/views/scroll/ScrollEventType;", "timestamp", "", "onDispose", "", "init", "surfaceId", "viewTag", "getEventName", "", "canCoalesce", "", "getEventData", "Lcom/facebook/react/bridge/WritableMap;", "Companion", "ReactAndroid_debug"})
@SourceDebugExtension(value={"SMAP\nScrollEvent.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScrollEvent.kt\ncom/facebook/react/views/scroll/ScrollEvent\n+ 2 ReadableMapBuilder.kt\ncom/facebook/react/bridge/ReadableMapBuilderKt\n*L\n1#1,182:1\n30#2,3:183\n30#2,3:186\n30#2,3:189\n30#2,3:192\n30#2,3:195\n*S KotlinDebug\n*F\n+ 1 ScrollEvent.kt\ncom/facebook/react/views/scroll/ScrollEvent\n*L\n78#1:183,3\n85#1:186,3\n90#1:189,3\n95#1:192,3\n100#1:195,3\n*E\n"})
public final class ScrollEvent
extends Event<ScrollEvent> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private float scrollX;
    private float scrollY;
    private float xVelocity;
    private float yVelocity;
    private int contentWidth;
    private int contentHeight;
    private int scrollViewWidth;
    private int scrollViewHeight;
    @Nullable
    private ScrollEventType scrollEventType;
    private long timestamp;
    private static final String TAG = ScrollEvent.class.getSimpleName();
    @NotNull
    private static final Pools.SynchronizedPool<ScrollEvent> EVENTS_POOL = new Pools.SynchronizedPool(3);

    private ScrollEvent() {
    }

    @Override
    public void onDispose() {
        try {
            EVENTS_POOL.release((Object)this);
        }
        catch (IllegalStateException e) {
            String string2 = TAG;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"TAG");
            ReactSoftExceptionLogger.logSoftException(string2, e);
        }
    }

    private final void init(int surfaceId, int viewTag, ScrollEventType scrollEventType, float scrollX, float scrollY, float xVelocity, float yVelocity, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
        long timestampMs = SystemClock.uptimeMillis();
        super.init(surfaceId, viewTag, timestampMs);
        this.scrollEventType = scrollEventType;
        this.scrollX = scrollX;
        this.scrollY = scrollY;
        this.xVelocity = xVelocity;
        this.yVelocity = yVelocity;
        this.contentWidth = contentWidth;
        this.contentHeight = contentHeight;
        this.scrollViewWidth = scrollViewWidth;
        this.scrollViewHeight = scrollViewHeight;
        this.timestamp = timestampMs;
    }

    @Override
    @NotNull
    public String getEventName() {
        Object object = Assertions.assertNotNull((Object)((Object)this.scrollEventType));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"assertNotNull(...)");
        return ScrollEventType.Companion.getJSEventName((ScrollEventType)((Object)object));
    }

    @Override
    public boolean canCoalesce() {
        return this.scrollEventType == ScrollEventType.SCROLL;
    }

    @Override
    @NotNull
    protected WritableMap getEventData() {
        ReadableMapBuilder readableMapBuilder;
        ReadableMapBuilder readableMapBuilder2;
        boolean $i$f$buildReadableMap = false;
        WritableMap writableMap = Arguments.createMap();
        Intrinsics.checkNotNullExpressionValue((Object)writableMap, (String)"createMap(...)");
        WritableMap map$iv = writableMap;
        ReadableMapBuilder $this$getEventData_u24lambda_u240 = readableMapBuilder2 = new ReadableMapBuilder(map$iv);
        boolean bl = false;
        $this$getEventData_u24lambda_u240.put("top", 0.0);
        $this$getEventData_u24lambda_u240.put("bottom", 0.0);
        $this$getEventData_u24lambda_u240.put("left", 0.0);
        $this$getEventData_u24lambda_u240.put("right", 0.0);
        ReadableMap contentInset = map$iv;
        boolean $i$f$buildReadableMap2 = false;
        WritableMap writableMap2 = Arguments.createMap();
        Intrinsics.checkNotNullExpressionValue((Object)writableMap2, (String)"createMap(...)");
        WritableMap map$iv2 = writableMap2;
        ReadableMapBuilder $this$getEventData_u24lambda_u241 = $this$getEventData_u24lambda_u240 = new ReadableMapBuilder(map$iv2);
        boolean bl2 = false;
        $this$getEventData_u24lambda_u241.put("x", PixelUtil.toDIPFromPixel(this.scrollX));
        $this$getEventData_u24lambda_u241.put("y", PixelUtil.toDIPFromPixel(this.scrollY));
        ReadableMap contentOffset = map$iv2;
        boolean $i$f$buildReadableMap3 = false;
        WritableMap writableMap3 = Arguments.createMap();
        Intrinsics.checkNotNullExpressionValue((Object)writableMap3, (String)"createMap(...)");
        WritableMap map$iv3 = writableMap3;
        ReadableMapBuilder $this$getEventData_u24lambda_u242 = $this$getEventData_u24lambda_u241 = new ReadableMapBuilder(map$iv3);
        boolean bl3 = false;
        $this$getEventData_u24lambda_u242.put("width", PixelUtil.toDIPFromPixel(this.contentWidth));
        $this$getEventData_u24lambda_u242.put("height", PixelUtil.toDIPFromPixel(this.contentHeight));
        ReadableMap contentSize = map$iv3;
        boolean $i$f$buildReadableMap4 = false;
        WritableMap writableMap4 = Arguments.createMap();
        Intrinsics.checkNotNullExpressionValue((Object)writableMap4, (String)"createMap(...)");
        WritableMap map$iv4 = writableMap4;
        ReadableMapBuilder $this$getEventData_u24lambda_u243 = $this$getEventData_u24lambda_u242 = new ReadableMapBuilder(map$iv4);
        boolean bl4 = false;
        $this$getEventData_u24lambda_u243.put("width", PixelUtil.toDIPFromPixel(this.scrollViewWidth));
        $this$getEventData_u24lambda_u243.put("height", PixelUtil.toDIPFromPixel(this.scrollViewHeight));
        ReadableMap layoutMeasurement = map$iv4;
        boolean $i$f$buildReadableMap5 = false;
        WritableMap writableMap5 = Arguments.createMap();
        Intrinsics.checkNotNullExpressionValue((Object)writableMap5, (String)"createMap(...)");
        WritableMap map$iv5 = writableMap5;
        ReadableMapBuilder $this$getEventData_u24lambda_u244 = readableMapBuilder = new ReadableMapBuilder(map$iv5);
        boolean bl5 = false;
        $this$getEventData_u24lambda_u244.put("x", PixelUtil.toDIPFromPixel(this.xVelocity));
        $this$getEventData_u24lambda_u244.put("y", PixelUtil.toDIPFromPixel(this.yVelocity));
        ReadableMap velocity = map$iv5;
        WritableMap writableMap6 = Arguments.createMap();
        Intrinsics.checkNotNullExpressionValue((Object)writableMap6, (String)"createMap(...)");
        WritableMap event = writableMap6;
        event.putMap("contentInset", contentInset);
        event.putMap("contentOffset", contentOffset);
        event.putMap("contentSize", contentSize);
        event.putMap("layoutMeasurement", layoutMeasurement);
        event.putMap("velocity", velocity);
        event.putInt("target", this.getViewTag());
        event.putDouble("timestamp", this.timestamp);
        event.putBoolean("responderIgnoreScroll", true);
        return event;
    }

    @JvmStatic
    @NotNull
    public static final ScrollEvent obtain(int surfaceId, int viewTag, @Nullable ScrollEventType scrollEventType, float scrollX, float scrollY, float xVelocity, float yVelocity, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
        return Companion.obtain(surfaceId, viewTag, scrollEventType, scrollX, scrollY, xVelocity, yVelocity, contentWidth, contentHeight, scrollViewWidth, scrollViewHeight);
    }

    @Deprecated(message="Use the obtain version that explicitly takes surfaceId as an argument", replaceWith=@ReplaceWith(expression="obtain(surfaceId, viewTag, scrollEventType, scrollX, scrollY, xVelocity, yVelocity, contentWidth, contentHeight, scrollViewWidth, scrollViewHeight)", imports={}))
    @JvmStatic
    @NotNull
    public static final ScrollEvent obtain(int viewTag, @Nullable ScrollEventType scrollEventType, float scrollX, float scrollY, float xVelocity, float yVelocity, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
        return Companion.obtain(viewTag, scrollEventType, scrollX, scrollY, xVelocity, yVelocity, contentWidth, contentHeight, scrollViewWidth, scrollViewHeight);
    }

    public /* synthetic */ ScrollEvent(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003Jb\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0007JZ\u0010\n\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\fH\u0007R\u0016\u0010\u0004\u001a\n \u0006*\u0004\u0018\u00010\u00050\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/facebook/react/views/scroll/ScrollEvent$Companion;", "", "<init>", "()V", "TAG", "", "kotlin.jvm.PlatformType", "EVENTS_POOL", "Landroidx/core/util/Pools$SynchronizedPool;", "Lcom/facebook/react/views/scroll/ScrollEvent;", "obtain", "surfaceId", "", "viewTag", "scrollEventType", "Lcom/facebook/react/views/scroll/ScrollEventType;", "scrollX", "", "scrollY", "xVelocity", "yVelocity", "contentWidth", "contentHeight", "scrollViewWidth", "scrollViewHeight", "ReactAndroid_debug"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ScrollEvent obtain(int surfaceId, int viewTag, @Nullable ScrollEventType scrollEventType, float scrollX, float scrollY, float xVelocity, float yVelocity, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
            ScrollEvent scrollEvent;
            ScrollEvent scrollEvent2 = (ScrollEvent)EVENTS_POOL.acquire();
            if (scrollEvent2 == null) {
                scrollEvent2 = new ScrollEvent(null);
            }
            ScrollEvent $this$obtain_u24lambda_u240 = scrollEvent = scrollEvent2;
            boolean bl = false;
            $this$obtain_u24lambda_u240.init(surfaceId, viewTag, scrollEventType, scrollX, scrollY, xVelocity, yVelocity, contentWidth, contentHeight, scrollViewWidth, scrollViewHeight);
            return scrollEvent;
        }

        @Deprecated(message="Use the obtain version that explicitly takes surfaceId as an argument", replaceWith=@ReplaceWith(expression="obtain(surfaceId, viewTag, scrollEventType, scrollX, scrollY, xVelocity, yVelocity, contentWidth, contentHeight, scrollViewWidth, scrollViewHeight)", imports={}))
        @JvmStatic
        @NotNull
        public final ScrollEvent obtain(int viewTag, @Nullable ScrollEventType scrollEventType, float scrollX, float scrollY, float xVelocity, float yVelocity, int contentWidth, int contentHeight, int scrollViewWidth, int scrollViewHeight) {
            return this.obtain(-1, viewTag, scrollEventType, scrollX, scrollY, xVelocity, yVelocity, contentWidth, contentHeight, scrollViewWidth, scrollViewHeight);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

